/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.machine;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtcore.blockentity.BlockEntityDrum;
import org.gtreimagined.gtcore.item.ItemBlockDrum;
import org.gtreimagined.gtcore.machine.BlockMachineMaterial;
import org.gtreimagined.gtcore.machine.MaterialMachine;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;

public class DrumMachine
extends MaterialMachine {
    public final int maxCapacity;
    private boolean acidProof = false;

    public DrumMachine(String domain, Material material, int maxCapacity) {
        super(domain, material.getId() + "_drum", material);
        GTAPI.register(DrumMachine.class, (IGTObject)this);
        this.maxCapacity = maxCapacity;
        this.setTiers(new Tier[]{Tier.NONE});
        this.setTile((materialMachine, blockPos, blockState) -> new BlockEntityDrum(this, blockPos, blockState));
        this.setBlock((type, tier) -> new BlockMachineMaterial((Machine<?>)type, (Tier)tier, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(1.0f, 10.0f)));
        this.setItemBlock(ItemBlockDrum::new);
        this.addTooltipInfo((machine, stack, world, tooltip, flag) -> {
            CompoundTag nbt;
            FluidStack fluid;
            tooltip.add(Utils.translatable((String)"machine.drum.capacity", (Object[])new Object[]{maxCapacity}).m_130940_(ChatFormatting.AQUA));
            if (this.acidProof) {
                tooltip.add(Utils.translatable((String)"gtlib.tooltip.acid_proof", (Object[])new Object[0]));
            }
            FluidStack fluidStack = fluid = (nbt = stack.m_41783_()) != null && nbt.m_128441_("Fluid") ? FluidUtils.fromTag((CompoundTag)nbt.m_128469_("Fluid")) : stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(fi -> fi.getFluidInTank(0)).orElse(FluidStack.EMPTY);
            if (!fluid.isEmpty()) {
                tooltip.add(Utils.translatable((String)"machine.drum.fluid", (Object[])new Object[]{fluid.getAmount(), FluidUtils.getFluidDisplayName((FluidStack)fluid)}).m_130940_(ChatFormatting.AQUA));
            }
            if (nbt != null && nbt.m_128441_("Outputs")) {
                tooltip.add(Utils.translatable((String)"machine.drum.output", (Object[])new Object[0]));
            }
        });
        this.setBaseTexture((m, t, s) -> new Texture[]{new Texture("gtcore", "block/machine/base/drum/bottom"), new Texture("gtcore", "block/machine/base/drum/top"), new Texture("gtcore", "block/machine/base/drum/side"), new Texture("gtcore", "block/machine/base/drum/side"), new Texture("gtcore", "block/machine/base/drum/side"), new Texture("gtcore", "block/machine/base/drum/side")});
        this.setOverlayTextures((type, state, tier, i) -> new Texture[]{new Texture("gtcore", "block/machine/overlay/drum/bottom"), new Texture("gtcore", "block/machine/overlay/drum/top"), new Texture("gtcore", "block/machine/overlay/drum/side"), new Texture("gtcore", "block/machine/overlay/drum/side"), new Texture("gtcore", "block/machine/overlay/drum/side"), new Texture("gtcore", "block/machine/overlay/drum/side")});
    }

    public DrumMachine acidProof() {
        this.acidProof = true;
        return this;
    }

    public boolean isAcidProof() {
        return this.acidProof;
    }
}

