/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.item;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gtcore.data.GTCoreMaterials;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.registration.IColorHandler;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMixedMetal
extends ItemBasic<ItemMixedMetal>
implements IColorHandler {
    public ItemMixedMetal() {
        super("gtcore", "mixed_metal_ingot");
    }

    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        String tagId;
        if (i > 2) {
            return -1;
        }
        CompoundTag stackNbt = stack.m_41783_();
        if (stackNbt == null) {
            return -1;
        }
        CompoundTag nbt = stackNbt.m_128469_("td");
        Material mat = Material.get((String)nbt.m_128461_(tagId = i == 0 ? "tm" : (i == 1 ? "mm" : "bm")));
        if (mat == Material.NULL) {
            return -1;
        }
        return mat.getRGB();
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag stackNbt = stack.m_41783_();
        if (stackNbt == null) {
            super.m_7373_(stack, worldIn, tooltip, flagIn);
            return;
        }
        CompoundTag nbt = stackNbt.m_128469_("td");
        Material t = Material.get((String)nbt.m_128461_("tm"));
        Material m = Material.get((String)nbt.m_128461_("mm"));
        Material b = Material.get((String)nbt.m_128461_("bm"));
        tooltip.add((Component)Utils.literal((String)("Top Material: " + t.getDisplayName().getString())));
        tooltip.add((Component)Utils.literal((String)("Middle Material: " + m.getDisplayName().getString())));
        tooltip.add((Component)Utils.literal((String)("Bottom Material: " + b.getDisplayName().getString())));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public void fillItemCategory(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.allowedIn(group)) {
            ItemStack itemStack = this.m_7968_();
            items.add((Object)itemStack);
        }
    }

    @NotNull
    public ItemStack m_7968_() {
        return this.getMixedMetalIngot(GTCoreMaterials.WroughtIron, GTCoreMaterials.Brass, GTCoreMaterials.Tin);
    }

    public ItemStack getMixedMetalIngot(Material top, Material middle, Material bottom) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("tm", top.getId());
        nbt.m_128359_("mm", middle.getId());
        nbt.m_128359_("bm", bottom.getId());
        itemStack.m_41784_().m_128365_("td", (Tag)nbt);
        return itemStack;
    }

    public Texture[] getTextures() {
        return new Texture[]{new Texture(this.getDomain(), "item/basic/" + this.getId() + "_top"), new Texture(this.getDomain(), "item/basic/" + this.getId() + "_middle"), new Texture(this.getDomain(), "item/basic/" + this.getId() + "_bottom")};
    }
}

