/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.item;

import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.item.ScannerItem;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.registration.IColorHandler;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMagnifyingGlass
extends ScannerItem
implements IColorHandler {
    public final Material material;

    public ItemMagnifyingGlass(Material material, int durability) {
        super("gtcore", material.getId() + "_magnifying_glass", true, "magnifying_glass/", new Item.Properties().m_41499_(durability));
        this.material = material;
    }

    public boolean allowedIn(CreativeModeTab tab) {
        return tab == Ref.TAB_TOOLS;
    }

    @NotNull
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        InteractionResult result = super.onItemUseFirst(stack, context);
        if (result == InteractionResult.SUCCESS && context.m_43723_() != null) {
            Utils.damageStack((ItemStack)context.m_43722_(), (LivingEntity)context.m_43723_());
        }
        return result;
    }

    public Texture[] getTextures() {
        return new Texture[]{new Texture(this.domain, "item/basic/" + this.subDir + "base"), new Texture(this.domain, "item/basic/" + this.subDir + "overlay")};
    }

    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        return i == 0 ? this.material.getRGB() : -1;
    }
}

