/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamresourceful.resourcefullib.common.networking.base.NetworkDirection;
import com.terraformersmc.terraform.boat.api.client.TerraformBoatClientHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gtreimagined.gtcore.BookRegistration;
import org.gtreimagined.gtcore.GTCoreConfig;
import org.gtreimagined.gtcore.client.BakedModels;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtcore.data.GTCoreCables;
import org.gtreimagined.gtcore.data.GTCoreCovers;
import org.gtreimagined.gtcore.data.GTCoreData;
import org.gtreimagined.gtcore.data.GTCoreFluids;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreMaterials;
import org.gtreimagined.gtcore.data.GTCoreTools;
import org.gtreimagined.gtcore.data.Guis;
import org.gtreimagined.gtcore.data.MenuHandlers;
import org.gtreimagined.gtcore.data.SlotTypes;
import org.gtreimagined.gtcore.data.client.ScreenFactories;
import org.gtreimagined.gtcore.datagen.GTCoreBlockLootProvider;
import org.gtreimagined.gtcore.datagen.GTCoreBlockTagProvider;
import org.gtreimagined.gtcore.datagen.GTCoreItemTagProvider;
import org.gtreimagined.gtcore.datagen.GTCoreLang;
import org.gtreimagined.gtcore.events.GTCommonEvents;
import org.gtreimagined.gtcore.integration.curio.CurioPlugin;
import org.gtreimagined.gtcore.integration.top.MassStorageProvider;
import org.gtreimagined.gtcore.integration.top.RedstoneWireProvider;
import org.gtreimagined.gtcore.loader.crafting.MachineRecipes;
import org.gtreimagined.gtcore.loader.crafting.MaterialRecipes;
import org.gtreimagined.gtcore.loader.crafting.MiscRecipes;
import org.gtreimagined.gtcore.loader.crafting.Pipes;
import org.gtreimagined.gtcore.loader.crafting.RubberRecipes;
import org.gtreimagined.gtcore.loader.crafting.Tools;
import org.gtreimagined.gtcore.loader.crafting.VanillaRecipes;
import org.gtreimagined.gtcore.network.MessageCraftingSync;
import org.gtreimagined.gtcore.network.MessageInventorySync;
import org.gtreimagined.gtcore.network.MessageTriggerInventorySync;
import org.gtreimagined.gtcore.proxy.ClientHandler;
import org.gtreimagined.gtcore.proxy.CommonHandler;
import org.gtreimagined.gtcore.tree.RubberFoliagePlacer;
import org.gtreimagined.gtcore.tree.RubberTree;
import org.gtreimagined.gtcore.tree.RubberTreeWorldGen;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTMod;
import org.gtreimagined.gtlib.common.event.PlayerTickCallback;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.GTLibDynamics;
import org.gtreimagined.gtlib.datagen.builder.GTTagBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTBlockStateProvider;
import org.gtreimagined.gtlib.datagen.providers.GTBlockTagProvider;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.datagen.providers.GTTagProvider;
import org.gtreimagined.gtlib.datagen.providers.GTWorldgenProvider;
import org.gtreimagined.gtlib.event.GTCraftingEvent;
import org.gtreimagined.gtlib.event.GTProvidersEvent;
import org.gtreimagined.gtlib.event.MaterialEvent;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.network.GTLibNetwork;
import org.gtreimagined.gtlib.registration.RegistrationEvent;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.TagUtils;

@Mod(value="gtcore")
public class GTCore
extends GTMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String ID = "gtcore";
    public static final String NAME = "GT Core";
    public static final ResourceLocation SYNC_ID = new ResourceLocation("gtcore", "crafting_sync");
    public static final ResourceLocation INV_SYNC_ID = new ResourceLocation("gtcore", "inventory_sync");
    public static final ResourceLocation TRIGGER_SYNC_ID = new ResourceLocation("gtcore", "trigger_sync");

    public GTCore() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::onProvidersEvent);
        eventBus.addListener(this::onCraftingEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onItemUse);
        MinecraftForge.EVENT_BUS.addListener(GTCommonEvents::onTooltipAdd);
        eventBus.addListener(this::onRegistration);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            eventBus.addListener(this::clientSetup);
            TerraformBoatClientHelper.registerModelLayers((ResourceLocation)new ResourceLocation(ID, "rubber"), (boolean)false);
        });
        if (GTAPI.isModLoaded((String)"curios")) {
            eventBus.addListener(CurioPlugin::loadIMC);
        }
        GTLibDynamics.clientProvider((String)ID, () -> new GTBlockStateProvider(ID, "GT Core BlockStates"));
        GTLibDynamics.clientProvider((String)ID, () -> new GTItemModelProvider(ID, "GT Core Item Models"));
        GTLibDynamics.clientProvider((String)ID, GTCoreLang.en_US::new);
        GTCoreConfig.createConfig();
    }

    private void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity().m_21120_(event.getHand()).m_204117_(GTMaterialTypes.DUST.getMaterialTag(GTCoreMaterials.Beeswax))) {
            event.setCancellationResult(Items.f_42784_.m_6225_(new UseOnContext(event.getEntity(), event.getHand(), event.getHitVec())));
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        ClientHandler.init();
    }

    private void onProvidersEvent(GTProvidersEvent event) {
        GTBlockTagProvider[] p = new GTBlockTagProvider[1];
        event.addProvider(() -> {
            p[0] = new GTCoreBlockTagProvider(ID, NAME.concat(" Block Tags"), false);
            return p[0];
        });
        event.addProvider(() -> new GTCoreItemTagProvider(ID, NAME.concat(" Item Tags"), false, p[0]));
        event.addProvider(() -> new GTCoreBlockLootProvider(ID, NAME.concat(" Loot generator")));
        event.addProvider(() -> new GTTagProvider<Biome>(Registries.f_256952_, ID, NAME.concat(" Biome Tags"), "worldgen/biome", null){

            protected void processTags(String domain) {
                GTTagBuilder tags = this.tag(TagUtils.getBiomeTag((ResourceLocation)new ResourceLocation(GTCore.ID, "is_invalid_rubber"))).addTag(BiomeTags.f_207609_).addTag(BiomeTags.f_207606_).addTag(BiomeTags.f_207603_).addTag(BiomeTags.f_207602_).addTag(BiomeTags.f_207612_).addTag(TagUtils.getBiomeTag((ResourceLocation)new ResourceLocation("is_desert"))).addTag(TagUtils.getBiomeTag((ResourceLocation)new ResourceLocation("is_plains")));
                tags.addTag(TagUtils.getBiomeTag((ResourceLocation)new ResourceLocation("forge", "is_end")));
                tags.addTag(TagUtils.getBiomeTag((ResourceLocation)new ResourceLocation("forge", "is_snowy")));
            }
        });
        event.addProvider(() -> new GTTagProvider<ConfiguredFeature<?, ?>>(Registries.f_256911_, ID, NAME.concat(" Configured Feature Tags"), "worldgen/configured_feature", null){

            protected void processTags(String domain) {
                if (GTAPI.isModLoaded((String)"tfc")) {
                    this.tag(TagKey.m_203882_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("tfc", "forest_trees"))).add(ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation(GTCore.ID, "tree/rubber_entry")));
                }
            }
        });
        event.addProvider(() -> new GTWorldgenProvider(ID, NAME.concat(" Configured Features"), "configured_feature"){

            public void run() {
                if (!GTAPI.isModLoaded((String)"tfc")) {
                    return;
                }
                JsonObject object = new JsonObject();
                object.addProperty("type", "tfc:random_tree");
                JsonObject config = new JsonObject();
                JsonArray structures = new JsonArray();
                structures.add("gtcore:rubber_dead/1");
                structures.add("gtcore:rubber_dead/2");
                structures.add("gtcore:rubber_dead/3");
                structures.add("gtcore:rubber_dead/4");
                config.add("structures", (JsonElement)structures);
                config.addProperty("radius", (Number)1);
                JsonObject placement = new JsonObject();
                placement.addProperty("width", (Number)1);
                placement.addProperty("height", (Number)9);
                placement.addProperty("allow_submerged", Boolean.valueOf(true));
                placement.addProperty("allow_deeply_submerged", Boolean.valueOf(false));
                config.add("placement", (JsonElement)placement);
                object.add("config", (JsonElement)config);
                this.addJsonObject(new ResourceLocation(GTCore.ID, "tree/rubber_dead"), object);
                object = new JsonObject();
                object.addProperty("type", "tfc:forest_entry");
                config = new JsonObject();
                JsonObject climate = new JsonObject();
                climate.addProperty("min_rain", (Number)250);
                climate.addProperty("max_rain", (Number)400);
                climate.addProperty("min_temp", (Number)15.0);
                climate.addProperty("max_temp", (Number)40.0);
                config.add("climate", (JsonElement)climate);
                JsonArray groundCover = new JsonArray();
                JsonObject block = new JsonObject();
                block.addProperty("block", "gtcore:rubber_twig");
                groundCover.add((JsonElement)block);
                block = new JsonObject();
                block.addProperty("block", "gtcore:rubber_fallen_leaves");
                groundCover.add((JsonElement)block);
                config.add("groundcover", (JsonElement)groundCover);
                config.addProperty("normal_tree", "gtcore:rubber_tree_normal");
                config.addProperty("dead_tree", "gtcore:tree/rubber_dead");
                config.addProperty("fallen_log", "gtcore:rubber_log");
                object.add("config", (JsonElement)config);
                this.addJsonObject(new ResourceLocation(GTCore.ID, "tree/rubber_entry"), object);
            }
        });
    }

    private void onCraftingEvent(GTCraftingEvent event) {
        event.addLoader(MachineRecipes::initRecipes);
        event.addLoader(RubberRecipes::addRecipes);
        event.addLoader(MaterialRecipes::loadMaterialRecipes);
        event.addLoader(Pipes::loadRecipes);
        event.addLoader(Tools::init);
        event.addLoader(VanillaRecipes::loadRecipes);
        event.addLoader(MiscRecipes::loadRecipes);
    }

    private void onRegistration(RegisterEvent event) {
        if (event.getRegistryKey() == ForgeRegistries.Keys.FOLIAGE_PLACER_TYPES) {
            ForgeRegistries.FOLIAGE_PLACER_TYPES.register(new ResourceLocation(ID, "rubber_foilage_placer"), RubberFoliagePlacer.RUBBER);
        }
    }

    public void onRegistrationEvent(RegistrationEvent event, Dist side) {
        switch (event) {
            case DATA_INIT: {
                SlotTypes.init();
                MenuHandlers.init();
                GTCoreData.init();
                GTCoreCovers.init();
                GTCoreBlocks.init();
                GTCoreItems.init();
                GTCoreFluids.init();
                GTCoreMaterials.init();
                GTCoreCables.init();
                GTCoreTools.init(side);
                RubberTree.init();
                RubberTreeWorldGen.init();
                if (GTAPI.isModLoaded((String)"theoneprobe")) {
                    MassStorageProvider.createTopProvider();
                    RedstoneWireProvider.createTopProvider();
                }
                PlayerTickCallback.PLAYER_TICK_CALLBACKS.add(GTCommonEvents::onPlayerTick);
                GTLibNetwork.NETWORK.registerPacket(NetworkDirection.CLIENT_TO_SERVER, SYNC_ID, MessageCraftingSync.HANDLER, MessageCraftingSync.class);
                GTLibNetwork.NETWORK.registerPacket(NetworkDirection.SERVER_TO_CLIENT, INV_SYNC_ID, MessageInventorySync.HANDLER, MessageInventorySync.class);
                GTLibNetwork.NETWORK.registerPacket(NetworkDirection.CLIENT_TO_SERVER, TRIGGER_SYNC_ID, MessageTriggerInventorySync.HANDLER, MessageTriggerInventorySync.class);
                break;
            }
            case DATA_READY: {
                WoodType.m_61844_((WoodType)GTCoreBlocks.RUBBER_WOOD_TYPE);
                CommonHandler.setup();
                BookRegistration.registerBooks();
                GTLibXEIPlugin.addItemsToHide(l -> {
                    l.add(((IGTTool)GTAPI.get(IGTTool.class, (String)"electric_wrench_alt_lv", (String)ID)).getItem());
                    l.add(((IGTTool)GTAPI.get(IGTTool.class, (String)"electric_wrench_alt_mv", (String)ID)).getItem());
                    l.add(((IGTTool)GTAPI.get(IGTTool.class, (String)"electric_wrench_alt_hv", (String)ID)).getItem());
                    if (GTCoreConfig.DISABLE_WOOD_TOOLS.get()) {
                        l.addAll(Arrays.asList(Items.f_42423_, Items.f_42424_, Items.f_42422_, Items.f_42420_));
                    }
                    if (!GTCoreConfig.VILLAGER_TRADE_REPLACEMENTS.get()) {
                        l.add(GTCoreItems.GTCredit);
                    }
                    if (!GTAPI.isModLoaded((String)"tfc")) {
                        l.addAll(List.of(GTCoreItems.ChiselHeadShape, GTCoreItems.JavelinHeadShape, GTCoreItems.PropickHeadShape, GTCoreItems.MaceHeadShape));
                    }
                    for (int i = 1; i < 25; ++i) {
                        l.add((ItemLike)GTCoreItems.SELECTOR_TAG_ITEMS.get((Object)i));
                    }
                    GTAPI.all(IGTTool.class).stream().filter(t -> {
                        GTToolType toolType = t.getGTToolType();
                        return toolType == GTCoreTools.POCKET_MULTITOOL_SCISSORS || toolType == GTCoreTools.POCKET_MULTITOOL_FILE || toolType == GTCoreTools.POCKET_MULTITOOL_KNIFE || toolType == GTCoreTools.POCKET_MULTITOOL_SAW || toolType == GTCoreTools.POCKET_MULTITOOL_SCREWDRIVER || toolType == GTCoreTools.POCKET_MULTITOOL_WIRE_CUTTER;
                    }).forEach(tool -> l.add(tool.getItem()));
                });
                break;
            }
            case CLIENT_DATA_INIT: {
                BakedModels.init();
                ScreenFactories.init();
            }
        }
    }

    public String getId() {
        return ID;
    }

    public void onMaterialEvent(MaterialEvent event) {
        event.setMaterial(GTCoreMaterials.Rubber).asSolid(295, new IMaterialTag[]{GTMaterialTypes.PLATE, GTMaterialTypes.RING});
        event.setMaterial(GTCoreMaterials.Plastic).flags(new IMaterialTag[]{MaterialTags.RUBBERTOOLS});
        event.setMaterial(GTCoreMaterials.Beeswax).asDust(new IMaterialTag[0]);
        event.setMaterial(GTCoreMaterials.FierySteel).asMetal(new IMaterialTag[0]).tool().toolDamage(4.0f).toolSpeed(9.0f).toolDurability(1024).toolQuality(4).toolEnchantments(ImmutableMap.of((Object)Enchantments.f_44981_, (Object)2)).handleMaterial(GTLibMaterials.Blaze).blacklistToolTypes(new GTToolType[]{GTTools.PICKAXE, GTTools.SWORD}).build();
        event.setMaterial(GTCoreMaterials.Knightmetal).asMetal(new IMaterialTag[0]).tool().toolDamage(3.0f).toolSpeed(8.0f).toolDurability(512).toolQuality(3).blacklistToolTypes(new GTToolType[]{GTTools.AXE, GTTools.PICKAXE, GTTools.SWORD}).build();
        event.setMaterial(GTCoreMaterials.Ironwood).asMetal(new IMaterialTag[]{MaterialTags.WOOD}).tool().toolDamage(2.0f).toolSpeed(6.5f).toolDurability(512).toolQuality(2).toolEnchantments(ImmutableMap.of((Object)Enchantments.f_44980_, (Object)1)).blacklistToolTypes(new GTToolType[]{GTTools.AXE, GTTools.PICKAXE, GTTools.SHOVEL, GTTools.SWORD, GTTools.HOE}).build();
        event.setMaterial(GTCoreMaterials.Steeleaf).asMetal(new IMaterialTag[0]).tool().toolDamage(4.0f).toolSpeed(8.0f).toolDurability(131).toolQuality(3).toolEnchantments(ImmutableMap.of((Object)Enchantments.f_44982_, (Object)2, (Object)Enchantments.f_44987_, (Object)2)).blacklistToolTypes(new GTToolType[]{GTTools.AXE, GTTools.PICKAXE, GTTools.SHOVEL, GTTools.SWORD, GTTools.HOE}).build();
        if (GTAPI.isModLoaded((String)"twilightforest")) {
            GTMaterialTypes.INGOT.replacement(GTCoreMaterials.Ironwood, () -> RegistryUtils.getItemFromID((String)"twilightforest", (String)"ironwood_ingot"));
            GTMaterialTypes.BLOCK.replacement(GTCoreMaterials.Ironwood, () -> RegistryUtils.getItemFromID((String)"twilightforest", (String)"ironwood_block"));
            GTMaterialTypes.INGOT.replacement(GTCoreMaterials.Knightmetal, () -> RegistryUtils.getItemFromID((String)"twilightforest", (String)"knightmetal_ingot"));
            GTMaterialTypes.BLOCK.replacement(GTCoreMaterials.Knightmetal, () -> RegistryUtils.getItemFromID((String)"twilightforest", (String)"knightmetal_block"));
            GTMaterialTypes.INGOT.replacement(GTCoreMaterials.Steeleaf, () -> RegistryUtils.getItemFromID((String)"twilightforest", (String)"steeleaf_ingot"));
            GTMaterialTypes.BLOCK.replacement(GTCoreMaterials.Steeleaf, () -> RegistryUtils.getItemFromID((String)"twilightforest", (String)"steeleaf_block"));
            GTMaterialTypes.INGOT.replacement(GTCoreMaterials.FierySteel, () -> RegistryUtils.getItemFromID((String)"twilightforest", (String)"fiery_ingot"));
            GTMaterialTypes.BLOCK.replacement(GTCoreMaterials.FierySteel, () -> RegistryUtils.getItemFromID((String)"twilightforest", (String)"fiery_block"));
        }
        event.setMaterial(GTCoreMaterials.Signalum).asMetal(1353, new IMaterialTag[0]).mats(ImmutableMap.of((Object)GTLibMaterials.Copper, (Object)1, (Object)GTCoreMaterials.Silver, (Object)2, (Object)GTCoreMaterials.RedAlloy, (Object)5));
        event.setMaterial(GTCoreMaterials.Lumium).asMetal(593, new IMaterialTag[0]).mats(ImmutableMap.of((Object)GTCoreMaterials.Tin, (Object)3, (Object)GTCoreMaterials.Silver, (Object)1, (Object)GTLibMaterials.Glowstone, (Object)4));
        event.setMaterial(GTCoreMaterials.Enderium).asMetal(1071, new IMaterialTag[0]).mats(ImmutableMap.of((Object)GTCoreMaterials.Tin, (Object)2, (Object)GTCoreMaterials.Silver, (Object)1, (Object)GTCoreMaterials.Platinum, (Object)1, (Object)GTLibMaterials.EnderPearl, (Object)4));
        if (GTAPI.isModLoaded((String)"thermal")) {
            GTMaterialTypes.INGOT.replacement(GTCoreMaterials.Signalum, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"signalum_ingot"));
            GTMaterialTypes.DUST.replacement(GTCoreMaterials.Signalum, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"signalum_dust"));
            GTMaterialTypes.NUGGET.replacement(GTCoreMaterials.Signalum, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"signalum_nugget"));
            GTMaterialTypes.BLOCK.replacement(GTCoreMaterials.Signalum, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"signalum_block"));
            GTMaterialTypes.GEAR.replacement(GTCoreMaterials.Signalum, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"signalum_gear"));
            GTMaterialTypes.PLATE.replacement(GTCoreMaterials.Signalum, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"signalum_plate"));
            GTMaterialTypes.INGOT.replacement(GTCoreMaterials.Lumium, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"lumium_ingot"));
            GTMaterialTypes.DUST.replacement(GTCoreMaterials.Lumium, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"lumium_dust"));
            GTMaterialTypes.NUGGET.replacement(GTCoreMaterials.Lumium, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"lumium_nugget"));
            GTMaterialTypes.BLOCK.replacement(GTCoreMaterials.Lumium, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"lumium_block"));
            GTMaterialTypes.GEAR.replacement(GTCoreMaterials.Lumium, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"lumium_gear"));
            GTMaterialTypes.PLATE.replacement(GTCoreMaterials.Lumium, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"lumium_plate"));
            GTMaterialTypes.INGOT.replacement(GTCoreMaterials.Enderium, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"enderium_ingot"));
            GTMaterialTypes.DUST.replacement(GTCoreMaterials.Enderium, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"enderium_dust"));
            GTMaterialTypes.NUGGET.replacement(GTCoreMaterials.Enderium, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"enderium_nugget"));
            GTMaterialTypes.BLOCK.replacement(GTCoreMaterials.Enderium, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"enderium_block"));
            GTMaterialTypes.GEAR.replacement(GTCoreMaterials.Enderium, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"enderium_gear"));
            GTMaterialTypes.PLATE.replacement(GTCoreMaterials.Enderium, () -> RegistryUtils.getItemFromID((String)"thermal", (String)"enderium_plate"));
        }
        GTCoreBlocks.initItemBarrels();
        Guis.init();
    }
}

