/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.gui;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.gtreimagined.gtcore.blockentity.BlockEntityMaterial;
import org.gtreimagined.gtcore.gui.InventoryWorkbench;
import org.gtreimagined.gtcore.gui.slots.SlotWorkTableResult;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.gui.MenuHandlerMachine;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.container.ContainerMachine;

public class ContainerWorkbench<T extends BlockEntityMaterial<T>>
extends ContainerMachine<T> {
    private CraftingContainer craftingGrid;
    private ResultContainer craftResult;

    public ContainerWorkbench(T tile, Inventory playerInv, MenuHandlerMachine<T, ContainerMachine<T>> menuHandler, int windowId) {
        super(tile, playerInv, menuHandler, windowId);
        this.m_6199_((Container)this.craftingGrid);
    }

    protected void addSlots(BlockEntityMachine<?> tile) {
        this.craftResult = new ResultContainer();
        this.craftingGrid = new InventoryWorkbench((AbstractContainerMenu)this, tile.itemHandler.map(m -> m).orElse(null), 3, 3);
        this.m_38897_((Slot)new SlotWorkTableResult(tile.itemHandler.map(m -> m).orElse(null), this.playerInv.f_35978_, this.craftingGrid, this.craftResult, 0, 136, 64));
        Object2IntOpenHashMap slotIndexMap = new Object2IntOpenHashMap();
        int i = 1;
        for (SlotData slot : tile.getMachineType().getSlots(tile.getMachineTier())) {
            slotIndexMap.computeIntIfAbsent((Object)slot.getType().getId(), k -> 0);
            ++i;
            Slot supplier = slot.getType().getId().equals("crafting") ? new Slot((Container)this.craftingGrid, slotIndexMap.getInt((Object)slot.getType().getId()), slot.getX(), slot.getY()) : slot.getType().getSlotSupplier().get(slot.getType(), tile, tile.itemHandler.map(t -> t.getAll()).orElse(Collections.emptyMap()), slotIndexMap.getInt((Object)slot.getType().getId()), slot);
            this.m_38897_(supplier);
            slotIndexMap.computeInt((Object)slot.getType().getId(), (a, b) -> {
                if (b == null) {
                    return 0;
                }
                return b + 1;
            });
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    protected static void updateCrafting(int id, int stateID, Level world, Player playerEntity, CraftingContainer craftingInventory, ResultContainer craftResultInventory) {
        if (!world.f_46443_) {
            CraftingRecipe icraftingrecipe;
            ServerPlayer serverplayerentity = (ServerPlayer)playerEntity;
            ItemStack itemstack = ItemStack.f_41583_;
            Optional optional = world.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)craftingInventory, world);
            if (optional.isPresent() && craftResultInventory.m_40135_(world, serverplayerentity, (Recipe)(icraftingrecipe = (CraftingRecipe)optional.get()))) {
                itemstack = icraftingrecipe.m_5874_((Container)craftingInventory, world.m_9598_());
            }
            craftResultInventory.m_6836_(0, itemstack);
            serverplayerentity.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(id, stateID, 0, itemstack));
        }
    }

    public void m_6199_(Container inventoryIn) {
        ContainerWorkbench.updateCrafting(this.f_38840_, this.m_182424_(), this.playerInv.f_35978_.m_20193_(), this.playerInv.f_35978_, this.craftingGrid, this.craftResult);
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void clearCraftingGrid() {
        for (int i = 17; i < 26; ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (!slot.m_6657_()) continue;
            this.m_38903_(slot.m_7993_(), 1, 17, false);
            if (slot.m_7993_().m_41613_() > 0) continue;
            slot.m_5852_(ItemStack.f_41583_);
        }
    }

    public void clearCraftingGridToPlayer() {
        for (int i = 17; i < 26; ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (!slot.m_6657_()) continue;
            this.m_38903_(slot.m_7993_(), 34, 70, false);
            if (slot.m_7993_().m_41613_() > 0) continue;
            slot.m_5852_(ItemStack.f_41583_);
        }
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.craftResult && super.m_5882_(stack, slotIn);
    }

    public CraftingContainer getCraftingGrid() {
        return this.craftingGrid;
    }

    public ItemStack m_7648_(Player player, int slotId) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotId);
        if (slot.m_6657_() && slotId == 0) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (!this.m_38903_(itemstack1, 32, 68, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                this.m_6199_((Container)this.craftingGrid);
                return ItemStack.f_41583_;
            }
            slot.m_40234_(itemstack, itemstack1);
            slot.m_142406_(player, itemstack1);
            player.m_36176_(itemstack1, false);
            this.m_6199_((Container)this.craftingGrid);
            return itemstack;
        }
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (slotId < this.invSize) {
                if (!this.m_38903_(slotStack, this.invSize, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (!this.m_38903_(slotStack, 0, 17, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(slotStack, 26, this.invSize, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }
}

