/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.tree.item;

import com.terraformersmc.terraform.boat.api.TerraformBoatType;
import com.terraformersmc.terraform.boat.api.TerraformBoatTypeRegistry;
import com.terraformersmc.terraform.boat.api.item.TerraformBoatItemHelper;
import com.terraformersmc.terraform.boat.impl.item.TerraformBoatItem;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.registration.IModelProvider;
import org.gtreimagined.gtlib.registration.IRegistryEntryProvider;
import org.gtreimagined.gtlib.registration.ITextureProvider;
import org.gtreimagined.gtlib.texture.Texture;

public class ItemRubberBoat
extends TerraformBoatItem
implements IGTObject,
ITextureProvider,
IModelProvider,
IRegistryEntryProvider {
    private static final Predicate<Entity> RIDERS = EntitySelector.f_20408_.and(Entity::m_6087_);
    static TerraformBoatType RUBBER_BOAT_TYPE;
    private final boolean chest;

    public ItemRubberBoat(boolean chest) {
        super(() -> RUBBER_BOAT_TYPE, chest, new Item.Properties().m_41491_(Ref.TAB_ITEMS).m_41487_(1));
        this.chest = chest;
        GTAPI.register(ItemRubberBoat.class, (IGTObject)this);
        if (!chest) {
            GTAPI.register(IRegistryEntryProvider.class, (IGTObject)this);
        }
        TerraformBoatItemHelper.registerBoatDispenserBehavior((ItemLike)this, () -> RUBBER_BOAT_TYPE, (boolean)chest);
    }

    public static void initBoatType() {
        RUBBER_BOAT_TYPE = new TerraformBoatType.Builder().item((Item)GTCoreItems.RubberBoat).chestItem((Item)GTCoreItems.RubberChestBoat).planks(GTCoreBlocks.RUBBER_PLANKS.m_5456_()).build();
        Registry.m_122965_((Registry)TerraformBoatTypeRegistry.INSTANCE, (ResourceLocation)new ResourceLocation("gtcore", "rubber"), (Object)RUBBER_BOAT_TYPE);
    }

    public String getId() {
        return "rubber" + (this.chest ? "_chest" : "") + "_boat";
    }

    public String getDomain() {
        return "gtcore";
    }

    public Texture[] getTextures() {
        return new Texture[]{new Texture("gtcore", "item/basic/rubber" + (this.chest ? "_chest" : "") + "_boat")};
    }

    public void onRegistryBuild(ResourceKey<? extends Registry<?>> resourceKey) {
        if (resourceKey == ForgeRegistries.Keys.ENCHANTMENTS && RUBBER_BOAT_TYPE == null) {
            ItemRubberBoat.initBoatType();
        }
    }
}

