/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.tree.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.tree.ResinState;
import org.gtreimagined.gtcore.tree.block.BlockRubberWood;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.builder.VariantBlockStateBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTBlockStateProvider;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;

public class BlockRubberLog
extends BlockRubberWood {
    public static final DirectionProperty RESIN_FACING = BlockStateProperties.f_61374_;
    private static final double CHANCE_FILL = 0.3;

    public BlockRubberLog(String domain, String id) {
        super(domain, id, BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60977_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(ResinState.INSTANCE, (Comparable)((Object)ResinState.NONE))).m_61124_((Property)RESIN_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ResinState.INSTANCE, RESIN_FACING, f_55923_});
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (state.m_61143_(ResinState.INSTANCE) != ResinState.EMPTY) {
            return;
        }
        if (random.m_188500_() < 0.3) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_(ResinState.INSTANCE, (Comparable)((Object)ResinState.FILLED)), 3);
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        DiggerItem diggerItem;
        ItemStack stack;
        Item item;
        if (Utils.isPlayerHolding((Player)player, (InteractionHand)handIn, (GTToolType[])new GTToolType[]{GTTools.KNIFE}) && state.m_61143_(ResinState.INSTANCE) == ResinState.FILLED && !worldIn.f_46443_) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_(ResinState.INSTANCE, (Comparable)((Object)ResinState.EMPTY)), 3);
            Direction dir = (Direction)state.m_61143_((Property)RESIN_FACING);
            BlockPos spawnPos = pos.m_7918_(dir.m_122429_(), dir.m_122430_(), dir.m_122431_());
            Containers.m_18992_((Level)worldIn, (double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_(), (ItemStack)GTCoreItems.StickyResin.get(1));
            if (worldIn.f_46441_.m_188500_() > 0.5) {
                Containers.m_18992_((Level)worldIn, (double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_(), (ItemStack)GTCoreItems.StickyResin.get(1));
            }
            player.m_21120_(handIn).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(handIn));
            return InteractionResult.SUCCESS;
        }
        if (this == GTCoreBlocks.RUBBER_LOG && (item = (stack = player.m_21120_(handIn)).m_41720_()) instanceof DiggerItem && (diggerItem = (DiggerItem)item).m_8102_(stack, state) > 1.0f) {
            worldIn.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!worldIn.f_46443_) {
                BlockState target = (BlockState)((BlockState)((BlockState)GTCoreBlocks.STRIPPED_RUBBER_LOG.m_49966_().m_61124_((Property)f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)f_55923_)))).m_61124_(ResinState.INSTANCE, (Comparable)((Object)((ResinState)((Object)state.m_61143_(ResinState.INSTANCE)))))).m_61124_((Property)RESIN_FACING, (Comparable)((Direction)state.m_61143_((Property)RESIN_FACING)));
                worldIn.m_46597_(pos, target);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(handIn));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_55923_, (Comparable)context.m_43719_().m_122434_())).m_61124_((Property)RESIN_FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(ResinState.INSTANCE, (Comparable)((Object)ResinState.NONE));
    }

    public void onBlockModelBuild(Block block, GTBlockStateProvider prov) {
        ResourceLocation rubberLog = prov.existing("gtcore", "block/" + this.id);
        ResourceLocation rubberLogEmpty = prov.existing("gtcore", "block/" + this.id + "_empty");
        ResourceLocation rubberLogFilled = prov.existing("gtcore", "block/" + this.id + "_filled");
        prov.getVariantBuilder(block).forAllStates(s -> new VariantBlockStateBuilder.VariantBuilder().modelFile(s.m_61143_(ResinState.INSTANCE) == ResinState.NONE ? rubberLog : (s.m_61143_(ResinState.INSTANCE) == ResinState.EMPTY ? rubberLogEmpty : rubberLogFilled)).rotationY((int)((Direction)s.m_61143_((Property)RESIN_FACING)).m_122424_().m_122435_()).rotationX(s.m_61143_((Property)f_55923_) == Direction.Axis.Y ? 0 : 90));
    }
}

