/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.loader.crafting;

import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraftforge.common.Tags;
import org.gtreimagined.gtcore.GTCoreConfig;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreMaterials;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.util.RegistryUtils;

public class VanillaRecipes {
    public static void loadRecipes(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider) {
        provider.addStackRecipe(consumer, "gtcore", "lead_from_resin", "", new ItemStack((ItemLike)Items.f_42655_, 2), ImmutableMap.of((Object)Character.valueOf('S'), (Object)Items.f_42401_, (Object)Character.valueOf('R'), GTCoreItems.StickyResin), new String[]{"SS ", "SR ", "  S"});
        if (!GTAPI.isModLoaded((String)"tfc")) {
            provider.shapeless(consumer, "gravel_to_flint", "mortar_recipes", new ItemStack((ItemLike)Items.f_42484_), new Object[]{GTTools.MORTAR.getTag(), Items.f_41832_});
        }
        provider.addItemRecipe(consumer, "gtcore", "piston_sticky", "gears", (ItemLike)Blocks.f_50032_, ImmutableMap.of((Object)Character.valueOf('S'), GTCoreItems.StickyResin, (Object)Character.valueOf('P'), (Object)Blocks.f_50039_), new String[]{"S", "P"});
        SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{GTCoreBlocks.BASALT.getState().m_60734_()}), (ItemLike)Items.f_42051_).m_126132_("has_basalt", provider.hasSafeItem((ItemLike)GTCoreBlocks.BASALT.getState().m_60734_())).m_126140_(consumer, new ResourceLocation("gtcore", "basalt_to_vanilla_basalt"));
        SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{GTCoreBlocks.BASALT.getState().m_60734_()}), (ItemLike)Items.f_42052_).m_126132_("has_basalt", provider.hasSafeItem((ItemLike)GTCoreBlocks.BASALT.getState().m_60734_())).m_126140_(consumer, new ResourceLocation("gtcore", "basalt_to_vanilla_polished_basalt"));
        SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{GTCoreBlocks.BASALT.getState().m_60734_()}), (ItemLike)Items.f_151026_).m_126132_("has_basalt", provider.hasSafeItem((ItemLike)GTCoreBlocks.BASALT.getState().m_60734_())).m_126140_(consumer, new ResourceLocation("gtcore", "basalt_to_vanilla_smooth_basalt"));
        SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42051_}), (ItemLike)GTCoreBlocks.BASALT.getState().m_60734_().m_5456_()).m_126132_("has_basalt", provider.hasSafeItem((ItemLike)Items.f_42051_)).m_126140_(consumer, new ResourceLocation("gtcore", "vanilla_basalt_to_basalt"));
        VanillaRecipes.loadOverrides(consumer, provider);
        VanillaRecipes.loadWood(consumer, provider);
    }

    private static void loadOverrides(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider) {
        if (GTCoreConfig.DISABLE_WOOD_TOOLS.get()) {
            provider.removeRecipe(new ResourceLocation("wooden_axe"));
            provider.removeRecipe(new ResourceLocation("wooden_pickaxe"));
            provider.removeRecipe(new ResourceLocation("wooden_hoe"));
            provider.removeRecipe(new ResourceLocation("wooden_sword"));
        }
        if (GTCoreConfig.DISABLE_CHARCOAL_SMELTING.get()) {
            provider.removeRecipe(new ResourceLocation("charcoal"));
            provider.removeRecipe(new ResourceLocation("energizedpower", "smelting/charcoal_from_smelting_sawdust_block"));
        }
        if (GTCoreConfig.HONEYCOMB_REPLACEMENT.get()) {
            for (WeatheringCopper.WeatherState weatherState : WeatheringCopper.WeatherState.values()) {
                String prefix;
                String string = prefix = weatherState == WeatheringCopper.WeatherState.UNAFFECTED ? "" : weatherState.name().toLowerCase() + "_";
                if (prefix.isEmpty()) {
                    VanillaRecipes.addBeeswaxRecipe(consumer, provider, "copper_block");
                } else {
                    VanillaRecipes.addBeeswaxRecipe(consumer, provider, prefix + "copper");
                }
                VanillaRecipes.addBeeswaxRecipe(consumer, provider, prefix + "cut_copper");
                VanillaRecipes.addBeeswaxRecipe(consumer, provider, prefix + "cut_copper_stairs");
                VanillaRecipes.addBeeswaxRecipe(consumer, provider, prefix + "cut_copper_slab");
            }
            provider.addItemRecipe(consumer, "misc", (ItemLike)Items.f_151065_, ImmutableMap.of((Object)Character.valueOf('S'), (Object)Items.f_42401_, (Object)Character.valueOf('W'), (Object)GTMaterialTypes.DUST.getMaterialTag(GTCoreMaterials.Beeswax)), new String[]{"S", "W"});
        }
        if (!GTCoreConfig.VANILLA_OVERRIDES.get()) {
            return;
        }
        provider.addStackRecipe(consumer, "minecraft", "", "misc", new ItemStack((ItemLike)Items.f_42025_, 8), ImmutableMap.of((Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROD.getMaterialTag(GTLibMaterials.Iron), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{" H ", "RRR", "RRR"});
        provider.addItemRecipe(consumer, "minecraft", "", "misc", (ItemLike)Items.f_42446_, ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Iron), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"IHI", " I "});
        provider.addItemRecipe(consumer, "minecraft", "", "misc", (ItemLike)Items.f_42155_, ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Iron), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('C'), (Object)Tags.Items.CHESTS_WOODEN), new String[]{"IWI", "ICI", " I "});
        provider.addStackRecipe(consumer, "minecraft", "", "cauldrons", new ItemStack((ItemLike)Items.f_42544_), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Iron), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"P P", "PHP", "PPP"});
        provider.addStackRecipe(consumer, "minecraft", "", "misc", new ItemStack((ItemLike)Items.f_42341_, 3), ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Iron), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"II ", "IIH", "II "});
        provider.addStackRecipe(consumer, "minecraft", "", "misc", new ItemStack((ItemLike)Items.f_42128_), ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Iron), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"II ", "IIH"});
        provider.addStackRecipe(consumer, "minecraft", "", "misc", new ItemStack((ItemLike)Items.f_42150_), ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Gold), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"IIH"});
        provider.addStackRecipe(consumer, "minecraft", "", "misc", new ItemStack((ItemLike)Items.f_42151_), ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Iron), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"IIH"});
        provider.addItemRecipe(consumer, "misc", (ItemLike)Items.f_42574_, ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Iron), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"HI", "IF"});
        provider.addItemRecipe(consumer, "vanilla_armor", (ItemLike)Items.f_42468_, ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Iron), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"III", "IHI"});
        provider.addItemRecipe(consumer, "vanilla_armor", (ItemLike)Items.f_42469_, ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Iron), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"IHI", "III", "III"});
        provider.addItemRecipe(consumer, "vanilla_armor", (ItemLike)Items.f_42470_, ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Iron), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"III", "IHI", "I I"});
        provider.addItemRecipe(consumer, "vanilla_armor", (ItemLike)Items.f_42471_, ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Iron), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"I I", "IHI"});
        provider.addItemRecipe(consumer, "vanilla_armor", (ItemLike)Items.f_42476_, ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Gold), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"III", "IHI"});
        provider.addItemRecipe(consumer, "vanilla_armor", (ItemLike)Items.f_42477_, ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Gold), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"IHI", "III", "III"});
        provider.addItemRecipe(consumer, "vanilla_armor", (ItemLike)Items.f_42478_, ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Gold), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"III", "IHI", "I I"});
        provider.addItemRecipe(consumer, "vanilla_armor", (ItemLike)Items.f_42479_, ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(GTLibMaterials.Gold), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"I I", "IHI"});
    }

    static void addWoodRecipe(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider, String domain, TagKey<Item> log, Item plank) {
        int amount1 = GTCoreConfig.HARDER_WOOD.get() ? 2 : 4;
        int amount2 = GTCoreConfig.HARDER_WOOD.get() ? 4 : 6;
        provider.shapeless(consumer, domain, "", "planks", new ItemStack((ItemLike)plank, amount1), new Object[]{log});
        provider.addStackRecipe(consumer, domain, RegistryUtils.getIdFromItem((Item)plank).m_135815_() + "_" + amount2, "planks", new ItemStack((ItemLike)plank, amount2), ImmutableMap.of((Object)Character.valueOf('S'), (Object)GTTools.SAW.getTag(), (Object)Character.valueOf('P'), log), new String[]{"S", "P"});
    }

    static void addBeeswaxRecipe(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider, String id) {
        provider.shapeless(consumer, "minecraft", "waxed_" + id + "_from_honeycomb", "waxed_blocks", new ItemStack((ItemLike)RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation("waxed_" + id))), new Object[]{RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(id)), GTMaterialTypes.DUST.getMaterialTag(GTCoreMaterials.Beeswax)});
    }

    private static void loadWood(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider) {
        String[] wood;
        String[] stones;
        if (GTCoreConfig.HARDER_WOOD.get()) {
            provider.addStackRecipe(consumer, "minecraft", "", "wood_stuff", new ItemStack((ItemLike)Items.f_42398_, 2), ImmutableMap.of((Object)Character.valueOf('P'), (Object)ItemTags.f_13168_), new String[]{"P", "P"});
            provider.addStackRecipe(consumer, "gtcore", "sticks_4", "wood_stuff", new ItemStack((ItemLike)Items.f_42398_, 4), ImmutableMap.of((Object)Character.valueOf('P'), (Object)ItemTags.f_13168_, (Object)Character.valueOf('S'), (Object)GTTools.SAW.getTag()), new String[]{"S", "P", "P"});
        }
        VanillaRecipes.addWoodRecipe(consumer, provider, "minecraft", (TagKey<Item>)ItemTags.f_13184_, Items.f_42647_);
        VanillaRecipes.addWoodRecipe(consumer, provider, "minecraft", (TagKey<Item>)ItemTags.f_13185_, Items.f_42753_);
        VanillaRecipes.addWoodRecipe(consumer, provider, "minecraft", (TagKey<Item>)ItemTags.f_13188_, Items.f_42700_);
        VanillaRecipes.addWoodRecipe(consumer, provider, "minecraft", (TagKey<Item>)ItemTags.f_13187_, Items.f_42794_);
        VanillaRecipes.addWoodRecipe(consumer, provider, "minecraft", (TagKey<Item>)ItemTags.f_13186_, Items.f_42795_);
        VanillaRecipes.addWoodRecipe(consumer, provider, "minecraft", (TagKey<Item>)ItemTags.f_13183_, Items.f_42796_);
        VanillaRecipes.addWoodRecipe(consumer, provider, "minecraft", (TagKey<Item>)ItemTags.f_13189_, Items.f_42797_);
        VanillaRecipes.addWoodRecipe(consumer, provider, "minecraft", (TagKey<Item>)ItemTags.f_13190_, Items.f_42798_);
        String[] stringArray = stones = new String[]{"stone", "smooth_stone", "sandstone", "cut_sandstone", "cobblestone", "red_sandstone", "cut_red_sandstone", "prismarine", "dark_prismarine", "polished_granite", "smooth_red_sandstone", "polished_diorite", "mossy_cobblestone", "smooth_sandstone", "smooth_quartz", "granite", "andesite", "polished_andesite", "diorite", "blackstone", "polished_blackstone", "purpur", "quartz", "brick", "stone_brick", "nether_brick", "prismarine_brick", "mossy_stone_brick", "end_stone_brick", "red_nether_brick", "polished_blackstone_brick"};
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray2;
            String stone;
            Item full = RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(stone + ((stone = stringArray[i]).equals("purpur") || stone.equals("quartz") ? "_block" : (stone.contains("brick") ? "s" : ""))));
            Item slab = RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(stone + "_slab"));
            if (stone.equals("purpur") || stone.equals("quartz") || stone.equals("sandstone") || stone.equals("red_sandstone") || stone.equals("stone_brick") || stone.equals("nether_brick") || stone.equals("polished_blackstone")) {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = "SS";
            } else {
                String[] stringArray4 = new String[2];
                stringArray4[0] = "S";
                stringArray2 = stringArray4;
                stringArray4[1] = "S";
            }
            String[] pattern = stringArray2;
            provider.addItemRecipe(consumer, "gtcore", stone + "_slab_to_" + stone, "slabs", (ItemLike)full, ImmutableMap.of((Object)Character.valueOf('S'), (Object)slab), pattern);
        }
        for (String s : wood = new String[]{"oak", "birch", "spruce", "jungle", "acacia", "dark_oak", "crimson", "warped"}) {
            ResourceLocation name = new ResourceLocation(s + "_planks");
            ResourceLocation slab = new ResourceLocation(s + "_slab");
            provider.addItemRecipe(consumer, "gtcore", slab.m_135815_() + "_to_" + name.m_135815_(), "slabs", (ItemLike)RegistryUtils.getItemFromID((ResourceLocation)name), ImmutableMap.of((Object)Character.valueOf('S'), (Object)RegistryUtils.getItemFromID((ResourceLocation)slab)), new String[]{"S", "S"});
        }
    }
}

