/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.data;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import org.gtreimagined.gtcore.behaviour.BehaviourElectricWrenchSwitching;
import org.gtreimagined.gtcore.behaviour.BehaviourKnifeTooltip;
import org.gtreimagined.gtcore.behaviour.BehaviourMultitoolSwitching;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreMaterials;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.behaviour.IBehaviour;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.item.ItemBattery;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.tool.GTItemTier;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.gtlib.tool.MaterialTool;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourAOEBreak;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourExtendedHighlight;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourLogStripping;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourShearing;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourTorchPlacing;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourTreeFelling;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.tesseract.TesseractCapUtils;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;
import org.gtreimagined.tesseract.api.eu.IEnergyHandlerItem;
import org.jetbrains.annotations.Nullable;

public class GTCoreTools {
    private static final GTToolType.IToolSupplier POWERED_TOOL_SUPPLIER = new GTToolType.IToolSupplier(){

        public IGTTool create(String domain, GTToolType toolType, GTItemTier tier, Item.Properties properties) {
            return null;
        }

        public IGTTool create(String domain, GTToolType toolType, GTItemTier tier, Item.Properties properties, int energyTier) {
            return new PoweredTool(domain, toolType, tier, properties, energyTier);
        }
    };
    public static final GTToolType DRILL = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gtcore", "drill", 1, 2, 10, 3.0f, -3.0f, false))).setToolSupplier(POWERED_TOOL_SUPPLIER).setType(GTTools.PICKAXE).setUseAction(UseAnim.BLOCK).setPowered(100000L, new int[]{1, 2, 3}).setMaterialTypeItem(GTMaterialTypes.DRILL_BIT).setUseSound(Ref.DRILL).addTags(new String[]{"pickaxe", "shovel"}).addEffectiveMaterials(new Material[]{Material.f_76316_, Material.f_76283_, Material.f_76314_, Material.f_76313_, Material.f_76315_, Material.f_76317_}).setRepairable(false);
    public static final GTToolType BUZZSAW = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gtcore", "buzzsaw", 1, 1, 1, 0.5f, -2.7f, false))).setToolSupplier(POWERED_TOOL_SUPPLIER).setTag(GTTools.SAW).setPowered(100000L, new int[]{1, 2, 3}).setOverlayLayers(2).addTags(new String[]{"saw"}).setMaterialTypeItem(GTMaterialTypes.BUZZSAW_BLADE);
    public static final GTToolType ELECTRIC_SCREWDRIVER = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gtcore", "electric_screwdriver", GTTools.SCREWDRIVER))).setTag(GTTools.SCREWDRIVER).setPowered(100000L, new int[]{1, 2, 3}).setToolSupplier(POWERED_TOOL_SUPPLIER).setUseSound(Ref.WRENCH).setOverlayLayers(2).setTag(GTTools.SCREWDRIVER);
    public static final GTToolType ELECTRIC_WRENCH = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gtcore", "electric_wrench", GTTools.WRENCH).setTag(GTTools.WRENCH).setPowered(100000L, new int[]{1, 2, 3}))).setToolSupplier(POWERED_TOOL_SUPPLIER).setUseSound(Ref.WRENCH).addEffectiveBlocks(new Block[]{Blocks.f_50332_}).setType(GTTools.WRENCH).setMaterialTypeItem(GTMaterialTypes.WRENCH_BIT).addBlacklistedEnchantments(new Enchantment[]{Enchantments.f_44984_});
    public static final GTToolType ELECTRIC_WRENCH_ALT = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gtcore", "electric_wrench_alt", GTTools.WRENCH).setTag(GTTools.WRENCH_ALT).setPowered(100000L, new int[]{1, 2, 3}))).setToolSupplier(POWERED_TOOL_SUPPLIER).setUseSound(Ref.WRENCH).addEffectiveBlocks(new Block[]{Blocks.f_50332_}).setType(GTTools.WRENCH).setMaterialTypeItem(GTMaterialTypes.WRENCH_BIT).addBlacklistedEnchantments(new Enchantment[]{Enchantments.f_44984_}).setCustomName("Electric Wrench (Alt)");
    public static final GTToolType CHAINSAW = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gtcore", "chainsaw", 1, 1, 5, 6.0f, -2.0f, false))).setToolSupplier(POWERED_TOOL_SUPPLIER).setUseAction(UseAnim.BLOCK).setPowered(100000L, new int[]{1, 2, 3}).setMaterialTypeItem(GTMaterialTypes.CHAINSAW_BIT).addEffectiveMaterials(new Material[]{Material.f_76320_, Material.f_76300_, Material.f_76302_, Material.f_76271_, Material.f_76274_}).addEffectiveBlocks(new Block[]{Blocks.f_50033_}).setType(GTTools.AXE).addTags(new String[]{"saw"});
    public static final GTToolType JACKHAMMER = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gtcore", "jackhammer", 1, 2, 10, 1.0f, -3.2f, false))).setToolSupplier(POWERED_TOOL_SUPPLIER).setPowered(100000L, new int[]{3}).setToolSpeedMultiplier(2.0f).setUseSound(Ref.DRILL).addEffectiveBlockTags(new TagKey[]{TagUtils.getForgelikeBlockTag((String)"stone"), TagUtils.getForgelikeBlockTag((String)"cobblestone"), BlockTags.f_13077_}).addEffectiveBlocks(new Block[]{Blocks.f_50137_, Blocks.f_50134_, Blocks.f_50080_, Blocks.f_50723_, Blocks.f_152537_, Blocks.f_50259_});
    public static final GTToolType POCKET_MULTITOOL = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gt", "pocket_multitool", 1, 2, 2, 1.0f, -1.5f, false))).setDurabilityMultiplier(4.0f).setToolSupplier(PocketMultitoolTool::new).setMaterialTypeItem(GTMaterialTypes.RING);
    public static final GTToolType POCKET_MULTITOOL_KNIFE = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gt", "pocket_multitool_knife", GTTools.KNIFE))).setDurabilityMultiplier(4.0f).setToolSupplier(PocketMultitoolTool::new).setCustomName("Pocket Multitool (Knife)").setTag(new ResourceLocation("gtlib", "knives")).setType(GTTools.KNIFE);
    public static final GTToolType POCKET_MULTITOOL_SAW = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gt", "pocket_multitool_saw", GTTools.SAW))).setDurabilityMultiplier(4.0f).setToolSupplier(PocketMultitoolTool::new).setCustomName("Pocket Multitool (Saw)").setType(GTTools.SAW).setTag(GTTools.SAW);
    public static final GTToolType POCKET_MULTITOOL_FILE = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gt", "pocket_multitool_file", GTTools.FILE))).setDurabilityMultiplier(4.0f).setToolSupplier(PocketMultitoolTool::new).setCustomName("Pocket Multitool (File)").setType(GTTools.FILE).setTag(GTTools.FILE);
    public static final GTToolType POCKET_MULTITOOL_SCREWDRIVER = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gt", "pocket_multitool_screwdriver", GTTools.SCREWDRIVER))).setDurabilityMultiplier(4.0f).setToolSupplier(PocketMultitoolTool::new).setCustomName("Pocket Multitool (Screwdriver)").setTag(GTTools.SCREWDRIVER).setType(GTTools.SCREWDRIVER).setUseSound(Ref.WRENCH);
    public static final GTToolType POCKET_MULTITOOL_WIRE_CUTTER = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gt", "pocket_multitool_wire_cutter", GTTools.WIRE_CUTTER))).setDurabilityMultiplier(4.0f).setToolSupplier(PocketMultitoolTool::new).setCustomName("Pocket Multitool (Wire Cutter)").setTag(GTTools.WIRE_CUTTER).setType(GTTools.WIRE_CUTTER).setUseSound(SoundEvents.f_12344_).addEffectiveMaterials(new Material[]{Material.f_76272_, Material.f_76318_, Material.f_76311_, Material.f_76299_});
    public static final GTToolType POCKET_MULTITOOL_SCISSORS = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gt", "pocket_multitool_scissors", GTTools.SCISSORS))).setDurabilityMultiplier(4.0f).setToolSupplier(PocketMultitoolTool::new).setCustomName("Pocket Multitool (Scissors)").setTag(GTTools.SCISSORS).setType(GTTools.SCISSORS);

    public static void init(Dist side) {
        CHAINSAW.addBehaviour(new IBehaviour[]{BehaviourTreeFelling.INSTANCE, BehaviourLogStripping.INSTANCE});
        DRILL.addBehaviour(new IBehaviour[]{new BehaviourAOEBreak(1, 1, 1, 8, "3x3"), BehaviourTorchPlacing.INSTANCE});
        JACKHAMMER.addBehaviour(new IBehaviour[]{new BehaviourAOEBreak(1, 1, 1, 8, "3x3"), BehaviourTorchPlacing.INSTANCE});
        ELECTRIC_WRENCH.addBehaviour(new IBehaviour[]{BehaviourElectricWrenchSwitching.INSTANCE});
        ELECTRIC_WRENCH_ALT.addBehaviour(new IBehaviour[]{BehaviourElectricWrenchSwitching.INSTANCE});
        POCKET_MULTITOOL.addBehaviour(new IBehaviour[]{BehaviourMultitoolSwitching.INSTANCE});
        POCKET_MULTITOOL_KNIFE.addBehaviour(new IBehaviour[]{BehaviourMultitoolSwitching.INSTANCE});
        POCKET_MULTITOOL_SAW.addBehaviour(new IBehaviour[]{BehaviourMultitoolSwitching.INSTANCE});
        POCKET_MULTITOOL_FILE.addBehaviour(new IBehaviour[]{BehaviourMultitoolSwitching.INSTANCE});
        POCKET_MULTITOOL_SCREWDRIVER.addBehaviour(new IBehaviour[]{BehaviourMultitoolSwitching.INSTANCE});
        POCKET_MULTITOOL_WIRE_CUTTER.addBehaviour(new IBehaviour[]{BehaviourMultitoolSwitching.INSTANCE});
        POCKET_MULTITOOL_SCISSORS.addBehaviour(new IBehaviour[]{BehaviourMultitoolSwitching.INSTANCE});
        POCKET_MULTITOOL_SCISSORS.addBehaviour(new IBehaviour[]{BehaviourShearing.INSTANCE});
        DRILL.setBrokenItems(ImmutableMap.of((Object)"drill_lv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.PowerUnitLV), (Object)"drill_mv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.PowerUnitMV), (Object)"drill_hv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.PowerUnitHV)));
        CHAINSAW.setBrokenItems(ImmutableMap.of((Object)"chainsaw_lv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.PowerUnitLV), (Object)"chainsaw_mv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.PowerUnitMV), (Object)"chainsaw_hv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.PowerUnitHV)));
        ELECTRIC_WRENCH.setBrokenItems(ImmutableMap.of((Object)"electric_wrench_lv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.PowerUnitLV), (Object)"electric_wrench_mv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.PowerUnitMV), (Object)"electric_wrench_hv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.PowerUnitHV)));
        ELECTRIC_WRENCH_ALT.setBrokenItems(ImmutableMap.of((Object)"electric_wrench_alt_lv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.PowerUnitLV), (Object)"electric_wrench_alt_mv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.PowerUnitMV), (Object)"electric_wrench_alt_hv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.PowerUnitHV)));
        BUZZSAW.setBrokenItems(ImmutableMap.of((Object)"buzzsaw_lv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.PowerUnitLV), (Object)"buzzsaw_mv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.PowerUnitMV), (Object)"buzzsaw_hv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.PowerUnitHV)));
        ELECTRIC_SCREWDRIVER.setBrokenItems(ImmutableMap.of((Object)"electric_screwdriver_lv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.SmallPowerUnit)));
        JACKHAMMER.setBrokenItems(ImmutableMap.of((Object)"jackhammer_hv", i -> GTCoreTools.getBrokenItem(i, (ItemLike)GTCoreItems.JackhammerPowerUnit)));
        GTTools.KNIFE.addBehaviour(new IBehaviour[]{BehaviourKnifeTooltip.INSTANCE});
        if (side.isClient()) {
            GTCoreTools.clientInit();
        }
    }

    private static void clientInit() {
        ELECTRIC_SCREWDRIVER.addBehaviour(new IBehaviour[]{new BehaviourExtendedHighlight(b -> b instanceof BlockMachine || b instanceof BlockPipe, BehaviourExtendedHighlight.COVER_FUNCTION)});
        ELECTRIC_WRENCH.addBehaviour(new IBehaviour[]{new BehaviourExtendedHighlight(b -> b instanceof BlockMachine || b instanceof BlockPipe && b.m_204297_().m_203656_(GTTools.WRENCH.getToolType()) || b.m_49966_().m_61138_((Property)BlockStateProperties.f_61373_) || b.m_49966_().m_61138_((Property)BlockStateProperties.f_61374_), BehaviourExtendedHighlight.PIPE_FUNCTION)});
        POCKET_MULTITOOL_SCREWDRIVER.addBehaviour(new IBehaviour[]{new BehaviourExtendedHighlight(b -> b instanceof BlockMachine || b instanceof BlockPipe, BehaviourExtendedHighlight.COVER_FUNCTION)});
        POCKET_MULTITOOL_WIRE_CUTTER.addBehaviour(new IBehaviour[]{new BehaviourExtendedHighlight(b -> b instanceof BlockPipe && b.m_204297_().m_203656_(GTTools.WIRE_CUTTER.getToolType()), BehaviourExtendedHighlight.PIPE_FUNCTION)});
    }

    private static ItemStack getBrokenItem(ItemStack tool, ItemLike broken) {
        ItemStack powerUnit = new ItemStack(broken);
        Tuple<Long, Long> tuple = GTCoreTools.getEnergy(tool);
        CompoundTag dataTag = powerUnit.m_41698_("ied");
        IEnergyHandlerItem handler = TesseractCapUtils.INSTANCE.getEnergyHandlerItem(powerUnit).orElse(null);
        if (handler != null) {
            handler.setEnergy(((Long)tuple.m_14418_()).longValue());
            handler.setCapacity(((Long)tuple.m_14419_()).longValue());
            powerUnit = handler.getContainer().getItemStack();
        } else {
            dataTag.m_128356_("e", ((Long)tuple.m_14418_()).longValue());
            dataTag.m_128356_("me", ((Long)tuple.m_14419_()).longValue());
        }
        if (broken.m_5456_() == GTCoreItems.SmallPowerUnit) {
            GTCoreItems.PowerUnitHV.setMaterial(((IGTTool)tool.m_41720_()).getSecondaryMaterial(tool), powerUnit);
        }
        return powerUnit;
    }

    public static Tuple<Long, Long> getEnergy(ItemStack stack) {
        IGTTool tool;
        Item item = stack.m_41720_();
        if (item instanceof ItemBattery) {
            ItemBattery battery = (ItemBattery)item;
            long energy = TesseractCapUtils.INSTANCE.getEnergyHandlerItem(stack).map(IEnergyHandler::getEnergy).orElse(0L);
            long maxEnergy = TesseractCapUtils.INSTANCE.getEnergyHandlerItem(stack).map(IEnergyHandler::getCapacity).orElse(battery.getCapacity());
            return new Tuple((Object)energy, (Object)maxEnergy);
        }
        Item energy = stack.m_41720_();
        if (energy instanceof IGTTool && (tool = (IGTTool)energy).getGTToolType().isPowered()) {
            long currentEnergy = tool.getCurrentEnergy(stack);
            long maxEnergy = tool.getMaxEnergy(stack);
            return new Tuple((Object)currentEnergy, (Object)maxEnergy);
        }
        return null;
    }

    public static class PocketMultitoolTool
    extends MaterialTool {
        public PocketMultitoolTool(String domain, GTToolType type, GTItemTier tier, Item.Properties properties) {
            super(domain, type, tier, properties);
        }

        public void onGenericAddInformation(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
            tooltip.add((Component)Utils.translatable((String)"tooltip.gtcore.pocket_multitool", (Object[])new Object[0]));
            super.onGenericAddInformation(stack, tooltip, flag);
            tooltip.add((Component)Utils.translatable((String)"tooltip.gtcore.pocket_multitool.switch_mode", (Object[])new Object[0]));
        }

        public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
            if (i == 1) {
                return -1;
            }
            return super.getItemColor(stack, block, i);
        }
    }

    public static class PoweredTool
    extends MaterialTool {
        public PoweredTool(String domain, GTToolType type, GTItemTier tier, Item.Properties properties, int energyTier) {
            super(domain, type, tier, properties, energyTier);
        }

        public float getDefaultMiningSpeed(ItemStack stack) {
            return super.getDefaultMiningSpeed(stack) * (float)(3 * this.energyTier);
        }

        public int getDefaultEnergyUse() {
            int defaultUse = (int)(25.0 * Math.pow(2.0, this.energyTier - 1));
            if (this.type == JACKHAMMER) {
                defaultUse /= 2;
            }
            return defaultUse;
        }

        public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
            if (i == 1) {
                if (this.type == JACKHAMMER) {
                    return -1;
                }
                if (this.energyTier == 1) {
                    return GTCoreMaterials.Aluminium.getRGB();
                }
                if (this.energyTier == 2) {
                    return GTCoreMaterials.StainlessSteel.getRGB();
                }
                if (this.energyTier == 3) {
                    return GTCoreMaterials.Titanium.getRGB();
                }
            }
            return super.getItemColor(stack, block, i);
        }
    }
}

