/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.blockentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.gtreimagined.gtcore.blockentity.BlockEntityMaterialBasicMultiMachine;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtcore.machine.MultiblockTankMachine;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.CoverHandler;
import org.gtreimagined.gtlib.capability.fluid.FluidHandlerSidedWrapper;
import org.gtreimagined.gtlib.capability.fluid.FluidTanks;
import org.gtreimagined.gtlib.capability.fluid.IFluidNode;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTLibTags;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityLargeTank
extends BlockEntityMaterialBasicMultiMachine<BlockEntityLargeTank> {
    MultiblockTankMachine tankMachine;
    LazyOptional<IFluidHandler> fakeFacingWrapper;

    public BlockEntityLargeTank(MultiblockTankMachine type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidHandler.set(() -> new LargeTankFluidHandler(this, type.getCapacity(), 1, 0));
        this.tankMachine = type;
        this.fakeFacingWrapper = LazyOptional.of(() -> new FakeSidedFluidHandler((IFluidNode)this.fluidHandler.get(), (CoverHandler)this.coverHandler.get(), this.getFacing(state)));
    }

    public boolean allowsFakeTiles() {
        return true;
    }

    public Block getCasing() {
        Block block = this.tankMachine.getCasing().get();
        if (block != null) {
            return block;
        }
        return Blocks.f_50016_;
    }

    public List<String> getInfo(boolean simple) {
        List list = super.getInfo(simple);
        this.fluidHandler.ifPresent(f -> {
            FluidStack stack = f.getInputTanks().getFluidInTank(0);
            list.add("Fluid: " + (String)(stack.isEmpty() ? "Empty" : stack.getAmount() + "mb of " + FluidUtils.getFluidDisplayName((FluidStack)stack).getString()));
        });
        return list;
    }

    public <U> LazyOptional<U> getCapabilityFromFake(@NotNull Capability<U> cap, @Nullable Direction side, ICover cover) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side == this.getFacing()) {
            return this.fakeFacingWrapper.cast();
        }
        return super.getCapabilityFromFake(cap, side, cover);
    }

    public static class FakeSidedFluidHandler
    extends FluidHandlerSidedWrapper {
        private CoverHandler<?> coverHandler;

        public FakeSidedFluidHandler(IFluidNode fluidHandler, CoverHandler<?> coverHandler, Direction side) {
            super(fluidHandler, coverHandler, side);
            this.coverHandler = coverHandler;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.coverHandler != null) {
                if (this.coverHandler.get(this.side).blocksInput(IFluidHandler.class, this.side)) {
                    return 0;
                }
                int oldAmount = resource.getAmount();
                if (this.coverHandler.onTransfer((Object)resource, this.side, true, action.simulate())) {
                    return oldAmount - resource.getAmount();
                }
            }
            return this.fluidHandler.canInput(resource, this.side) ? this.fluidHandler.fill(resource, action) : 0;
        }
    }

    public static class LargeTankFluidHandler
    extends MachineFluidHandler<BlockEntityLargeTank> {
        public LargeTankFluidHandler(BlockEntityLargeTank tile, int capacity, int inputCount, int outputCount) {
            super((BlockEntityMachine)tile, capacity, inputCount, outputCount);
        }

        @Nullable
        public FluidTanks getOutputTanks() {
            return super.getInputTanks();
        }

        protected FluidTank getTank(int tank) {
            return this.getInputTanks().getTank(tank);
        }

        public FluidTanks getTanks(int tank) {
            return this.getInputTanks();
        }

        public void onUpdate() {
            super.onUpdate();
            Direction dir = ((BlockEntityLargeTank)this.tile).getFacing();
            if (this.getTank(0).getFluid().getAmount() > 0 && (dir != Direction.UP || FluidUtils.getFluidDensity((Fluid)this.getTank(0).getFluid().getFluid()) < 0)) {
                FluidUtils.getFluidHandler((Level)((BlockEntityLargeTank)this.tile).m_58904_(), (BlockPos)((BlockEntityLargeTank)this.tile).m_58899_().m_121945_(dir), (BlockEntity)((BlockEntityLargeTank)this.tile).getCachedBlockEntity(dir), (Direction)dir.m_122424_()).ifPresent(other -> Utils.transferFluids((IFluidHandler)this.getOutputTanks(), (IFluidHandler)other, (int)1000));
            }
        }

        public boolean canInput(Direction direction) {
            return direction != ((BlockEntityLargeTank)this.tile).getFacing();
        }

        public int fill(FluidStack fluid, IFluidHandler.FluidAction action) {
            if (fluid.getFluid().m_205067_(GTCoreTags.STEAM)) {
                if (fluid.getAmount() >= 160) {
                    int toFill = fluid.getAmount() / 160;
                    return this.fill(GTLibMaterials.Water.getLiquid(toFill), action);
                }
                return 0;
            }
            if (!((BlockEntityLargeTank)this.tile).tankMachine.isGasProof() && FluidUtils.isFluidGaseous((Fluid)fluid.getFluid())) {
                int inserted = super.fill(fluid, IFluidHandler.FluidAction.SIMULATE);
                if (inserted > 0) {
                    if (action.execute()) {
                        ((BlockEntityLargeTank)this.tile).m_58904_().m_5594_(null, ((BlockEntityLargeTank)this.tile).m_58899_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    return inserted;
                }
                return 0;
            }
            if (FluidUtils.getFluidTemperature((Fluid)fluid.getFluid()) > ((BlockEntityLargeTank)this.tile).tankMachine.getMaxHeat()) {
                int inserted = super.fill(fluid, action);
                if (inserted > 0 && action.execute()) {
                    this.meltdown();
                }
                return inserted;
            }
            if (!((BlockEntityLargeTank)this.tile).tankMachine.isAcidProof() && fluid.getFluid().m_205067_(GTLibTags.ACID)) {
                if (action.execute()) {
                    ((BlockEntityLargeTank)this.tile).m_58904_().m_7731_(((BlockEntityLargeTank)this.tile).m_58899_(), Blocks.f_50016_.m_49966_(), 3);
                }
                return Math.min(16, fluid.getAmount());
            }
            return super.fill(fluid, action);
        }

        public boolean meltdown() {
            BlockPos offset = ((BlockEntityLargeTank)this.tile).m_58899_().m_121945_(((BlockEntityLargeTank)this.tile).getFacing().m_122424_());
            int tX = offset.m_123341_();
            int tY = offset.m_123342_();
            int tZ = offset.m_123343_();
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        LargeTankFluidHandler.burn(((BlockEntityLargeTank)this.tile).f_58857_, tX + i, tY + j, tZ + k);
                        if (((BlockEntityLargeTank)this.tile).m_58904_().f_46441_.m_188503_(4) != 0) continue;
                        ((BlockEntityLargeTank)this.tile).m_58904_().m_7731_(new BlockPos(tX + i, tY + j, tZ + k), Blocks.f_50083_.m_49966_(), 3);
                    }
                }
            }
            FluidStack fluidHolder = this.getInputTanks().getTank(0).getFluid();
            if (fluidHolder.getAmount() >= 1000 && fluidHolder.getFluid() == Fluids.f_76195_) {
                ((BlockEntityLargeTank)this.tile).m_58904_().m_7731_(offset, Blocks.f_49991_.m_49966_(), 3);
            }
            ((BlockEntityLargeTank)this.tile).m_58904_().m_7731_(((BlockEntityLargeTank)this.tile).m_58899_(), Blocks.f_50083_.m_49966_(), 3);
            return true;
        }

        public static void burn(Level aWorld, int aX, int aY, int aZ) {
            BlockPos pos = new BlockPos(aX, aY, aZ);
            for (Direction tSide : Direction.values()) {
                LargeTankFluidHandler.fire(aWorld, pos.m_121945_(tSide), false);
            }
        }

        public static boolean fire(Level aWorld, BlockPos pos, boolean aCheckFlammability) {
            BlockState tBlock = aWorld.m_8055_(pos);
            if (tBlock.m_60767_() == Material.f_76307_ || tBlock.m_60767_() == Material.f_76309_) {
                return false;
            }
            if (tBlock.m_60767_() == Material.f_76299_ || tBlock.m_60812_((BlockGetter)aWorld, pos).m_83281_()) {
                if (tBlock.getFlammability((BlockGetter)aWorld, pos, Direction.NORTH) > 0) {
                    return aWorld.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
                }
                if (aCheckFlammability) {
                    for (Direction tSide : Direction.values()) {
                        BlockState tAdjacent = aWorld.m_8055_(pos.m_121945_(tSide));
                        if (tAdjacent.m_60734_() == Blocks.f_50087_ || tAdjacent.m_60734_() == Blocks.f_50325_) {
                            return aWorld.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
                        }
                        if (tAdjacent.getFlammability((BlockGetter)aWorld, pos.m_121945_(tSide), tSide.m_122424_()) <= 0) continue;
                        return aWorld.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
                    }
                } else {
                    return aWorld.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
                }
            }
            return false;
        }
    }
}

