/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.blockentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.gtreimagined.gtcore.blockentity.BlockEntityMaterial;
import org.gtreimagined.gtcore.machine.MaterialMachine;
import org.gtreimagined.gtlib.gui.container.ContainerMachine;

public class BlockEntityChest
extends BlockEntityMaterial<BlockEntityChest>
implements LidBlockEntity {
    protected float lidAngle;
    protected float prevLidAngle;
    protected int numPlayersUsing;
    private int ticksSinceSync;
    private final ChestLidController lidController;
    private final ContainerOpenersCounter manager = new ContainerOpenersCounter(){

        protected void m_142292_(Level world, BlockPos pos, BlockState state) {
            BlockEntityChest.playSound(world, pos, state, SoundEvents.f_11749_);
        }

        protected void m_142289_(Level world, BlockPos pos, BlockState state) {
            BlockEntityChest.playSound(world, pos, state, SoundEvents.f_11747_);
        }

        protected void m_142148_(Level world, BlockPos pos, BlockState state, int oldCount, int newCount) {
            world.m_7696_(pos, state.m_60734_(), 1, newCount);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean m_142718_(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (!(abstractContainerMenu instanceof ContainerMachine)) return false;
            ContainerMachine handler = (ContainerMachine)abstractContainerMenu;
            abstractContainerMenu = handler.handler.handler;
            if (!(abstractContainerMenu instanceof BlockEntityChest)) return false;
            BlockEntityChest chest = (BlockEntityChest)abstractContainerMenu;
            if (!chest.m_58899_().equals((Object)BlockEntityChest.this.m_58899_())) return false;
            return true;
        }
    };

    public BlockEntityChest(MaterialMachine type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.lidController = new ChestLidController();
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        super.clientTick(level, pos, state);
    }

    protected void tick(Level level, BlockPos pos, BlockState state) {
        super.tick(level, pos, state);
        this.lidController.m_155374_();
    }

    public boolean m_7531_(int event, int value) {
        if (event == 1) {
            this.lidController.m_155377_(value > 0);
            return true;
        }
        return super.m_7531_(event, value);
    }

    public boolean canPlayerOpenGui(Player playerEntity) {
        return super.canPlayerOpenGui(playerEntity) && !BlockEntityChest.isChestBlockedAt((LevelAccessor)playerEntity.f_19853_, this.m_58899_());
    }

    public static boolean isChestBlockedAt(LevelAccessor p_220108_0_, BlockPos p_220108_1_) {
        return BlockEntityChest.isBlockedChestByBlock((BlockGetter)p_220108_0_, p_220108_1_) || BlockEntityChest.isCatSittingOnChest(p_220108_0_, p_220108_1_);
    }

    private static boolean isBlockedChestByBlock(BlockGetter pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7494_();
        return pLevel.m_8055_(blockpos).m_60796_(pLevel, blockpos);
    }

    private static boolean isCatSittingOnChest(LevelAccessor pLevel, BlockPos pPos) {
        List list = pLevel.m_45976_(Cat.class, new AABB((double)pPos.m_123341_(), (double)(pPos.m_123342_() + 1), (double)pPos.m_123343_(), (double)(pPos.m_123341_() + 1), (double)(pPos.m_123342_() + 2), (double)(pPos.m_123343_() + 1)));
        if (!list.isEmpty()) {
            for (Cat catentity : list) {
                if (!catentity.m_21825_()) continue;
                return true;
            }
        }
        return false;
    }

    private static void playSound(Level world, BlockPos pos, BlockState state, SoundEvent soundIn) {
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + 0.5;
        double d2 = (double)pos.m_123343_() + 0.5;
        world.m_6263_((Player)null, d0, d1, d2, soundIn, SoundSource.BLOCKS, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public float m_6683_(float partialTicks) {
        return this.lidController.m_155375_(partialTicks);
    }

    public void addOpenContainer(ContainerMachine<BlockEntityChest> c, Player player) {
        super.addOpenContainer(c, player);
        if (!this.f_58859_ && !player.m_5833_()) {
            this.manager.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void onContainerClose(ContainerMachine<BlockEntityChest> c, Player player) {
        super.onContainerClose(c, player);
        if (!this.f_58859_ && !player.m_5833_()) {
            this.manager.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }
}

