/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class RubberFoliagePlacer
extends FoliagePlacer {
    public static final Codec<RubberFoliagePlacer> CODEC = RecordCodecBuilder.create(p_242834_0_ -> RubberFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)p_242834_0_).apply((Applicative)p_242834_0_, RubberFoliagePlacer::new));
    public static final FoliagePlacerType<RubberFoliagePlacer> RUBBER = new FoliagePlacerType(CODEC);

    protected RubberFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    public RubberFoliagePlacer() {
        super((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0));
    }

    protected FoliagePlacerType<?> m_5897_() {
        return RUBBER;
    }

    protected void m_142539_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, Random pRandom, TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        this.generate(pLevel, pBlockSetter, pRandom, pConfig, pMaxFreeTreeHeight, pAttachment, pFoliageHeight, pFoliageRadius, pOffset);
    }

    protected void generate(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> pBlockSetter, Random random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment treeNode, int foliageHeight, int radius, int offset) {
        BlockPos center = treeNode.m_161451_();
        BlockPos.MutableBlockPos pos = center.m_122032_();
        int offset1 = offset - 1;
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        double treeRadius = 2.5;
        for (int i = offset1; i >= offset1 - foliageHeight; --i) {
            if (i == offset1) {
                this.m_161437_(world, pBlockSetter, random, config, center, 1, i, treeNode.m_68590_());
                continue;
            }
            pos.m_122178_(x, y + i, z);
            RubberFoliagePlacer.circle(pos.m_122032_(), treeRadius, position -> {
                if (TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)position)) {
                    pBlockSetter.accept((BlockPos)position, config.f_161213_.m_7112_(random, (BlockPos)position));
                }
            });
        }
        int spikeHeight = 2 + random.nextInt(3);
        for (int i = 0; i < spikeHeight; ++i) {
            BlockPos leaf = center.m_6630_(i);
            if (!TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)leaf)) continue;
            pBlockSetter.accept(leaf, config.f_161213_.m_7112_(random, leaf));
        }
    }

    private static void circle(BlockPos.MutableBlockPos origin, double radius, Consumer<BlockPos.MutableBlockPos> consumer) {
        int x = origin.m_123341_();
        int z = origin.m_123343_();
        double radiusSq = radius * radius;
        int radiusCeil = (int)Math.ceil(radius);
        for (int dz = -radiusCeil; dz <= radiusCeil; ++dz) {
            int dzSq = dz * dz;
            for (int dx = -radiusCeil; dx <= radiusCeil; ++dx) {
                int dxSq = dx * dx;
                if (!((double)(dzSq + dxSq) <= radiusSq)) continue;
                origin.m_122178_(x + dx, origin.m_123342_(), z + dz);
                consumer.accept(origin);
            }
        }
    }

    public int m_5969_(Random p_230374_1_, int p_230374_2_, TreeConfiguration p_230374_3_) {
        return Math.max(2, p_230374_2_ - (3 + p_230374_1_.nextInt(2)));
    }

    protected boolean m_7394_(Random p_230373_1_, int p_230373_2_, int p_230373_3_, int p_230373_4_, int p_230373_5_, boolean p_230373_6_) {
        return false;
    }
}

