/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.client.model;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtcore.blockentity.BlockEntityMassStorage;
import org.gtreimagined.gtcore.client.model.IconModel;
import org.gtreimagined.gtcore.client.model.IconModelLoader;
import org.gtreimagined.gtlib.client.ModelUtils;
import org.gtreimagined.gtlib.client.RenderHelper;
import org.gtreimagined.gtlib.client.SimpleModelState;
import org.gtreimagined.gtlib.client.baked.GTBakedModel;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.MachineState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconBakedModel
extends GTBakedModel<IconBakedModel> {
    BakedModel baseModel;

    public IconBakedModel(BakedModel baseModel, Function<Material, TextureAtlasSprite> function) {
        super(baseModel.m_6160_());
        this.baseModel = baseModel;
        if (IconModel.ICON_MODELS == null) {
            IconModel.ICON_MODELS = new ObjectArrayList();
            String[] icons = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "percent"};
            for (int i = 0; i < IconModelLoader.BLOCK_ELEMENTS.size(); ++i) {
                BlockElement element = IconModelLoader.BLOCK_ELEMENTS.get(i);
                Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
                for (String icon : icons) {
                    if (i > 1 && icon.equals("percent")) continue;
                    ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
                    for (Map.Entry entry : element.f_111310_.entrySet()) {
                        Direction dir = (Direction)entry.getKey();
                        BlockElementFace face = (BlockElementFace)entry.getValue();
                        TextureAtlasSprite sprite = function.apply(IconModel.TEXTURE_MAP.get(icon));
                        BakedQuad quad = IconModel.FACE_BAKERY.m_111600_(element.f_111308_, element.f_111309_, face, sprite, dir, (ModelState)new SimpleModelState(RenderHelper.faceRotation((Direction)Direction.SOUTH)), element.f_111311_, element.f_111312_, new ResourceLocation("gtcore", "item_storage"));
                        bakedQuads.add(quad);
                    }
                    map.put(icon, bakedQuads);
                }
                IconModel.ICON_MODELS.add((Map<String, List<BakedQuad>>)map);
            }
        }
    }

    public List<BakedQuad> getBlockQuads(BlockState state, @Nullable Direction direction, @NotNull Random rand, @NotNull BlockAndTintGetter level, @NotNull BlockPos pos) {
        BlockEntityMassStorage massStorage;
        ObjectArrayList quads = new ObjectArrayList();
        quads.addAll(ModelUtils.getQuadsFromBaked((BakedModel)this.baseModel, (BlockState)state, (Direction)direction, (Random)rand, (BlockAndTintGetter)level, (BlockPos)pos));
        if (direction != Direction.SOUTH) {
            return quads;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof BlockEntityMassStorage && (massStorage = (BlockEntityMassStorage)be).getMachineState() != MachineState.ACTIVE) {
            int offset = massStorage.getMaxLimit() <= 10000 ? 1 : 0;
            int amount = massStorage.getItemAmount();
            ItemStack display = massStorage.itemHandler.map(i -> i.getHandler(SlotType.DISPLAY).getStackInSlot(0)).orElse(ItemStack.f_41583_);
            if (amount > 0 || !display.m_41619_()) {
                String number = amount == massStorage.getMaxLimit() ? "100%" : Integer.toString(amount);
                for (int i2 = 0; i2 < number.length(); ++i2) {
                    char c = number.charAt(number.length() - (i2 + 1));
                    Map<String, List<BakedQuad>> map = IconModel.ICON_MODELS.get(i2 + offset);
                    quads.addAll((Collection)map.get(c == '%' ? "percent" : Character.toString(c)));
                }
            }
        }
        return quads;
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return true;
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

