/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.machine;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtcore.blockentity.BlockEntityBookShelf;
import org.gtreimagined.gtcore.blockentity.BlockEntityMassStorage;
import org.gtreimagined.gtcore.data.SlotTypes;
import org.gtreimagined.gtcore.machine.BarrelMachine;
import org.gtreimagined.gtcore.machine.BookShelfMachine;
import org.gtreimagined.gtcore.machine.MassStorageMachine;
import org.gtreimagined.gtcore.machine.MaterialMachine;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.datagen.builder.GTBlockModelBuilder;
import org.gtreimagined.gtlib.datagen.builder.GTItemModelBuilder;
import org.gtreimagined.gtlib.datagen.json.JLoaderModel;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class BlockMachineMaterial
extends BlockMachine {
    Material material = Material.NULL;

    public BlockMachineMaterial(Machine<?> type, Tier tier) {
        this(type, tier, BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)Data.WRENCH_MATERIAL).m_60913_(1.0f, 10.0f).m_60918_(SoundType.f_56743_).m_60999_());
    }

    public BlockMachineMaterial(Machine<?> type, Tier tier, BlockBehaviour.Properties properties) {
        super(type, tier, properties);
        if (type instanceof MaterialMachine) {
            this.material = ((MaterialMachine)type).getMaterial();
        }
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getBlockColor(BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, int i) {
        BlockEntity be;
        if (i == 2 && world != null && pos != null && (be = world.m_7702_(pos)) instanceof BlockEntityMassStorage) {
            BlockEntityMassStorage massStorage = (BlockEntityMassStorage)be;
            ITrackedHandler storage = massStorage.itemHandler.map(h -> h.getHandler(SlotTypes.UNLIMITED)).orElse(null);
            if (storage != null) {
                int count;
                int max = massStorage.getMaxLimit();
                if (max == (count = storage.getStackInSlot(0).m_41613_())) {
                    return 0xFF0000;
                }
                if (massStorage.getMassStorageMachine().getMaterial().has(new IMaterialTag[]{MaterialTags.WOOD})) {
                    return 0;
                }
            }
        }
        return i == 0 ? this.material.getRGB() : -1;
    }

    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        return i == 0 ? this.material.getRGB() : -1;
    }

    public void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        String suffix;
        int s;
        Texture[] overlays;
        int i;
        int s2;
        if (!(this.type instanceof MassStorageMachine || this.type instanceof BarrelMachine || this.type instanceof BookShelfMachine)) {
            super.onItemModelBuild(item, prov);
            return;
        }
        ResourceLocation existing = this.type instanceof BookShelfMachine ? new ResourceLocation("gtcore", "block/bookshelf") : new ResourceLocation("gtlib", "block/preset/layered");
        GTItemModelBuilder b = this.getId().contains("/") ? (GTItemModelBuilder)prov.getBuilder("item/" + this.getId()) : prov.getBuilder(item);
        ((GTItemModelBuilder)b.parent(existing)).texture("base", (ResourceLocation)this.type.getBaseTexture(this.tier, MachineState.IDLE)[0]);
        Texture[] base = this.type.getBaseTexture(this.tier, MachineState.IDLE);
        if (base.length >= 6) {
            for (s2 = 0; s2 < 6; ++s2) {
                b.texture("base" + Utils.coverRotateFacing((Direction)Ref.DIRS[s2], (Direction)Direction.NORTH).m_7912_(), (ResourceLocation)base[s2]);
            }
        }
        if (this.type instanceof BookShelfMachine) {
            return;
        }
        for (i = 0; i < this.type.getOverlayLayers(); ++i) {
            overlays = this.type.getOverlayTextures(MachineState.IDLE, this.tier, i);
            for (s = 0; s < 6; ++s) {
                suffix = i == 0 ? "" : String.valueOf(i);
                b.texture("overlay" + Utils.coverRotateFacing((Direction)Ref.DIRS[s], (Direction)Direction.NORTH).m_7912_() + suffix, (ResourceLocation)overlays[s]);
            }
        }
        if (!(this.type instanceof MassStorageMachine)) {
            return;
        }
        b.override().predicate(new ResourceLocation("gtcore", "taped"), 1.0f).model(new ResourceLocation(this.getDomain(), "item/" + this.id + "_taped")).end();
        b = (GTItemModelBuilder)((GTItemModelBuilder)((GTItemModelBuilder)prov.getBuilder(this.getId() + "_taped")).parent(prov.existing("gtlib", "block/preset/layered"))).texture("base", (ResourceLocation)this.type.getBaseTexture(this.tier, MachineState.ACTIVE)[0]);
        if (base.length >= 6) {
            for (s2 = 0; s2 < 6; ++s2) {
                b.texture("base" + Utils.coverRotateFacing((Direction)Ref.DIRS[s2], (Direction)Direction.NORTH).m_7912_(), (ResourceLocation)base[s2]);
            }
        }
        for (i = 0; i < this.type.getOverlayLayers(); ++i) {
            overlays = this.type.getOverlayTextures(MachineState.ACTIVE, this.tier, i);
            for (s = 0; s < 6; ++s) {
                suffix = i == 0 ? "" : String.valueOf(i);
                b.texture("overlay" + Utils.coverRotateFacing((Direction)Ref.DIRS[s], (Direction)Direction.NORTH).m_7912_() + suffix, (ResourceLocation)overlays[s]);
            }
        }
    }

    protected void buildModelsForState(GTBlockModelBuilder builder, MachineState state) {
        if (!(this.getType() instanceof MassStorageMachine) && !(this.getType() instanceof BookShelfMachine)) {
            super.buildModelsForState(builder, state);
            return;
        }
        ArrayList<JLoaderModel> arr = new ArrayList<JLoaderModel>();
        for (Direction dir : Ref.DIRS) {
            ImmutableMap.Builder builder1 = ImmutableMap.builder();
            builder1.put((Object)"base", (Object)this.getType().getBaseTexture(this.tier, dir, state).toString());
            for (int i = 0; i < this.type.getOverlayLayers(); ++i) {
                String suffix = i == 0 ? "" : String.valueOf(i);
                builder1.put((Object)("overlay" + suffix), (Object)this.type.getOverlayTextures(state, this.tier, i)[dir.m_122411_()].toString());
            }
            JLoaderModel obj = builder.addModelObject(JLoaderModel.modelKeepElements(), this.getType().getOverlayModel(state, dir).toString(), builder1.build());
            if (this.getType() instanceof MassStorageMachine) {
                if (dir == Direction.SOUTH) {
                    obj.loader("gtcore:icon");
                }
            } else if (dir == Direction.NORTH || dir == Direction.SOUTH) {
                obj.loader("gtcore:bookshelf");
            }
            arr.add(obj);
        }
        builder.property(state.toString().toLowerCase(), arr);
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlockEntityBookShelf) {
            BlockEntityBookShelf bookShelf = (BlockEntityBookShelf)blockEntity;
            return bookShelf.getEnchantmentPowerBonus();
        }
        return super.getEnchantPowerBonus(state, level, pos);
    }
}

