/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.awt.Color;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.gtreimagined.gtcore.block.BlockMaterialChest;
import org.gtreimagined.gtcore.blockentity.BlockEntityChest;
import org.gtreimagined.gtlib.machine.Tier;

public class MaterialChestRenderer<T extends BlockEntityChest>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation MATERIAL_CHEST_BASE = new ResourceLocation("gtcore", "model/material_chest_base");
    public static final ResourceLocation MATERIAL_CHEST_OVERLAY = new ResourceLocation("gtcore", "model/material_chest_overlay");
    private final ModelPart chestLid;
    private final ModelPart chestBottom;
    private final ModelPart chestLock;

    public MaterialChestRenderer(BlockEntityRendererProvider.Context ctx) {
        ModelPart modelpart = ctx.m_173582_(ModelLayers.f_171275_);
        this.chestBottom = modelpart.m_171324_("bottom");
        this.chestLid = modelpart.m_171324_("lid");
        this.chestLock = modelpart.m_171324_("lock");
    }

    private static float getLidOpenness(float delta) {
        delta = 1.0f - delta;
        delta = 1.0f - delta * delta * delta;
        return -delta * 1.5707964f;
    }

    public void render(T blockEntity, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pCombinedLight, int pCombinedOverlay) {
        Level world = blockEntity.m_58904_();
        boolean flag = world != null;
        BlockState blockstate = flag ? blockEntity.m_58900_() : (BlockState)blockEntity.getMachineType().getBlockState(Tier.LV).m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH);
        Block block = blockstate.m_60734_();
        if (block instanceof BlockMaterialChest) {
            BlockMaterialChest materialChest = (BlockMaterialChest)block;
            pMatrixStack.m_85836_();
            float f = ((Direction)blockstate.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_();
            pMatrixStack.m_85837_(0.5, 0.5, 0.5);
            pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-f));
            pMatrixStack.m_85837_(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult<? extends BlockEntityChest> iCallbackWrapper = flag ? materialChest.getWrapper(blockstate, world, blockEntity.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float f1 = ((Float2FloatFunction)iCallbackWrapper.m_5649_(BlockMaterialChest.getLid(blockEntity))).get(pPartialTicks);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)iCallbackWrapper.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(pCombinedLight);
            Material material = new Material(Sheets.f_110740_, MATERIAL_CHEST_BASE);
            VertexConsumer ivertexbuilder = material.m_119194_(pBuffer, RenderType::m_110452_);
            this.handleModelRender(pMatrixStack, ivertexbuilder, f1, i, pCombinedOverlay, materialChest.getBlockColor(blockstate, (BlockGetter)world, blockEntity.m_58899_(), 0), MaterialChestRenderer.getLidOpenness(((BlockEntityChest)((Object)blockEntity)).m_6683_(pPartialTicks)));
            material = new Material(Sheets.f_110740_, MATERIAL_CHEST_OVERLAY);
            ivertexbuilder = material.m_119194_(pBuffer, RenderType::m_110452_);
            this.handleModelRender(pMatrixStack, ivertexbuilder, f1, i, pCombinedOverlay, materialChest.getBlockColor(blockstate, (BlockGetter)world, blockEntity.m_58899_(), 1), MaterialChestRenderer.getLidOpenness(((BlockEntityChest)((Object)blockEntity)).m_6683_(pPartialTicks)));
            pMatrixStack.m_85849_();
        }
    }

    private void handleModelRender(PoseStack matrixStackIn, VertexConsumer iVertexBuilder, float f1, int i, int pCombinedOverlay, int color, float openness) {
        this.chestLock.f_104203_ = this.chestLid.f_104203_ = openness;
        Color colorValue = new Color(color);
        float[] colorArray = colorValue.getRGBColorComponents(null);
        this.chestLid.m_104306_(matrixStackIn, iVertexBuilder, i, pCombinedOverlay, colorArray[0], colorArray[1], colorArray[2], 1.0f);
        this.chestLock.m_104301_(matrixStackIn, iVertexBuilder, i, pCombinedOverlay);
        this.chestBottom.m_104306_(matrixStackIn, iVertexBuilder, i, pCombinedOverlay, colorArray[0], colorArray[1], colorArray[2], 1.0f);
    }
}

