/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.tree.ResinState;
import org.gtreimagined.gtcore.tree.block.BlockRubberLog;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;

public class BlockEntitySapBag
extends BlockEntityBase<BlockEntitySapBag> {
    ItemStack sap = ItemStack.f_41583_;
    Direction facing = Direction.NORTH;

    public BlockEntitySapBag(BlockPos pos, BlockState state) {
        super(GTCoreBlocks.SAP_BAG_BLOCK_ENTITY, pos, state);
    }

    public void checkRubber() {
        BlockState state = this.f_58857_.m_8055_(this.m_58899_().m_142300_(this.facing));
        if ((state.m_60734_() == GTCoreBlocks.RUBBER_LOG || state.m_60734_() == GTCoreBlocks.STRIPPED_RUBBER_LOG) && state.m_61143_(ResinState.INSTANCE) == ResinState.FILLED && state.m_61143_((Property)BlockRubberLog.RESIN_FACING) == this.facing.m_122424_()) {
            boolean successful = false;
            int amount = 1 + this.f_58857_.f_46441_.nextInt(3);
            if (this.sap.m_41619_()) {
                this.setSap(new ItemStack(GTCoreItems.StickyResin, amount));
                successful = true;
            } else if (this.sap.m_41613_() < 64) {
                this.growSap(amount);
                successful = true;
            }
            if (successful) {
                this.f_58857_.m_46597_(this.m_58899_().m_142300_(this.facing), (BlockState)state.m_61124_(ResinState.INSTANCE, (Comparable)((Object)ResinState.EMPTY)));
            }
        }
    }

    public void onBlockUpdate() {
        this.checkRubber();
    }

    public void setFacing(Direction facing) {
        this.facing = facing;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public ItemStack getSap() {
        return this.sap;
    }

    public void setSap(ItemStack sap) {
        this.sidedSync(true);
        this.sap = sap;
    }

    public void growSap(int amount) {
        this.sidedSync(true);
        this.sap.m_41769_(amount);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("F", this.facing.m_122411_());
        tag.m_128365_("S", (Tag)this.sap.m_41739_(new CompoundTag()));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.facing = Direction.m_122376_((int)nbt.m_128451_("F"));
        this.sap = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("S"));
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("F", this.facing.m_122411_());
        tag.m_128365_("S", (Tag)this.sap.m_41739_(new CompoundTag()));
        return tag;
    }
}

