/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.block;

import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gtcore.block.BlockRedstoneWire;
import org.gtreimagined.gtcore.blockentity.BlockEntityRedstoneWire;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.PipeType;

public class RedstoneWire<T extends RedstoneWire<T>>
extends PipeType<T> {
    int onColor;
    int range;
    boolean initializing;
    boolean emitsLight = false;

    public RedstoneWire(String domain, Material material, int onColor) {
        super(domain, material, BlockEntityRedstoneWire::new);
        this.onColor = onColor;
        this.initializing = true;
        this.sizes(new PipeSize[]{PipeSize.VTINY, PipeSize.TINY});
        this.initializing = false;
    }

    public T sizes(PipeSize ... sizes) {
        if (!this.initializing) {
            return (T)((Object)this);
        }
        return (T)((Object)((RedstoneWire)super.sizes(sizes)));
    }

    public String getType() {
        return "wire";
    }

    public Set<Block> getBlocks() {
        return this.sizes.stream().map(s -> new BlockRedstoneWire<RedstoneWire>(this, (PipeSize)s)).collect(Collectors.toSet());
    }

    public String getTypeName() {
        return "redstone";
    }

    public int getOnColor() {
        return this.onColor;
    }

    public int getRange() {
        return this.range;
    }

    public T range(int range) {
        this.range = range;
        return (T)((Object)this);
    }

    public T emitsLight() {
        this.emitsLight = true;
        return (T)((Object)this);
    }

    public boolean isEmitsLight() {
        return this.emitsLight;
    }
}

