/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.loader.crafting;

import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import org.gtreimagined.gtcore.machine.DrumMachine;
import org.gtreimagined.gtcore.machine.HopperMachine;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;

public class MachineRecipes {
    public static void initRecipes(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        GTAPI.all(DrumMachine.class).forEach(d -> {
            Material m = d.getMaterial();
            if (m.has(new IMaterialTag[]{GTMaterialTypes.PLATE}) && (m.has(new IMaterialTag[]{GTMaterialTypes.LONG_ROD}) || m.has(new IMaterialTag[]{GTMaterialTypes.ROD}))) {
                TagKey rod = m.has(new IMaterialTag[]{GTMaterialTypes.LONG_ROD}) ? GTMaterialTypes.LONG_ROD.getMaterialTag(m) : GTMaterialTypes.ROD.getMaterialTag(m);
                provider.addItemRecipe(output, "gtcore", "", "machines", (ItemLike)d.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('R'), (Object)rod, (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m)), new String[]{" H ", "PRP", "PRP"});
            }
        });
        GTAPI.all(HopperMachine.class).forEach(h -> {
            Material m = h.getMaterial();
            if (m.has(new IMaterialTag[]{GTMaterialTypes.PLATE})) {
                provider.addItemRecipe(output, "gtcore", "", "machines", (ItemLike)h.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('C'), (Object)Tags.Items.CHESTS_WOODEN, (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m)), new String[]{"PWP", "PCP", " P "});
            }
        });
    }
}

