/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.datagen;

import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtcore.data.GTCoreCables;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreMaterials;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTLibTags;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.providers.GTBlockTagProvider;
import org.gtreimagined.gtlib.datagen.providers.GTItemTagProvider;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.Cable;
import org.gtreimagined.gtlib.pipe.types.Wire;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.gtlib.util.TagUtils;

public class GTCoreItemTagProvider
extends GTItemTagProvider {
    public GTCoreItemTagProvider(String providerDomain, String providerName, boolean replace, GTBlockTagProvider p) {
        super(providerDomain, providerName, replace, p);
    }

    protected void processTags(String domain) {
        Material[] materials;
        super.processTags(domain);
        this.processSubtags();
        this.copy(TagUtils.getBlockTag((ResourceLocation)new ResourceLocation("gtcore", "rubber_logs")), GTCoreTags.RUBBER_LOGS);
        this.tag(ItemTags.f_13143_).add((Object)GTCoreBlocks.RUBBER_LEAVES.m_5456_());
        this.tag(ItemTags.f_13168_).add((Object[])new Item[]{GTCoreBlocks.RUBBER_PLANKS.m_5456_(), GTMaterialTypes.PLATE.get(GTLibMaterials.Wood)});
        this.tag(ItemTags.f_13139_).add((Object)GTCoreBlocks.RUBBER_SLAB.m_5456_());
        this.tag(ItemTags.f_13138_).add((Object)GTCoreBlocks.RUBBER_STAIRS.m_5456_());
        this.tag(ItemTags.f_13157_).add((Object)GTCoreBlocks.RUBBER_SIGN.m_5456_());
        this.tag(ItemTags.f_13170_).add((Object)GTCoreBlocks.RUBBER_BUTTON.m_5456_());
        this.tag(ItemTags.f_13173_).add((Object)GTCoreBlocks.RUBBER_DOOR.m_5456_());
        this.tag(ItemTags.f_13176_).add((Object)GTCoreBlocks.RUBBER_FENCE.m_5456_());
        this.tag(ItemTags.f_13177_).add((Object)GTCoreBlocks.RUBBER_PRESSURE_PLATE.m_5456_());
        this.tag(ItemTags.f_13175_).add((Object)GTCoreBlocks.RUBBER_SLAB.m_5456_());
        this.tag(ItemTags.f_13174_).add((Object)GTCoreBlocks.RUBBER_STAIRS.m_5456_());
        this.tag(ItemTags.f_13178_).add((Object)GTCoreBlocks.RUBBER_TRAPDOOR.m_5456_());
        this.tag(GTCoreTags.INGOTS_MIXED_METAL).add((Object)GTCoreItems.MixedMetalIngot);
        this.tag(GTLibTags.RADIATION_PROOF).add((Object[])new Item[]{GTCoreItems.UniversalHazardSuitMask, GTCoreItems.UniversalHazardSuitShirt, GTCoreItems.UniversalHazardSuitPants, GTCoreItems.UniversalHazardSuitBoots});
        if (GTAPI.isModLoaded((String)"farmersdelight")) {
            this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("farmersdelight:tools/knives"))).addTag(GTTools.KNIFE.getTag());
        }
        if (GTAPI.isModLoaded((String)"tfc")) {
            this.tag(ItemTags.f_13176_).add((Object)((Item)GTAPI.get(Item.class, (String)"rubber_log_fence", (String)"gtcore")));
            this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "lumber"))).add((Object)((Item)GTAPI.get(Item.class, (String)"rubber_lumber", (String)"gtcore")));
            this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "twigs"))).add((Object)((Item)GTAPI.get(Item.class, (String)"rubber_twig", (String)"gtcore")));
            this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "fallen_leaves"))).add((Object)((Item)GTAPI.get(Item.class, (String)"rubber_fallen_leaves", (String)"gtcore")));
            this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "firepit_fuel"))).addTag(GTCoreTags.RUBBER_LOGS);
            this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "firepit_logs"))).addTag(GTCoreTags.RUBBER_LOGS);
            this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "firepit_fuel"))).addTag(GTCoreTags.RUBBER_LOGS);
            this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "pit_kiln_logs"))).addTag(GTCoreTags.RUBBER_LOGS);
            this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "log_pile_logs"))).addTag(GTCoreTags.RUBBER_LOGS);
        }
        if (GTAPI.isModLoaded((String)"curios")) {
            this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("curios", "belt"))).addTag(GTCoreTags.BATTERIES_LV).addTag(GTCoreTags.BATTERIES_MV).addTag(GTCoreTags.BATTERIES_HV);
        }
        this.tag(GTCoreTags.POWER_UNIT_LV).add((Object)GTCoreItems.PowerUnitLV);
        this.tag(GTCoreTags.POWER_UNIT_MV).add((Object)GTCoreItems.PowerUnitMV);
        this.tag(GTCoreTags.POWER_UNIT_HV).add((Object)GTCoreItems.PowerUnitHV);
        this.tag(GTCoreTags.POWER_UNIT_SMALL).add((Object)GTCoreItems.SmallPowerUnit);
        this.tag(GTCoreTags.POWER_UNIT_JACKHAMMER).add((Object)GTCoreItems.JackhammerPowerUnit);
        this.tag(GTCoreTags.FIRESTARTER).add((Object[])new Item[]{Items.f_42409_, GTCoreItems.Match, GTCoreItems.Lighter, GTCoreItems.MatchBook});
        this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("twilightforest", "banned_uncraftables"))).add((Object[])((Item[])GTAPI.all(Item.class).toArray(Item[]::new)));
        this.tag(GTCoreTags.MAGNETIC_TOOL).add((Object[])new Item[]{((IGTTool)GTAPI.get(IGTTool.class, (String)"electric_wrench_lv", (String)"gtcore")).getItem(), ((IGTTool)GTAPI.get(IGTTool.class, (String)"electric_wrench_mv", (String)"gtcore")).getItem(), ((IGTTool)GTAPI.get(IGTTool.class, (String)"electric_wrench_hv", (String)"gtcore")).getItem(), ((IGTTool)GTAPI.get(IGTTool.class, (String)"drill_lv", (String)"gtcore")).getItem(), ((IGTTool)GTAPI.get(IGTTool.class, (String)"drill_mv", (String)"gtcore")).getItem(), ((IGTTool)GTAPI.get(IGTTool.class, (String)"drill_hv", (String)"gtcore")).getItem(), ((IGTTool)GTAPI.get(IGTTool.class, (String)"electric_wrench_alt_lv", (String)"gtcore")).getItem(), ((IGTTool)GTAPI.get(IGTTool.class, (String)"electric_wrench_alt_mv", (String)"gtcore")).getItem(), ((IGTTool)GTAPI.get(IGTTool.class, (String)"electric_wrench_alt_hv", (String)"gtcore")).getItem(), ((IGTTool)GTAPI.get(IGTTool.class, (String)"chainsaw_lv", (String)"gtcore")).getItem(), ((IGTTool)GTAPI.get(IGTTool.class, (String)"chainsaw_mv", (String)"gtcore")).getItem(), ((IGTTool)GTAPI.get(IGTTool.class, (String)"chainsaw_hv", (String)"gtcore")).getItem()});
        for (Material material : materials = new Material[]{GTCoreMaterials.IronMagnetic, GTCoreMaterials.SteelMagnetic, GTCoreMaterials.NeodymiumMagnetic}) {
            if (!material.has(new IMaterialTag[]{MaterialTags.TOOLS})) continue;
            this.tag(GTCoreTags.MAGNETIC_TOOL).add((Object[])new Item[]{GTTools.PICKAXE.getToolItem(material), GTTools.WRENCH.getToolItem(material), GTTools.WRENCH_ALT.getToolItem(material), GTTools.SHOVEL.getToolItem(material), GTTools.AXE.getToolItem(material)});
        }
    }

    protected void processSubtags() {
        for (PipeSize value : PipeSize.values()) {
            Set mats = MaterialTags.WIRE.allSub(GTCoreCables.TIN_WIRE);
            if (mats.size() > 0) {
                this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("gtlib", GTCoreCables.TIN_WIRE.getId() + "_" + value.getId()))).add((Object[])((Item[])mats.stream().map(t -> (Wire)GTAPI.get(Wire.class, (String)("wire_" + t.getId()))).filter(Objects::nonNull).map(t -> t.getBlockItem(value)).toArray(Item[]::new)));
            }
            if ((mats = MaterialTags.CABLE.allSub(GTCoreCables.TIN_CABLE)).size() <= 0) continue;
            this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("gtlib", GTCoreCables.TIN_CABLE.getId() + "_" + value.getId()))).add((Object[])((Item[])mats.stream().map(t -> (Cable)GTAPI.get(Cable.class, (String)("cable_" + t.getId()))).filter(Objects::nonNull).map(t -> t.getBlockItem(value)).toArray(Item[]::new)));
        }
    }
}

