/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.gtreimagined.gtcore.machine.BlockMachineMaterial;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.builder.GTItemModelBuilder;
import org.gtreimagined.gtlib.datagen.builder.VariantBlockStateBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTBlockStateProvider;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;

public class BlockGTHopper
extends BlockMachineMaterial {
    public static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape FUNNEL = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    public static final VoxelShape BASE = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)FUNNEL);
    public static final VoxelShape DOWN_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));
    public static final VoxelShape EAST_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)12.0, (double)4.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0));
    public static final VoxelShape NORTH_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0));
    public static final VoxelShape SOUTH_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0));
    public static final VoxelShape WEST_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0));

    public BlockGTHopper(Machine<?> type, Tier tier) {
        super(type, tier);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61373_, (Comparable)Direction.DOWN));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61373_});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Player player;
        EntityCollisionContext collisionContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (collisionContext = (EntityCollisionContext)context).m_193113_()) instanceof Player && Utils.isPlayerHolding((Player)(player = (Player)entity), (InteractionHand)InteractionHand.MAIN_HAND, (GTToolType[])new GTToolType[]{GTTools.WRENCH})) {
            return Shapes.m_83144_();
        }
        return switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61373_)) {
            case Direction.DOWN -> DOWN_SHAPE;
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> BASE;
        };
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61373_, (Comparable)(direction.m_122434_() == Direction.Axis.Y ? Direction.DOWN : direction));
    }

    @Override
    public void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        ((GTItemModelBuilder)((GTItemModelBuilder)((GTItemModelBuilder)prov.getBuilder(item).parent(prov.existing("gtcore", "block/hopper"))).texture("side", (ResourceLocation)new Texture("gtcore", "block/machine/base/hopper/side"))).texture("bottom", (ResourceLocation)new Texture("gtcore", "block/machine/base/hopper/bottom"))).texture("top", (ResourceLocation)new Texture("gtcore", "block/machine/base/hopper/top"));
    }

    public void onBlockModelBuild(Block block, GTBlockStateProvider prov) {
        prov.getVariantBuilder(block).forAllStates(b -> {
            VariantBlockStateBuilder.VariantBuilder builder = new VariantBlockStateBuilder.VariantBuilder();
            Direction facing = (Direction)b.m_61143_((Property)BlockStateProperties.f_61373_);
            String hopper = facing == Direction.DOWN ? "" : "_side";
            builder.modelFile(new ResourceLocation("gtcore", "block/hopper" + hopper));
            if (facing == Direction.EAST || facing == Direction.WEST || facing == Direction.SOUTH) {
                builder.rotationY(facing == Direction.EAST ? 90 : (facing == Direction.SOUTH ? 180 : 270));
            }
            return builder;
        });
    }
}

