/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.network;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gtcore.GTCore;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.gui.SlotType;

public class MessageInventorySync
implements Packet<MessageInventorySync> {
    public static final PacketHandler<MessageInventorySync> HANDLER = new Handler();
    SlotType<?> type;
    int slot;
    ItemStack stack;
    BlockPos pos;

    public MessageInventorySync(BlockPos pos, SlotType<?> type, int slot, ItemStack stack) {
        this.type = type;
        this.slot = slot;
        this.stack = stack;
        this.pos = pos;
    }

    public ResourceLocation getID() {
        return GTCore.INV_SYNC_ID;
    }

    public PacketHandler<MessageInventorySync> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<MessageInventorySync> {
        private Handler() {
        }

        public void encode(MessageInventorySync inventorySync, FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.m_130064_(inventorySync.pos);
            friendlyByteBuf.m_130070_(inventorySync.type.getId());
            friendlyByteBuf.m_130130_(inventorySync.slot);
            this.writeItemNoLimit(friendlyByteBuf, inventorySync.stack);
        }

        public void writeItemNoLimit(FriendlyByteBuf buf, ItemStack stack) {
            if (stack.m_41619_()) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                Item item = stack.m_41720_();
                buf.m_130130_(Item.m_41393_((Item)item));
                buf.writeInt(stack.m_41613_());
                CompoundTag compoundTag = null;
                if (item.m_41465_() || item.m_41468_()) {
                    compoundTag = stack.m_41783_();
                }
                buf.m_130079_(compoundTag);
            }
        }

        public ItemStack readItemNoLimit(FriendlyByteBuf buf) {
            if (!buf.readBoolean()) {
                return ItemStack.f_41583_;
            }
            int i = buf.m_130242_();
            int j = buf.readInt();
            ItemStack itemStack = new ItemStack((ItemLike)Item.m_41445_((int)i), j);
            itemStack.m_41751_(buf.m_130260_());
            return itemStack;
        }

        public MessageInventorySync decode(FriendlyByteBuf friendlyByteBuf) {
            return new MessageInventorySync(friendlyByteBuf.m_130135_(), (SlotType)GTAPI.get(SlotType.class, (String)friendlyByteBuf.m_130277_(), (String)"gtlib"), friendlyByteBuf.m_130242_(), this.readItemNoLimit(friendlyByteBuf));
        }

        public PacketContext handle(MessageInventorySync inventorySync) {
            return (player, level) -> {
                BlockEntity blockEntity;
                if (player != null && (blockEntity = level.m_7702_(inventorySync.pos)) instanceof BlockEntityMachine) {
                    BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
                    machine.itemHandler.ifPresent(i -> {
                        ITrackedHandler handler = i.getHandler(inventorySync.type);
                        if (handler.getSlots() > 0 && inventorySync.slot < handler.getSlots()) {
                            handler.setStackInSlot(inventorySync.slot, inventorySync.stack);
                        }
                    });
                }
            };
        }
    }
}

