/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.cover.IHaveCover;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class ItemSelectorTag
extends ItemBasic<ItemSelectorTag>
implements IHaveCover {
    public final int circuitId;

    public ItemSelectorTag(String domain, String id, int circuitId, Item.Properties properties) {
        super(domain, id, "selector_tags/", properties);
        this.circuitId = circuitId;
    }

    public ItemSelectorTag(String domain, String id, int circuitId) {
        super(domain, id, "selector_tags/");
        this.circuitId = circuitId;
    }

    public Texture[] getTextures() {
        return new Texture[]{new Texture(this.domain, "item/basic/" + this.subDir + this.circuitId)};
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        int newId = playerIn.m_6047_() ? this.getNewCircuitIdBackward() : this.getNewCircuitIdForward();
        ItemStack stack = playerIn.m_21120_(handIn);
        ItemStack newStack = new ItemStack((ItemLike)GTCoreItems.SELECTOR_TAG_ITEMS.get((Object)newId), stack.m_41613_());
        playerIn.m_21008_(handIn, newStack);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    private int getNewCircuitIdForward() {
        if (this.circuitId == 24) {
            return 0;
        }
        return this.circuitId + 1;
    }

    private int getNewCircuitIdBackward() {
        if (this.circuitId == 0) {
            return 24;
        }
        return this.circuitId - 1;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gtcore.selector_tag.0", (Object[])new Object[0]));
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gtcore.selector_tag.1", (Object[])new Object[0]));
    }

    public CoverFactory getCover() {
        if (this.circuitId > 15) {
            return ICover.emptyFactory;
        }
        return (CoverFactory)GTCoreItems.SELECTOR_TAG_COVERS.get((Object)this.circuitId);
    }
}

