/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.gtreimagined.gtcore.blockentity.BlockEntityMaterial;
import org.gtreimagined.gtcore.blockentity.ILimitedOutputTile;
import org.gtreimagined.gtcore.machine.HopperItemHandler;
import org.gtreimagined.gtcore.machine.MaterialMachine;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class BlockEntityGTHopper
extends BlockEntityMaterial<BlockEntityGTHopper>
implements ILimitedOutputTile {
    protected int stackLimit = 0;
    boolean observeStackLimit = false;
    boolean disabled = false;

    public BlockEntityGTHopper(MaterialMachine type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemHandler.set(() -> new HopperItemHandler(this));
    }

    public Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)BlockStateProperties.f_61373_);
    }

    public boolean setFacing(Direction side) {
        if (side == Direction.UP) {
            return false;
        }
        boolean isEmpty = this.coverHandler.map(ch -> ch.get(side).isEmpty()).orElse(true);
        if (!isEmpty) {
            return false;
        }
        BlockState state = (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61373_, (Comparable)side);
        this.m_58904_().m_46597_(this.m_58899_(), state);
        this.invalidateCaps();
        return true;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        BlockEntity above;
        BlockEntity neighbor;
        super.serverTick(level, pos, state);
        if (this.disabled || level.m_46467_() % 2L != 0L) {
            return;
        }
        if (this.itemHandler.map(i -> !i.getHandler(SlotType.STORAGE).isEmpty()).orElse(false).booleanValue() && (neighbor = this.getCachedBlockEntity(this.getFacing())) != null) {
            neighbor.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getFacing().m_122424_()).ifPresent(adjHandler -> this.itemHandler.ifPresent(h -> Utils.transferItems((IItemHandler)h.getHandler(SlotType.STORAGE), (IItemHandler)adjHandler, (boolean)true)));
        }
        if ((above = this.getCachedBlockEntity(Direction.UP)) != null) {
            this.itemHandler.ifPresent(to -> above.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).ifPresent(from -> Utils.transferItems((IItemHandler)from, (IItemHandler)to.getHandler(SlotType.STORAGE), (boolean)true)));
        }
    }

    public void onFirstTickServer(Level level, BlockPos pos, BlockState state) {
        super.onFirstTickServer(level, pos, state);
        for (Direction direction : Direction.values()) {
            if (level.m_46681_(this.m_58899_().m_142300_(direction), direction) <= 0) continue;
            this.disabled = true;
        }
    }

    public void onBlockUpdate(BlockPos neighbor) {
        super.onBlockUpdate(neighbor);
        Direction side = Utils.getOffsetFacing((BlockPos)this.m_58899_(), (BlockPos)neighbor);
        if (side != null) {
            this.disabled = this.f_58857_.m_46681_(neighbor, side) > 0;
        }
    }

    public InteractionResult onInteractServer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable GTToolType type) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(GTTools.SCREWDRIVER.getTag())) {
            if (!this.observeStackLimit) {
                if (this.stackLimit > 0 && this.stackLimit < 65) {
                    this.observeStackLimit = true;
                } else {
                    int n = this.stackLimit = player.m_6047_() ? 65 : 0;
                }
            }
            this.stackLimit = player.m_6047_() ? --this.stackLimit : ++this.stackLimit;
            if (this.stackLimit == 65 || this.stackLimit == 0) {
                this.observeStackLimit = false;
                player.m_6352_((Component)Utils.translatable((String)"machine.gtcore.no_stack_limit", (Object[])new Object[0]), player.m_142081_());
            } else {
                player.m_6352_((Component)Utils.translatable((String)"machine.gtcore.stack_limit", (Object[])new Object[]{this.stackLimit}), player.m_142081_());
            }
            stack.m_41629_(1, world.f_46441_, (ServerPlayer)player);
            return InteractionResult.SUCCESS;
        }
        return super.onInteractServer(state, world, pos, player, hand, hit, type);
    }

    @Override
    public int getStackLimit() {
        return this.stackLimit;
    }

    @Override
    public boolean hasStackLimit() {
        return this.observeStackLimit;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("stackLimit", this.stackLimit);
        tag.m_128379_("observeStackLimit", this.observeStackLimit);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.stackLimit = tag.m_128451_("stackLimit");
        this.observeStackLimit = tag.m_128471_("observeStackLimit");
    }
}

