/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.blockentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.gtreimagined.gtcore.blockentity.BlockEntityMaterial;
import org.gtreimagined.gtcore.machine.DrumMachine;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.FluidHandler;
import org.gtreimagined.gtlib.capability.fluid.FluidTanks;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.data.GTLibTags;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class BlockEntityDrum
extends BlockEntityMaterial<BlockEntityDrum> {
    FluidStack drop = FluidStack.EMPTY;
    boolean output = false;

    public BlockEntityDrum(DrumMachine type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidHandler.set(() -> new DrumFluidHandler(this));
    }

    public InteractionResult onInteractServer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable GTToolType type) {
        boolean[] success = new boolean[1];
        this.fluidHandler.ifPresent(f -> {
            DrumFluidHandler dF = (DrumFluidHandler)((Object)f);
            if (type == GTTools.WRENCH && !player.m_6144_()) {
                dF.setOutput(!dF.isOutput());
                success[0] = true;
                player.m_6330_(Ref.WRENCH, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_6352_((Component)Utils.literal((String)((dF.isOutput() ? "Will" : "Won't") + " fill adjacent Tanks")), player.m_142081_());
            }
        });
        if (success[0]) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void onRemove() {
        this.fluidHandler.ifPresent(f -> {
            this.drop = f.getFluidInTank(0);
            this.output = ((DrumFluidHandler)((Object)f)).isOutput();
        });
        super.onRemove();
    }

    public void onDrop(BlockState state, LootContext.Builder builder, List<ItemStack> drops) {
        if (!drops.isEmpty()) {
            ItemStack stack = drops.get(0);
            if (!this.getDrop().isEmpty()) {
                stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(f -> f.fill(this.drop, IFluidHandler.FluidAction.EXECUTE));
            }
            if (this.isOutput()) {
                CompoundTag nbt = stack.m_41784_();
                nbt.m_128379_("Outputs", this.isOutput());
            }
        }
    }

    public void onPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.onPlacedBy(world, pos, state, placer, stack);
        CompoundTag nbt = stack.m_41783_();
        this.fluidHandler.ifPresent(f -> {
            FluidStack fluid;
            FluidStack fluidStack = fluid = nbt != null && nbt.m_128441_("Fluid") ? FluidUtils.fromTag((CompoundTag)nbt.m_128469_("Fluid")) : stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(fi -> fi.getFluidInTank(0)).orElse(FluidStack.EMPTY);
            if (!fluid.isEmpty()) {
                f.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            }
            if (nbt != null && nbt.m_128441_("Outputs")) {
                ((DrumFluidHandler)((Object)f)).setOutput(nbt.m_128471_("Outputs"));
            }
        });
    }

    public FluidStack getDrop() {
        return this.drop;
    }

    public boolean isOutput() {
        return this.output;
    }

    public List<String> getInfo(boolean simple) {
        List list = super.getInfo(simple);
        this.fluidHandler.ifPresent(f -> {
            FluidStack stack = f.getInputTanks().getFluidInTank(0);
            list.add("Fluid: " + (String)(stack.isEmpty() ? "Empty" : stack.getAmount() + "mb of " + FluidUtils.getFluidDisplayName((FluidStack)stack).getString()));
        });
        list.add("Auto Output: " + this.isOutput());
        return list;
    }

    public static class DrumFluidHandler
    extends MachineFluidHandler<BlockEntityDrum> {
        boolean output = false;

        public DrumFluidHandler(BlockEntityDrum tile) {
            super((BlockEntityMachine)tile);
            this.tanks.put(FluidHandler.FluidDirection.INPUT, FluidTanks.create((BlockEntityBase)tile, (IMachineEvent)SlotType.FL_IN, b -> {
                b.tank(((DrumMachine)tile.getMachineType()).maxCapacity);
                return b;
            }));
        }

        public void setOutput(boolean output) {
            this.output = output;
        }

        public boolean isOutput() {
            return this.output;
        }

        @Nullable
        public FluidTanks getOutputTanks() {
            return super.getInputTanks();
        }

        protected FluidTank getTank(int tank) {
            return this.getInputTanks().getTank(tank);
        }

        public FluidTanks getTanks(int tank) {
            return this.getInputTanks();
        }

        public void onUpdate() {
            super.onUpdate();
            if (this.output) {
                Direction dir;
                Direction direction = dir = FluidUtils.getFluidDensity((Fluid)this.getTank(0).getFluid().getFluid()) < 0 ? Direction.UP : Direction.DOWN;
                if (this.getTank(0).getFluid().getAmount() > 0) {
                    FluidUtils.getFluidHandler((Level)((BlockEntityDrum)this.tile).m_58904_(), (BlockPos)((BlockEntityDrum)this.tile).m_58899_().m_142300_(dir), (BlockEntity)((BlockEntityDrum)this.tile).getCachedBlockEntity(dir), (Direction)dir.m_122424_()).ifPresent(other -> Utils.transferFluids((IFluidHandler)this, (IFluidHandler)other, (int)1000));
                }
            }
        }

        public CompoundTag serialize(CompoundTag nbt) {
            super.serialize(nbt);
            nbt.m_128379_("Output", this.output);
            return nbt;
        }

        public void deserialize(CompoundTag nbt) {
            super.deserialize(nbt);
            this.output = nbt.m_128471_("Output");
        }

        public boolean canInput(FluidStack fluid, Direction direction) {
            boolean gaseous;
            boolean bl = gaseous = FluidUtils.getFluidDensity((Fluid)fluid.getFluid()) < 0;
            if (this.output && (direction == Direction.UP && gaseous || direction == Direction.DOWN && !gaseous)) {
                return false;
            }
            return super.canInput(fluid, direction);
        }

        public int fill(FluidStack fluid, IFluidHandler.FluidAction action) {
            int insert;
            DrumMachine drumMachine;
            Machine machine = ((BlockEntityDrum)this.tile).getMachineType();
            if (machine instanceof DrumMachine && !(drumMachine = (DrumMachine)machine).isAcidProof() && fluid.getFluid().m_205067_(GTLibTags.ACID) && (insert = super.fill(fluid, IFluidHandler.FluidAction.SIMULATE)) > 0) {
                if (action.execute()) {
                    ((BlockEntityDrum)this.tile).m_58904_().m_7731_(((BlockEntityDrum)this.tile).m_58899_(), Blocks.f_50016_.m_49966_(), 3);
                }
                return Math.min(16, fluid.getAmount());
            }
            return super.fill(fluid, action);
        }
    }
}

