/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.worldgen.feature;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.util.XSTR;
import org.gtreimagined.gtlib.worldgen.GTLibConfiguredFeatures;
import org.gtreimagined.gtlib.worldgen.VeinLayerResult;
import org.gtreimagined.gtlib.worldgen.WorldGenHelper;
import org.gtreimagined.gtlib.worldgen.feature.GTFeature;
import org.gtreimagined.gtlib.worldgen.vein.Vein;
import org.gtreimagined.gtlib.worldgen.vein.VeinData;

public class FeatureVein
extends GTFeature<NoneFeatureConfiguration> {
    public static Long2ObjectOpenHashMap<Vein> VALID_VEINS = new Long2ObjectOpenHashMap();

    public FeatureVein() {
        super(NoneFeatureConfiguration.f_67815_, Vein.class);
    }

    @Override
    public String getId() {
        return "veins";
    }

    @Override
    public boolean enabled() {
        return GTLibConfig.ORE_VEINS.get() && !VeinData.INSTANCE.getVeins().isEmpty();
    }

    @Override
    public void init() {
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> placer) {
        int chunkX = placer.m_159777_().m_123341_() >> 4;
        int chunkZ = placer.m_159777_().m_123343_() >> 4;
        for (Tuple<Integer, Integer> seed : FeatureVein.getVeinSeeds(chunkX, chunkZ)) {
            FeatureVein.generate(placer.m_159774_(), chunkX, chunkZ, (Integer)seed.m_14418_(), (Integer)seed.m_14419_());
        }
        return true;
    }

    public static void generate(WorldGenLevel world, int chunkX, int chunkZ, int oreSeedX, int oreSeedZ) {
        Map veins = VeinData.INSTANCE.getVeins((Level)world.m_6018_());
        if (veins.isEmpty()) {
            return;
        }
        long oreVeinSeed = FeatureVein.getOreVeinSeed(world, oreSeedX, oreSeedZ);
        XSTR oreVeinRNG = new XSTR(oreVeinSeed);
        int oreVeinPercentageRoll = oreVeinRNG.m_188503_(100);
        if (Ref.debugOreVein) {
            GTLib.LOGGER.info("Finding oreveins for oreVeinSeed=" + oreVeinSeed + " chunkX=" + chunkX + " chunkZ=" + chunkZ + " oreSeedX=" + oreSeedX + " oreSeedZ=" + oreSeedZ + " worldSeed=" + world.m_7328_());
        }
        if (!VALID_VEINS.containsKey(oreVeinSeed)) {
            int veinCount = veins.size();
            if (oreVeinPercentageRoll < GTLibConfig.ORE_VEIN_CHANCE.get() && VeinData.getTotalWeight() > 0 && veinCount > 0) {
                int i;
                int placementAttempts = 0;
                boolean oreVeinFound = false;
                block10: for (i = 0; i < GTLibConfig.ORE_VEIN_FIND_ATTEMPTS.get() && !oreVeinFound && placementAttempts < GTLibConfig.ORE_VEIN_PLACE_ATTEMPTS.get(); ++i) {
                    int tRandomWeight = oreVeinRNG.m_188503_(VeinData.getTotalWeight());
                    for (Map.Entry veinEntry : veins.entrySet()) {
                        Vein vein = (Vein)veinEntry.getValue();
                        if ((tRandomWeight -= vein.weight()) > 0) continue;
                        VeinLayerResult placementResult = FeatureVein.generateChunkified(vein, world, new XSTR(oreVeinSeed ^ (long)vein.primary().hashCode()), chunkX * 16, chunkZ * 16, oreSeedX * 16, oreSeedZ * 16);
                        switch (placementResult) {
                            case ORE_PLACED: {
                                if (Ref.debugOreVein) {
                                    GTLib.LOGGER.info("Added near oreVeinSeed=" + oreVeinSeed + " " + veinEntry.getKey() + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimension=" + world.m_6018_().m_46472_().m_135782_());
                                }
                                VALID_VEINS.put(oreVeinSeed, (Object)vein);
                                oreVeinFound = true;
                                break;
                            }
                            case NO_ORE_IN_BOTTOM_LAYER: {
                                ++placementAttempts;
                                break;
                            }
                            case NO_OVERLAP: {
                                if (Ref.debugOreVein) {
                                    GTLib.LOGGER.info("Added far oreVeinSeed=" + oreVeinSeed + " " + veinEntry.getKey() + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimension=" + world.m_6018_().m_46472_().m_135782_());
                                }
                                VALID_VEINS.put(oreVeinSeed, (Object)vein);
                                oreVeinFound = true;
                                break;
                            }
                            case NO_OVERLAP_AIR_BLOCK: {
                                if (Ref.debugOreVein) {
                                    GTLib.LOGGER.info("No overlap and air block in test spot=" + oreVeinSeed + " " + veinEntry.getKey() + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimension=" + world.m_6018_().m_46472_().m_135782_());
                                }
                                ++placementAttempts;
                            }
                        }
                        continue block10;
                    }
                }
                if (!oreVeinFound && chunkX == oreSeedX && chunkZ == oreSeedZ) {
                    if (Ref.debugOreVein) {
                        GTLib.LOGGER.info("Empty oreVeinSeed=" + oreVeinSeed + " chunkX=" + chunkX + " chunkZ=" + chunkZ + " oreSeedX=" + oreSeedX + " oreSeedZ=" + oreSeedZ + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimension=" + world.m_6018_().m_46472_().m_135782_());
                    }
                    VALID_VEINS.put(oreVeinSeed, (Object)Vein.NO_ORES_IN_VEIN);
                }
            } else if (oreVeinPercentageRoll >= GTLibConfig.ORE_VEIN_CHANCE.get()) {
                if (Ref.debugOreVein) {
                    GTLib.LOGGER.info("Skipped oreVeinSeed=" + oreVeinSeed + " chunkX=" + chunkX + " chunkZ=" + chunkZ + " oreSeedX=" + oreSeedX + " oreSeedZ=" + oreSeedZ + " RNG=" + oreVeinPercentageRoll + " %=" + GTLibConfig.ORE_VEIN_CHANCE.get() + " dimension=" + world.m_6018_().m_46472_().m_135782_());
                }
                VALID_VEINS.put(oreVeinSeed, (Object)Vein.NO_ORES_IN_VEIN);
            }
        } else {
            Vein vein;
            if (Ref.debugOreVein) {
                GTLib.LOGGER.info("Valid oreVeinSeed=" + oreVeinSeed + " VALID_VEINS.size()=" + VALID_VEINS.size() + " ");
            }
            if ((vein = (Vein)VALID_VEINS.get(oreVeinSeed)) == null) {
                throw new IllegalStateException("Valid veins returned null in WorldGenVeinlayer. This is an error");
            }
            if (vein.primary() != null) {
                oreVeinRNG.m_188584_(oreVeinSeed ^ (long)vein.primary().hashCode());
            }
            VeinLayerResult placementResult = FeatureVein.generateChunkified(vein, world, oreVeinRNG, chunkX * 16, chunkZ * 16, oreSeedX * 16, oreSeedZ * 16);
            switch (placementResult) {
                case NO_ORE_IN_BOTTOM_LAYER: {
                    if (!Ref.debugOreVein) break;
                    GTLib.LOGGER.info(" No ore in bottom layer");
                    break;
                }
                case NO_OVERLAP: {
                    if (!Ref.debugOreVein) break;
                    GTLib.LOGGER.info(" No overlap");
                }
            }
        }
    }

    static VeinLayerResult generateChunkified(Vein vein, WorldGenLevel world, XSTR rand, int posX, int posZ, int seedX, int seedZ) {
        int sZ;
        if (vein.equals(Vein.NO_ORES_IN_VEIN)) {
            return VeinLayerResult.NO_ORES_VEIN;
        }
        int bound = vein.maxY() - vein.minY() - 5;
        int tMinY = vein.minY() + (bound > 0 ? rand.m_188503_(bound) : 0);
        int wXVein = seedX - rand.m_188503_(vein.size());
        int eXVein = seedX + 16 + rand.m_188503_(vein.size());
        int wX = Math.max(wXVein, posX);
        int eX = Math.min(eXVein, posX + 16);
        BlockPos centerPos = new BlockPos(posX + 7, tMinY, posZ + 9);
        BlockState centerState = world.m_8055_(centerPos);
        if (wX >= eX) {
            if (WorldGenHelper.ORE_PREDICATE.test(centerState)) {
                return VeinLayerResult.NO_OVERLAP;
            }
            return VeinLayerResult.NO_OVERLAP_AIR_BLOCK;
        }
        int nZVein = seedZ - rand.m_188503_(vein.size());
        int sZVein = seedZ + 16 + rand.m_188503_(vein.size());
        int nZ = Math.max(nZVein, posZ);
        if (nZ >= (sZ = Math.min(sZVein, posZ + 16))) {
            if (WorldGenHelper.ORE_PREDICATE.test(centerState)) {
                return VeinLayerResult.NO_OVERLAP;
            }
            return VeinLayerResult.NO_OVERLAP_AIR_BLOCK;
        }
        if (Ref.debugOreVein) {
            GTLib.LOGGER.info("Trying Orevein:" + vein.getLoc() + " Dimension=" + world.m_6018_().m_46472_() + " posX=" + posX / 16 + " posZ=" + posZ / 16 + " oreseedX=" + seedX / 16 + " oreseedZ=" + seedZ / 16 + " cY=" + tMinY);
        }
        if (!FeatureVein.generateSquare(vein, (LevelAccessor)world, rand, posX, posZ, seedX, seedZ, tMinY, wXVein, eXVein, nZVein, sZVein, wX, eX, nZ, sZ)) {
            return VeinLayerResult.NO_ORE_IN_BOTTOM_LAYER;
        }
        if (GTLibConfig.ORE_VEIN_SMALL_ORE_MARKERS.get()) {
            int nSmallOres = (eX - wX) * (sZ - nZ) * vein.density() / 20 * GTLibConfig.ORE_VEIN_SMALL_ORE_MARKERS_MULTI.get();
            FeatureVein.generateMarkers(vein, (LevelAccessor)world, rand, posX, posZ, nSmallOres, 7);
        }
        return VeinLayerResult.ORE_PLACED;
    }

    static void generateMarkers(Vein vein, LevelAccessor world, XSTR rand, int posX, int posZ, int nSmallOres, int nRocks) {
        int tZ;
        int tX;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int nSmallOresCount = 0; nSmallOresCount < nSmallOres; ++nSmallOresCount) {
            tX = rand.m_188503_(16) + posX;
            tZ = rand.m_188503_(16) + posZ;
            int tY = rand.m_188503_(224) - 54;
            pos.m_122178_(tX, tY, tZ);
            WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.primary(), GTMaterialTypes.SMALL_ORE);
            tX = rand.m_188503_(16) + posX;
            tZ = rand.m_188503_(16) + posZ;
            tY = rand.m_188503_(224) - 54;
            pos.m_122178_(tX, tY, tZ);
            WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.secondary(), GTMaterialTypes.SMALL_ORE);
            tX = rand.m_188503_(16) + posX;
            tZ = rand.m_188503_(16) + posZ;
            tY = rand.m_188503_(224) - 54;
            pos.m_122178_(tX, tY, tZ);
            WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.between(), GTMaterialTypes.SMALL_ORE);
            tX = rand.m_188503_(16) + posX;
            tZ = rand.m_188503_(16) + posZ;
            tY = rand.m_188503_(254) - 54;
            pos.m_122178_(tX, tY, tZ);
            WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.sporadic(), GTMaterialTypes.SMALL_ORE);
        }
        if (GTLibConfig.ORE_VEIN_ROCKS.get() && GTLibConfig.SURFACE_ROCKS.get()) {
            for (int rockCount = 0; rockCount < nRocks; ++rockCount) {
                tX = rand.m_188503_(16) + posX;
                tZ = rand.m_188503_(16) + posZ;
                WorldGenHelper.addRock(world, (BlockPos)pos.m_122178_(tX, 0, tZ), vein.primary(), GTLibConfig.ORE_VEIN_ROCK_CHANCE.get());
                tX = rand.m_188503_(16) + posX;
                tZ = rand.m_188503_(16) + posZ;
                WorldGenHelper.addRock(world, (BlockPos)pos.m_122178_(tX, 0, tZ), vein.primary(), GTLibConfig.ORE_VEIN_ROCK_CHANCE.get() * 3 / 2);
                tX = rand.m_188503_(16) + posX;
                tZ = rand.m_188503_(16) + posZ;
                WorldGenHelper.addRock(world, (BlockPos)pos.m_122178_(tX, 0, tZ), vein.primary(), GTLibConfig.ORE_VEIN_ROCK_CHANCE.get() * 2);
                tX = rand.m_188503_(16) + posX;
                tZ = rand.m_188503_(16) + posZ;
                WorldGenHelper.addRock(world, (BlockPos)pos.m_122178_(tX, 0, tZ), vein.primary(), GTLibConfig.ORE_VEIN_ROCK_CHANCE.get() * 5 / 2);
            }
        }
    }

    static boolean generateSquare(Vein vein, LevelAccessor world, XSTR rand, int posX, int posZ, int seedX, int seedZ, int tMinY, int wXVein, int eXVein, int nZVein, int sZVein, int wX, int eX, int nZ, int sZ) {
        int placeZ;
        int tZ;
        int placeX;
        int tX;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int[] placeCount = new int[4];
        int localDensity = Math.max(1, vein.density() / (int)Math.sqrt(2.0 + Math.pow(posX / 16 - seedX / 16, 2.0) + Math.pow(posZ / 16 - seedZ / 16, 2.0)));
        int level = tMinY - 1;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                if (rand.m_188503_(placeZ) == 0 || rand.m_188503_(placeX) == 0) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.secondary(), GTMaterialTypes.ORE)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (rand.m_188503_(7) != 0 || rand.m_188503_(placeZ) != 0 && rand.m_188503_(placeX) != 0) continue;
                pos.m_122178_(tX, level, tZ);
                if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.sporadic(), GTMaterialTypes.ORE)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        if (placeCount[1] + placeCount[3] == 0) {
            if (Ref.debugOreVein) {
                GTLib.LOGGER.info(" No ore in bottom layer");
            }
            return false;
        }
        for (level = tMinY; level < tMinY + 2; ++level) {
            for (tX = wX; tX < eX; ++tX) {
                placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
                for (tZ = nZ; tZ < sZ; ++tZ) {
                    placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                    if (rand.m_188503_(placeZ) == 0 || rand.m_188503_(placeX) == 0) {
                        pos.m_122178_(tX, level, tZ);
                        if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.secondary(), GTMaterialTypes.ORE)) continue;
                        placeCount[1] = placeCount[1] + 1;
                        continue;
                    }
                    if (rand.m_188503_(7) != 0 || rand.m_188503_(placeZ) != 0 && rand.m_188503_(placeX) != 0) continue;
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.sporadic(), GTMaterialTypes.ORE)) continue;
                    placeCount[3] = placeCount[3] + 1;
                }
            }
        }
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                if (rand.m_188503_(2) == 0 && (rand.m_188503_(placeZ) == 0 || rand.m_188503_(placeX) == 0)) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.between(), GTMaterialTypes.ORE)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if (rand.m_188503_(placeZ) == 0 || rand.m_188503_(placeX) == 0) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.secondary(), GTMaterialTypes.ORE)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (rand.m_188503_(7) != 0 || rand.m_188503_(placeZ) != 0 && rand.m_188503_(placeX) != 0) continue;
                pos.m_122178_(tX, level, tZ);
                if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.sporadic(), GTMaterialTypes.ORE)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                if (rand.m_188503_(2) == 0 && (rand.m_188503_(placeZ) == 0 || rand.m_188503_(placeX) == 0)) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.between(), GTMaterialTypes.ORE)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if (rand.m_188503_(7) != 0 || rand.m_188503_(placeZ) != 0 && rand.m_188503_(placeX) != 0) continue;
                pos.m_122178_(tX, level, tZ);
                if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.sporadic(), GTMaterialTypes.ORE)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                if (rand.m_188503_(2) == 0 && (rand.m_188503_(placeZ) == 0 || rand.m_188503_(placeX) == 0)) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.between(), GTMaterialTypes.ORE)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if (rand.m_188503_(placeZ) == 0 || rand.m_188503_(placeX) == 0) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.primary(), GTMaterialTypes.ORE)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (rand.m_188503_(7) != 0 || rand.m_188503_(placeZ) != 0 && rand.m_188503_(placeX) != 0) continue;
                pos.m_122178_(tX, level, tZ);
                if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.sporadic(), GTMaterialTypes.ORE)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                if (rand.m_188503_(2) == 0 && (rand.m_188503_(placeZ) == 0 || rand.m_188503_(placeX) == 0)) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.between(), GTMaterialTypes.ORE)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if (rand.m_188503_(placeZ) == 0 || rand.m_188503_(placeX) == 0) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.primary(), GTMaterialTypes.ORE)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (rand.m_188503_(7) != 0 || rand.m_188503_(placeZ) != 0 && rand.m_188503_(placeX) != 0) continue;
                pos.m_122178_(tX, level, tZ);
                if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.sporadic(), GTMaterialTypes.ORE)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                if (rand.m_188503_(placeZ) == 0 || rand.m_188503_(placeX) == 0) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.primary(), GTMaterialTypes.ORE)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (rand.m_188503_(7) != 0 || rand.m_188503_(placeZ) != 0 && rand.m_188503_(placeX) != 0) continue;
                pos.m_122178_(tX, level, tZ);
                if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.sporadic(), GTMaterialTypes.ORE)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                if (rand.m_188503_(placeZ) == 0 || rand.m_188503_(placeX) == 0) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.primary(), GTMaterialTypes.ORE)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (rand.m_188503_(7) != 0 || rand.m_188503_(placeZ) != 0 && rand.m_188503_(placeX) != 0) continue;
                pos.m_122178_(tX, level, tZ);
                if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), vein.sporadic(), GTMaterialTypes.ORE)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        if (Ref.debugOreVein) {
            GTLib.LOGGER.info(" wXVein" + wXVein + " eXVein" + eXVein + " nZVein" + nZVein + " sZVein" + sZVein + " locDen=" + localDensity + " Den=" + vein.density() + " Sec=" + placeCount[1] + " Spo=" + placeCount[3] + " Bet=" + placeCount[2] + " Pri=" + placeCount[0]);
        }
        return true;
    }

    public static long getOreVeinSeed(WorldGenLevel world, long oreSeedX, long oreSeedZ) {
        return world.m_7328_() << 16 ^ (((long)world.m_6018_().m_46472_().m_135782_().hashCode() & 0xFFL) << 56 | (oreSeedX & 0xFFFFFFFL) << 28 | oreSeedZ & 0xFFFFFFFL);
    }

    public static List<Tuple<Integer, Integer>> getVeinSeeds(int chunkX, int chunkZ) {
        int westX = chunkX - GTLibConfig.ORE_VEIN_MAX_SIZE.get() / 16;
        int eastX = chunkX + (GTLibConfig.ORE_VEIN_MAX_SIZE.get() / 16 + 1);
        int northZ = chunkZ - GTLibConfig.ORE_VEIN_MAX_SIZE.get() / 16;
        int southZ = chunkZ + (GTLibConfig.ORE_VEIN_MAX_SIZE.get() / 16 + 1);
        ObjectArrayList res = new ObjectArrayList();
        for (int x = westX; x < eastX; ++x) {
            for (int z = northZ; z < southZ; ++z) {
                if (Math.abs(x) % 3 != 1 || Math.abs(z) % 3 != 1) continue;
                res.add(new Tuple((Object)x, (Object)z));
            }
        }
        return res;
    }

    @Override
    public void build(Holder<Biome> biomeHolder, Biome.ClimateSettings climate, BiomeSpecialEffects effects, BiomeGenerationSettingsBuilder gen, MobSpawnSettings.Builder spawns, Registry<PlacedFeature> placedFeatureRegistry) {
        gen.m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.getPlacedFeatureFromKey(placedFeatureRegistry, GTLibConfiguredFeatures.VEINS));
    }
}

