/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool.behaviour;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import org.gtreimagined.gtlib.behaviour.IItemHighlight;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.capability.ICoverHandlerProvider;
import org.gtreimagined.gtlib.client.RenderHelper;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.tool.IBasicGTTool;

public class BehaviourExtendedHighlight
implements IItemHighlight<IBasicGTTool> {
    final float INDENTATION_SIDE = 0.25f;
    final double INTERACT_DISTANCE = 5.0;
    protected Function<Block, Boolean> validator;
    protected BiFunction<Direction, BlockEntity, Boolean> function;
    public static final BiFunction<Direction, BlockEntity, Boolean> COVER_FUNCTION = (dir, tile) -> {
        if (tile instanceof ICoverHandlerProvider) {
            ICoverHandlerProvider base = (ICoverHandlerProvider)tile;
            return base.getCoverHandler().map(t -> !t.get((Direction)dir).isEmpty()).orElse(false);
        }
        return false;
    };
    public static final List<BiFunction<Direction, BlockEntity, Boolean>> EXTRA_PIPE_FUNCTIONS = new ArrayList<BiFunction<Direction, BlockEntity, Boolean>>();
    public static final BiFunction<Direction, BlockEntity, Boolean> PIPE_FUNCTION = (dir, tile) -> {
        for (BiFunction<Direction, BlockEntity, Boolean> extraPipeFunction : EXTRA_PIPE_FUNCTIONS) {
            if (!extraPipeFunction.apply((Direction)dir, (BlockEntity)tile).booleanValue()) continue;
            return true;
        }
        if (tile instanceof BlockEntityPipe) {
            BlockEntityPipe pipe = (BlockEntityPipe)tile;
            return Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_6047_() ? pipe.canConnectVirtual(dir.m_122411_()) : pipe.canConnect(dir.m_122411_());
        }
        if (tile instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)tile;
            Direction direction = machine.getOutputFacing();
            Direction secondary = machine.getSecondaryOutputFacing();
            if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_6047_() || machine.getMachineType().getOutputCover() == ICover.emptyFactory) {
                direction = machine.getFacing();
            }
            return direction != null && direction == dir || secondary != null && secondary == dir;
        }
        if (tile instanceof HopperBlockEntity) {
            HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)tile;
            if (dir != Direction.UP) {
                return hopperBlockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61373_) == dir;
            }
        }
        if (tile instanceof ChestBlockEntity) {
            ChestBlockEntity chestBlockEntity = (ChestBlockEntity)tile;
            if (dir.m_122434_().m_122479_()) {
                return chestBlockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == dir;
            }
        }
        return false;
    };

    public BehaviourExtendedHighlight(Function<Block, Boolean> validator, BiFunction<Direction, BlockEntity, Boolean> builder) {
        this.validator = validator;
        this.function = builder;
    }

    @Override
    public String getId() {
        return "extended_highlight";
    }

    @Override
    public InteractionResult onDrawHighlight(Player player, LevelRenderer levelRenderer, Camera camera, HitResult target, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource) {
        return RenderHelper.onDrawHighlight(player, levelRenderer, camera, target, partialTicks, poseStack, multiBufferSource, this.validator, this.function);
    }
}

