/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.behaviour.IBehaviour;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.tool.GTItemTier;
import org.gtreimagined.gtlib.tool.IBasicGTTool;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.gtlib.tool.MaterialSword;
import org.gtreimagined.gtlib.tool.MaterialTool;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class GTToolType
implements IGTObject {
    private final String domain;
    private final String id;
    private TagKey<Block> toolType;
    private final Set<TagKey<Block>> toolTypes = new ObjectOpenHashSet();
    private final Set<Block> effectiveBlocks = new ObjectOpenHashSet();
    private final Set<TagKey<Block>> effectiveBlockTags = new ObjectOpenHashSet();
    private final Object2ObjectMap<String, IBehaviour<IBasicGTTool>> behaviours = new Object2ObjectOpenHashMap();
    private ImmutableMap<String, Function<ItemStack, ItemStack>> brokenItems = ImmutableMap.of();
    private final Map<String, Supplier<Item>> replacements = new Object2ObjectOpenHashMap();
    private Set<Enchantment> blacklistedEnchantments = new HashSet<Enchantment>();
    private final List<Component> tooltip = new ObjectArrayList();
    private boolean powered;
    private boolean blockBreakability;
    private boolean hasContainer;
    private boolean hasSecondary;
    private boolean simple;
    private boolean repairable;
    private boolean originalTag = true;
    private long baseMaxEnergy;
    private int[] energyTiers;
    private int useDurability;
    private int attackDurability;
    private int craftingDurability;
    private float durabilityMultiplier = 1.0f;
    private float miningSpeedMultiplier = 1.0f;
    private int baseQuality;
    private int overlayLayers;
    private float baseAttackDamage;
    private float baseAttackSpeed;
    private CreativeModeTab itemGroup;
    protected TagKey<Item> tag;
    protected TagKey<Item> forgeTag;
    private UseAnim useAction;
    private Class<? extends IGTTool> toolClass;
    private IToolSupplier toolSupplier = null;
    @Nullable
    private SoundEvent useSound;
    @Nullable
    private IMaterialTag primaryMaterialRequirement;
    @Nullable
    private IMaterialTag secondaryMaterialRequirement;
    @Nullable
    private MaterialTypeItem<?> materialTypeItem;
    private Predicate<Material> materialTypeItemPredicate;
    private String customName = "";

    public GTToolType(String domain, String id, int useDurability, int attackDurability, int craftingDurability, float baseAttackDamage, float baseAttackSpeed, boolean vanillaType) {
        if (domain.isEmpty()) {
            Utils.onInvalidData("GTToolType registered with no domain name!");
        }
        this.domain = domain;
        if (id.isEmpty()) {
            Utils.onInvalidData("GTToolType registered with an empty ID!");
        }
        this.id = id;
        if (useDurability < 0) {
            Utils.onInvalidData(id + " cannot have a negative use durability value!");
        }
        if (attackDurability < 0) {
            Utils.onInvalidData(id + " cannot have a negative attack durability value!");
        }
        if (craftingDurability < 0) {
            Utils.onInvalidData(id + " cannot have a negative crafting durability value!");
        }
        this.useSound = null;
        this.repairable = true;
        this.blockBreakability = true;
        this.hasContainer = true;
        this.baseQuality = 0;
        this.useDurability = useDurability;
        this.attackDurability = attackDurability;
        this.craftingDurability = craftingDurability;
        this.baseAttackDamage = baseAttackDamage;
        this.baseAttackSpeed = baseAttackSpeed;
        this.overlayLayers = 1;
        this.itemGroup = Ref.TAB_TOOLS;
        String tagString = id.equals("wrench") ? id + "es" : (id.endsWith("s") ? id : id + "s");
        this.tag = TagUtils.getItemTag(new ResourceLocation("gtlib", tagString));
        this.forgeTag = TagUtils.getForgelikeItemTag("tools/".concat(tagString));
        this.useAction = UseAnim.NONE;
        this.toolClass = MaterialTool.class;
        this.simple = true;
        this.hasSecondary = true;
        this.toolType = vanillaType ? TagUtils.getBlockTag(new ResourceLocation("minecraft", "mineable/".concat(id))) : TagUtils.getBlockTag(new ResourceLocation("gtlib", "mineable/".concat(id)));
        this.materialTypeItemPredicate = m -> true;
        this.toolTypes.add(this.toolType);
        this.setBrokenItems((ImmutableMap<String, Function<ItemStack, ItemStack>>)ImmutableMap.of((Object)id, i -> ItemStack.f_41583_));
    }

    public GTToolType(String domain, String id, GTToolType inheritType) {
        this(domain, id, inheritType.useDurability, inheritType.attackDurability, inheritType.craftingDurability, inheritType.baseAttackDamage, inheritType.baseAttackSpeed, false);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public List<IGTTool> instantiatePoweredTools(String domain) {
        Item.Properties properties = this.prepareInstantiation(domain);
        return this.instantiatePoweredTools(domain, () -> properties);
    }

    public List<IGTTool> instantiatePoweredTools(String domain, Supplier<Item.Properties> properties) {
        ObjectArrayList poweredTools = new ObjectArrayList();
        for (int energyTier : this.energyTiers) {
            poweredTools.add(this.instantiatePoweredTool(domain, GTItemTier.NULL, properties, energyTier));
        }
        return poweredTools;
    }

    public List<IGTTool> instantiateTools(String domain) {
        return this.instantiateTools(domain, () -> this.prepareInstantiation(domain));
    }

    protected IGTTool instantiatePoweredTool(String domain, GTItemTier tier, Supplier<Item.Properties> properties, int energyTier) {
        if (this.toolSupplier != null) {
            return this.toolSupplier.create(domain, this, tier, properties.get(), energyTier);
        }
        if (this.toolClass == MaterialSword.class) {
            return new MaterialSword(domain, this, tier, properties.get(), energyTier);
        }
        return new MaterialTool(domain, this, tier, properties.get(), energyTier);
    }

    protected IGTTool instantiateTool(String domain, GTItemTier tier, Supplier<Item.Properties> properties) {
        if (this.toolSupplier != null) {
            return this.toolSupplier.create(domain, this, tier, properties.get());
        }
        if (this.toolClass == MaterialSword.class) {
            return new MaterialSword(domain, this, tier, properties.get());
        }
        return new MaterialTool(domain, this, tier, properties.get());
    }

    public List<IGTTool> instantiateTools(String domain, Supplier<Item.Properties> properties) {
        ArrayList<IGTTool> tools = new ArrayList<IGTTool>();
        if (this.simple) {
            MaterialTags.TOOLS.getAll().forEach((m, t) -> {
                if (this.primaryMaterialRequirement != null && !m.has(this.primaryMaterialRequirement)) {
                    return;
                }
                if (this.replacements.containsKey(m.getId())) {
                    return;
                }
                if (t.toolTypes().contains(this)) {
                    tools.add(this.instantiateTool(domain, GTItemTier.getOrCreate(m, this.hasSecondary ? t.handleMaterial() : Material.NULL), properties));
                }
            });
        } else {
            tools.add(this.instantiateTool(domain, GTItemTier.NULL, properties));
        }
        return tools;
    }

    protected Item.Properties prepareInstantiation(String domain) {
        if (domain.isEmpty()) {
            Utils.onInvalidData("An GTToolType was instantiated with an empty domain name!");
        }
        Item.Properties properties = new Item.Properties();
        if (!this.repairable) {
            properties.setNoRepair();
        }
        return properties;
    }

    public GTToolType addReplacement(Material material, Supplier<Item> item) {
        this.replacements.put(material.getId(), item);
        return this;
    }

    public GTToolType setToolTip(Component ... tooltip) {
        this.tooltip.addAll(Arrays.asList(tooltip));
        return this;
    }

    public GTToolType setTag(GTToolType tag) {
        this.originalTag = false;
        this.tag = tag.getTag();
        this.forgeTag = tag.getForgeTag();
        return this;
    }

    public GTToolType setType(GTToolType tag) {
        this.toolTypes.remove(this.toolType);
        this.toolType = tag.getToolType();
        this.toolTypes.add(this.toolType);
        return this;
    }

    public GTToolType setTag(ResourceLocation loc) {
        this.originalTag = false;
        this.tag = TagUtils.getItemTag(loc);
        this.forgeTag = TagUtils.getForgelikeItemTag("tools/" + loc.m_135815_());
        return this;
    }

    public GTToolType setPowered(long baseMaxEnergy, int ... energyTiers) {
        this.powered = true;
        this.baseMaxEnergy = baseMaxEnergy;
        this.energyTiers = energyTiers;
        this.simple = false;
        return this;
    }

    public GTToolType addTags(String ... types) {
        if (types.length == 0) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " GTToolType was set to have no additional tool types even when it was explicitly called!");
        }
        Arrays.stream(types).map(t -> {
            String domain = t.equals("pickaxe") || t.equals("axe") || t.equals("shovel") || t.equals("hoe") || t.equals("sword") ? "minecraft" : "gtlib";
            return TagUtils.getBlockTag(new ResourceLocation(domain, "mineable/" + t));
        }).forEach(t -> this.toolTypes.add((TagKey<Block>)t));
        return this;
    }

    public GTToolType addEffectiveBlocks(Block ... blocks) {
        if (blocks.length == 0) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " GTToolType was set to have no effective blocks even when it was explicitly called!");
        }
        this.effectiveBlocks.addAll(Arrays.asList(blocks));
        return this;
    }

    @SafeVarargs
    public final GTToolType addEffectiveBlockTags(TagKey<Block> ... blocks) {
        if (blocks.length == 0) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " GTToolType was set to have no effective block tags even when it was explicitly called!");
        }
        this.effectiveBlockTags.addAll(Arrays.asList(blocks));
        return this;
    }

    public GTToolType addBlacklistedEnchantments(Enchantment ... enchantments) {
        this.blacklistedEnchantments.addAll(Arrays.asList(enchantments));
        return this;
    }

    public GTToolType setPrimaryRequirement(IMaterialTag tag) {
        if (tag == null) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " GTToolType was set to have no primary material requirement even when it was explicitly called!");
        }
        this.primaryMaterialRequirement = tag;
        return this;
    }

    public GTToolType setSecondaryRequirement(IMaterialTag tag) {
        if (tag == null) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " GTToolType was set to have no secondary material requirement even when it was explicitly called!");
        }
        this.secondaryMaterialRequirement = tag;
        return this;
    }

    public boolean getBlockBreakability() {
        return this.blockBreakability;
    }

    public GTToolType setBlockBreakability(boolean breakable) {
        this.blockBreakability = breakable;
        return this;
    }

    public GTToolType setBaseQuality(int quality) {
        if (quality < 0) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " GTToolType was set to have negative Base Quality!");
        }
        this.baseQuality = quality;
        return this;
    }

    public GTToolType setToolSpeedMultiplier(float multiplier) {
        if (multiplier < 0.0f) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " GTToolType was set to have negative Speed Multiplier!");
        }
        this.miningSpeedMultiplier = multiplier;
        return this;
    }

    public GTToolType setOverlayLayers(int layers) {
        if (layers < 0) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " GTToolType was set to have less than 0 overlayer layers!");
        }
        this.overlayLayers = layers;
        return this;
    }

    public void addBehaviour(IBehaviour<IBasicGTTool> ... behaviours) {
        Arrays.stream(behaviours).forEach(b -> this.behaviours.put((Object)b.getId(), b));
    }

    public IBehaviour<IBasicGTTool> getBehaviour(String id) {
        return (IBehaviour)this.behaviours.get((Object)id);
    }

    public void removeBehaviour(String ... ids) {
        Arrays.stream(ids).forEach(arg_0 -> this.behaviours.remove(arg_0));
    }

    public ItemStack getToolStack(Material primary, Material secondary) {
        String id = this.simple ? primary.getId() + "_" + this.id : this.id;
        return Objects.requireNonNull(GTAPI.get(IGTTool.class, id, this.domain)).asItemStack(primary, secondary);
    }

    public ItemStack getToolStack(Material primary) {
        if (this.simple && this.replacements.containsKey(primary.getId())) {
            ItemStack stack = new ItemStack((ItemLike)this.replacements.get(primary.getId()).get());
            if (!primary.has(MaterialTags.TOOLS)) {
                return stack;
            }
            ImmutableMap<Enchantment, Integer> mainEnchants = MaterialTags.TOOLS.get(primary).toolEnchantment();
            if (!mainEnchants.isEmpty()) {
                mainEnchants.entrySet().stream().filter(e -> ((Enchantment)e.getKey()).m_6081_(stack)).forEach(e -> stack.m_41663_((Enchantment)e.getKey(), ((Integer)e.getValue()).intValue()));
            }
            return stack;
        }
        String id = this.simple ? primary.getId() + "_" + this.id : this.id;
        return Objects.requireNonNull(GTAPI.get(IGTTool.class, id, this.domain)).asItemStack(primary, Material.NULL);
    }

    public Item getToolItem(Material material) {
        if (this.simple && this.replacements.containsKey(material.getId())) {
            return this.replacements.get(material.getId()).get();
        }
        String id = this.simple ? material.getId() + "_" + this.id : this.id;
        return Objects.requireNonNull(GTAPI.get(IGTTool.class, id, this.domain)).getItem();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean hasContainer() {
        return this.hasContainer;
    }

    public boolean hasOriginalTag() {
        return this.originalTag;
    }

    @Generated
    public TagKey<Block> getToolType() {
        return this.toolType;
    }

    @Generated
    public Set<TagKey<Block>> getToolTypes() {
        return this.toolTypes;
    }

    @Generated
    public Set<Block> getEffectiveBlocks() {
        return this.effectiveBlocks;
    }

    @Generated
    public Set<TagKey<Block>> getEffectiveBlockTags() {
        return this.effectiveBlockTags;
    }

    @Generated
    public Object2ObjectMap<String, IBehaviour<IBasicGTTool>> getBehaviours() {
        return this.behaviours;
    }

    @Generated
    public ImmutableMap<String, Function<ItemStack, ItemStack>> getBrokenItems() {
        return this.brokenItems;
    }

    @Generated
    public GTToolType setBrokenItems(ImmutableMap<String, Function<ItemStack, ItemStack>> brokenItems) {
        this.brokenItems = brokenItems;
        return this;
    }

    @Generated
    public Map<String, Supplier<Item>> getReplacements() {
        return this.replacements;
    }

    @Generated
    public Set<Enchantment> getBlacklistedEnchantments() {
        return this.blacklistedEnchantments;
    }

    @Generated
    public GTToolType setBlacklistedEnchantments(Set<Enchantment> blacklistedEnchantments) {
        this.blacklistedEnchantments = blacklistedEnchantments;
        return this;
    }

    @Generated
    public List<Component> getTooltip() {
        return this.tooltip;
    }

    @Generated
    public boolean isPowered() {
        return this.powered;
    }

    @Generated
    public boolean isHasContainer() {
        return this.hasContainer;
    }

    @Generated
    public boolean isHasSecondary() {
        return this.hasSecondary;
    }

    @Generated
    public boolean isSimple() {
        return this.simple;
    }

    @Generated
    public boolean isRepairable() {
        return this.repairable;
    }

    @Generated
    public GTToolType setHasContainer(boolean hasContainer) {
        this.hasContainer = hasContainer;
        return this;
    }

    @Generated
    public GTToolType setHasSecondary(boolean hasSecondary) {
        this.hasSecondary = hasSecondary;
        return this;
    }

    @Generated
    public GTToolType setSimple(boolean simple) {
        this.simple = simple;
        return this;
    }

    @Generated
    public GTToolType setRepairable(boolean repairable) {
        this.repairable = repairable;
        return this;
    }

    @Generated
    public boolean isOriginalTag() {
        return this.originalTag;
    }

    @Generated
    public GTToolType setOriginalTag(boolean originalTag) {
        this.originalTag = originalTag;
        return this;
    }

    @Generated
    public long getBaseMaxEnergy() {
        return this.baseMaxEnergy;
    }

    @Generated
    public int[] getEnergyTiers() {
        return this.energyTiers;
    }

    @Generated
    public int getUseDurability() {
        return this.useDurability;
    }

    @Generated
    public int getAttackDurability() {
        return this.attackDurability;
    }

    @Generated
    public int getCraftingDurability() {
        return this.craftingDurability;
    }

    @Generated
    public GTToolType setUseDurability(int useDurability) {
        this.useDurability = useDurability;
        return this;
    }

    @Generated
    public GTToolType setAttackDurability(int attackDurability) {
        this.attackDurability = attackDurability;
        return this;
    }

    @Generated
    public GTToolType setCraftingDurability(int craftingDurability) {
        this.craftingDurability = craftingDurability;
        return this;
    }

    @Generated
    public float getDurabilityMultiplier() {
        return this.durabilityMultiplier;
    }

    @Generated
    public GTToolType setDurabilityMultiplier(float durabilityMultiplier) {
        this.durabilityMultiplier = durabilityMultiplier;
        return this;
    }

    @Generated
    public float getMiningSpeedMultiplier() {
        return this.miningSpeedMultiplier;
    }

    @Generated
    public int getBaseQuality() {
        return this.baseQuality;
    }

    @Generated
    public int getOverlayLayers() {
        return this.overlayLayers;
    }

    @Generated
    public float getBaseAttackDamage() {
        return this.baseAttackDamage;
    }

    @Generated
    public float getBaseAttackSpeed() {
        return this.baseAttackSpeed;
    }

    @Generated
    public GTToolType setBaseAttackDamage(float baseAttackDamage) {
        this.baseAttackDamage = baseAttackDamage;
        return this;
    }

    @Generated
    public GTToolType setBaseAttackSpeed(float baseAttackSpeed) {
        this.baseAttackSpeed = baseAttackSpeed;
        return this;
    }

    @Generated
    public CreativeModeTab getItemGroup() {
        return this.itemGroup;
    }

    @Generated
    public GTToolType setItemGroup(CreativeModeTab itemGroup) {
        this.itemGroup = itemGroup;
        return this;
    }

    @Generated
    public TagKey<Item> getTag() {
        return this.tag;
    }

    @Generated
    public TagKey<Item> getForgeTag() {
        return this.forgeTag;
    }

    @Generated
    public UseAnim getUseAction() {
        return this.useAction;
    }

    @Generated
    public GTToolType setUseAction(UseAnim useAction) {
        this.useAction = useAction;
        return this;
    }

    @Generated
    public GTToolType setToolClass(Class<? extends IGTTool> toolClass) {
        this.toolClass = toolClass;
        return this;
    }

    @Generated
    public GTToolType setToolSupplier(IToolSupplier toolSupplier) {
        this.toolSupplier = toolSupplier;
        return this;
    }

    @Nullable
    @Generated
    public SoundEvent getUseSound() {
        return this.useSound;
    }

    @Generated
    public GTToolType setUseSound(@Nullable SoundEvent useSound) {
        this.useSound = useSound;
        return this;
    }

    @Nullable
    @Generated
    public IMaterialTag getPrimaryMaterialRequirement() {
        return this.primaryMaterialRequirement;
    }

    @Nullable
    @Generated
    public IMaterialTag getSecondaryMaterialRequirement() {
        return this.secondaryMaterialRequirement;
    }

    @Nullable
    @Generated
    public MaterialTypeItem<?> getMaterialTypeItem() {
        return this.materialTypeItem;
    }

    @Generated
    public GTToolType setMaterialTypeItem(@Nullable MaterialTypeItem<?> materialTypeItem) {
        this.materialTypeItem = materialTypeItem;
        return this;
    }

    @Generated
    public Predicate<Material> getMaterialTypeItemPredicate() {
        return this.materialTypeItemPredicate;
    }

    @Generated
    public GTToolType setMaterialTypeItemPredicate(Predicate<Material> materialTypeItemPredicate) {
        this.materialTypeItemPredicate = materialTypeItemPredicate;
        return this;
    }

    @Generated
    public String getCustomName() {
        return this.customName;
    }

    @Generated
    public GTToolType setCustomName(String customName) {
        this.customName = customName;
        return this;
    }

    public static interface IToolSupplier {
        public IGTTool create(String var1, GTToolType var2, GTItemTier var3, Item.Properties var4);

        default public IGTTool create(String domain, GTToolType toolType, GTItemTier tier, Item.Properties properties, int energyTier) {
            return this.create(domain, toolType, tier, properties);
        }
    }
}

