/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.recipe.ingredient;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.recipe.RecipeUtil;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.util.Utils;

public class FluidIngredient {
    private FluidStack[] stacks = new FluidStack[0];
    private TagKey<Fluid> tag;
    private int amount = 0;
    private boolean evaluated = false;
    public static final FluidIngredient EMPTY = new FluidIngredient();

    private FluidIngredient() {
    }

    public boolean matches(FluidStack fluidHolder) {
        List<FluidStack> list = Arrays.stream(this.getStacks()).filter(f -> f.isFluidEqual(fluidHolder)).toList();
        return !list.isEmpty();
    }

    public FluidStack[] getStacks() {
        if (this.evaluated) {
            return this.stacks;
        }
        this.evaluated = true;
        if (this.tag != null) {
            ObjectArrayList list = new ObjectArrayList();
            BuiltInRegistries.f_257020_.m_206058_(this.tag).iterator().forEachRemaining(arg_0 -> this.lambda$getStacks$1((List)list, arg_0));
            this.stacks = list.toArray(new FluidStack[0]);
        }
        return this.stacks;
    }

    public FluidIngredient copy(int amount) {
        FluidIngredient ing = new FluidIngredient();
        ing.stacks = (FluidStack[])Arrays.stream(this.stacks).map(t -> Utils.ca(amount, t)).toArray(FluidStack[]::new);
        ing.evaluated = this.evaluated;
        ing.amount = amount;
        ing.tag = this.tag;
        return ing;
    }

    public void write(FriendlyByteBuf buffer) {
        this.getStacks();
        buffer.m_130130_(this.stacks.length);
        for (FluidStack stack : this.stacks) {
            buffer.writeFluidStack(stack);
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.tag != null) {
            json.addProperty("fluidTag", Boolean.valueOf(true));
            json.addProperty("tag", this.tag.f_203868_().toString());
            json.addProperty("amount", (Number)this.amount);
        } else {
            json = RecipeUtil.fluidstackToJson(this.stacks[0]);
        }
        return json;
    }

    public static FluidIngredient read(FriendlyByteBuf buf) {
        int count = buf.m_130242_();
        FluidStack[] stacks = new FluidStack[count];
        for (int i = 0; i < count; ++i) {
            stacks[i] = buf.readFluidStack();
        }
        FluidIngredient ing = new FluidIngredient();
        int amount = 0;
        for (FluidStack stack : stacks) {
            if (stack.getAmount() <= amount) continue;
            amount = stack.getAmount();
        }
        ing.stacks = stacks;
        ing.evaluated = true;
        ing.amount = amount;
        return ing;
    }

    public static FluidIngredient of(ResourceLocation loc, int amount) {
        Objects.requireNonNull(loc);
        FluidIngredient ing = new FluidIngredient();
        ing.tag = TagUtils.getFluidTag(loc);
        ing.amount = amount;
        return ing;
    }

    public static FluidIngredient of(TagKey<Fluid> tag, int amount) {
        Objects.requireNonNull(tag);
        FluidIngredient ing = new FluidIngredient();
        ing.tag = tag;
        ing.amount = amount;
        return ing;
    }

    public static FluidIngredient of(Material mat, int amount) {
        return FluidIngredient.of(new ResourceLocation("forge", mat.getId()), amount);
    }

    public static FluidIngredient of(FluidStack stack) {
        Objects.requireNonNull(stack);
        FluidIngredient ing = new FluidIngredient();
        ing.stacks = new FluidStack[]{stack};
        ing.amount = stack.getAmount();
        return ing;
    }

    public List<FluidStack> drain(MachineFluidHandler<?> handler, boolean input, boolean simulate) {
        return this.drain(this.amount, handler, input, simulate);
    }

    public List<FluidStack> drain(int amount, MachineFluidHandler<?> handler, boolean input, boolean simulate) {
        int drained = amount;
        ObjectArrayList ret = new ObjectArrayList(1);
        for (FluidStack stack : this.getStacks()) {
            stack = stack.copy();
            stack.setAmount(drained);
            FluidStack drain = input ? handler.drainInput(stack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE) : handler.drain(stack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
            drained -= drain.getAmount();
            if (!drain.isEmpty()) {
                ret.add(drain);
            }
            if (drained == 0) break;
        }
        return ret;
    }

    public List<FluidStack> drain(IFluidHandler handler, boolean simulate) {
        return this.drain(this.amount, handler, simulate);
    }

    public List<FluidStack> drain(int amount, IFluidHandler handler, boolean simulate) {
        int drained = amount;
        ObjectArrayList ret = new ObjectArrayList(1);
        for (FluidStack stack : this.getStacks()) {
            stack = stack.copy();
            stack.setAmount(drained);
            FluidStack drain = handler.drain(stack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
            drained -= drain.getAmount();
            if (!drain.isEmpty()) {
                ret.add(drain);
            }
            if (drained == 0) break;
        }
        return ret;
    }

    public int drainedAmount(int amount, MachineFluidHandler<?> handler, boolean input, boolean simulate) {
        return this.drain(amount, handler, input, simulate).stream().mapToInt(FluidStack::getAmount).sum();
    }

    @Generated
    public TagKey<Fluid> getTag() {
        return this.tag;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    private /* synthetic */ void lambda$getStacks$1(List list, Holder t) {
        if (!((Fluid)t.m_203334_()).m_7444_(((Fluid)t.m_203334_()).m_76145_())) {
            return;
        }
        FluidStack stack = new FluidStack((Fluid)t.m_203334_(), this.getAmount());
        list.add(stack);
    }
}

