/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.pipe;

import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.AABB;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.util.Utils;

public enum PipeSize implements IGTObject
{
    VTINY(1),
    TINY(2),
    SMALL(4),
    NORMAL(8),
    LARGE(12),
    HUGE(16),
    QUADRUPLE(0),
    NONUPLE(0);

    public static final PipeSize[] VALUES;
    private final int cableThickness;
    private final AABB AABB;

    private PipeSize(int cableThickness) {
        this.cableThickness = cableThickness;
        float offset = 0.0625f * (float)this.ordinal();
        this.AABB = cableThickness == 0 ? new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0) : new AABB(0.4375 - (double)offset, 0.4375 - (double)offset, 0.4375 - (double)offset, 0.5625 + (double)offset, 0.5625 + (double)offset, 0.5625 + (double)offset);
    }

    @Override
    public String getId() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public Component getDisplayName() {
        return Utils.translatable("pipe." + this.getId(), new Object[0]);
    }

    public int getCableThickness() {
        return this.cableThickness;
    }

    public AABB getAABB() {
        return this.AABB;
    }

    static {
        VALUES = new PipeSize[]{VTINY, TINY, SMALL, NORMAL, LARGE, HUGE};
    }
}

