/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.client.GTTextureStitcher;
import org.gtreimagined.gtlib.datagen.builder.GTItemModelBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.item.IFluidItem;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class ItemFluidIcon
extends ItemBasic<ItemFluidIcon>
implements IFluidItem {
    private final int capacity;
    private final Fluid stack;
    private static final String TAG_FLUID = "Fluid";

    public ItemFluidIcon() {
        super("gtlib", "fluid_icon");
        GTTextureStitcher.addStitcher(t -> t.accept(new ResourceLocation(this.domain, "item/mask/icon_fluid")));
        this.capacity = 1;
        this.stack = Fluids.f_76191_;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(x -> {
            FluidStack fluid = x.getFluidInTank(0);
            if (fluid.isEmpty()) {
                return;
            }
            tooltip.remove(0);
            ArrayList<Component> str = new ArrayList<Component>();
            str.add(FluidUtils.getFluidDisplayName(fluid));
            str.add((Component)Utils.translatable("gtlib.tooltip.fluid.temp", FluidUtils.getFluidTemperature(fluid.getFluid())).m_130940_(ChatFormatting.RED));
            String liquid = !FluidUtils.isFluidGaseous(fluid.getFluid()) ? "liquid" : "gas";
            str.add((Component)Utils.translatable("gtlib.tooltip.fluid." + liquid, new Object[0]).m_130940_(ChatFormatting.GREEN));
            GTLibXEIPlugin.addModDescriptor(str, fluid);
            tooltip.addAll(str);
        });
    }

    public Fluid getFluid() {
        return this.stack;
    }

    protected boolean hasFluid(ItemStack container) {
        return !this.getFluidStack(container).isEmpty();
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return this.hasFluid(stack);
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return new ItemStack((ItemLike)this);
    }

    @Override
    public Predicate<FluidStack> getFilter() {
        return f -> true;
    }

    @Override
    public void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        ((GTItemModelBuilder)prov.getGTBuilder(item).bucketProperties(this.stack, true, false).parent(new ResourceLocation("gtlib:item/bucket"))).tex(map -> {
            map.put("base", this.getDomain() + ":block/empty");
            map.put("cover", this.getDomain() + ":block/empty");
            map.put("fluid", this.getDomain() + ":item/mask/icon_fluid");
        });
    }

    @Override
    @Generated
    public int getCapacity() {
        return this.capacity;
    }
}

