/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.jei.category;

import com.google.common.collect.Sets;
import java.util.Set;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.integration.jei.category.MultiMachineInfoPage;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MultiMachineInfoCategory
implements IRecipeCategory<MultiMachineInfoPage> {
    private static IGuiHelper guiHelper;
    private final IDrawable background = guiHelper.createBlankDrawable(176, 150);
    private final IDrawable icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Data.DEBUG_SCANNER, 1));
    private static final Set<MultiMachineInfoPage> MULTI_MACHINES_PAGES;
    private static final RecipeType<MultiMachineInfoPage> RECIPE_TYPE;

    public static void setGuiHelper(IGuiHelper guiHelper) {
        MultiMachineInfoCategory.guiHelper = guiHelper;
    }

    public static void addMultiMachine(MultiMachineInfoPage page) {
        MULTI_MACHINES_PAGES.add(page);
    }

    public static void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(RECIPE_TYPE, MULTI_MACHINES_PAGES.stream().toList());
    }

    public void draw(MultiMachineInfoPage recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
    }

    @NotNull
    public Component getTitle() {
        return Utils.literal("Multi Machines Title");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<MultiMachineInfoPage> getRecipeType() {
        return RECIPE_TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, MultiMachineInfoPage recipe, IFocusGroup iFocusGroup) {
    }

    static {
        MULTI_MACHINES_PAGES = Sets.newHashSet();
        RECIPE_TYPE = RecipeType.create((String)"gt", (String)"multi_machine_info", MultiMachineInfoPage.class);
    }
}

