/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.IFuelMachine;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.Widget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FuelWidget
extends Widget {
    private int fuel = 0;
    private int maxFuel = 0;
    final ResourceLocation base;
    final ResourceLocation overlay;

    protected FuelWidget(@NotNull GuiInstance gui, @Nullable IGuiElement parent, ResourceLocation base, ResourceLocation overlay) {
        super(gui, parent);
        this.base = base;
        this.overlay = overlay;
    }

    public static WidgetSupplier build(ResourceLocation base, ResourceLocation overlay) {
        return FuelWidget.builder((gui1, parent1) -> new FuelWidget((GuiInstance)gui1, (IGuiElement)parent1, base, overlay));
    }

    @Override
    public void init() {
        super.init();
        IGuiHandler iGuiHandler = this.gui.handler;
        if (iGuiHandler instanceof IFuelMachine) {
            IFuelMachine fuelMachine = (IFuelMachine)((Object)iGuiHandler);
            this.gui.syncInt(fuelMachine::getFuel, i -> {
                this.fuel = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(fuelMachine::getMaxFuel, i -> {
                this.maxFuel = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }
    }

    @Override
    public void render(GuiGraphics graphics, double mouseX, double mouseY, float partialTicks) {
        this.drawTexture(graphics, this.base, this.realX(), this.realY(), 0, 0, 18, 18, 18, 18);
        if (this.fuel > 0) {
            int lvl;
            float per = (float)this.fuel / (float)this.maxFuel;
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * 18.0f)) < 0) {
                return;
            }
            int y = this.realY() + 18 - lvl;
            this.drawTexture(graphics, this.overlay, this.realX(), y, 0, 18 - lvl, 18, lvl, 18, 18);
        }
    }

    @Override
    public void mouseOver(GuiGraphics graphics, double mouseX, double mouseY, float partialTicks) {
        super.mouseOver(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, "Show Recipes", mouseX, mouseY, 0, 0, 18, 18);
        this.renderTooltip(graphics, "Fuel: " + this.fuel, mouseX, mouseY + 10.0, 0, 10, 18, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderTooltip(GuiGraphics graphics, String text, double mouseX, double mouseY, int x, int y, int w, int h) {
        if (this.isInside(x, y, w, h, mouseX, mouseY)) {
            this.renderTooltip(graphics, (Component)Utils.literal(text), mouseX, mouseY);
        }
    }

    @Override
    public boolean isInside(int x, int y, int w, int h, double mouseX, double mouseY) {
        int realX = this.realX() + x;
        int realY = this.realY() + y;
        return mouseX >= (double)realX && mouseX <= (double)(realX + w) && mouseY >= (double)realY && mouseY <= (double)(realY + h);
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        IGuiHandler iGuiHandler = this.gui.handler;
        if (iGuiHandler instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)iGuiHandler;
            GTLibXEIPlugin.showCategory(machine.getMachineType(), machine.getMachineTier());
        }
    }
}

