/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.container;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import lombok.Generated;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.capability.item.TrackedItemHandler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.container.IGTContainer;
import org.gtreimagined.gtlib.gui.slot.AbstractSlot;
import org.gtreimagined.gtlib.gui.slot.IClickableSlot;
import org.gtreimagined.gtlib.gui.slot.SlotFake;

public abstract class GTContainer
extends AbstractContainerMenu
implements IGTContainer {
    protected Inventory playerInv;
    protected int invSize;
    public final GuiInstance handler;
    public final Set<ServerPlayer> listeners = new ObjectOpenHashSet();
    public final NonNullList<Slot> playerSlots = NonNullList.m_122779_();
    private final MenuType<?> containerType;

    public GTContainer(IGuiHandler handler, MenuType<?> containerType, int windowId, Inventory playerInv, int invSize) {
        super(containerType, windowId);
        this.playerInv = playerInv;
        this.invSize = invSize;
        this.handler = new GuiInstance(handler, this, handler.isRemote());
        this.containerType = containerType;
    }

    @Override
    public Set<ServerPlayer> listeners() {
        return this.listeners;
    }

    protected void addPlayerSlots() {
        if (this.playerInv == null) {
            return;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                Slot slot = new Slot((Container)this.playerInv, x + y * 9 + 9, this.getXPlayerOffset() + 8 + x * 18, this.getYPlayerOffset() + 84 + y * 18);
                this.m_38897_(slot);
                this.playerSlots.add((Object)slot);
            }
        }
        for (int x = 0; x < 9; ++x) {
            Slot slot = new Slot((Container)this.playerInv, x, this.getXPlayerOffset() + 8 + x * 18, this.getYPlayerOffset() + 142);
            this.m_38897_(slot);
            this.playerSlots.add((Object)slot);
        }
    }

    protected int getXPlayerOffset() {
        return 0;
    }

    protected int getYPlayerOffset() {
        return 0;
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.listeners().size() == 0) {
            return;
        }
        this.source().update();
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 0 && this.m_38853_(slotId) instanceof IClickableSlot) {
            try {
                ((IClickableSlot)this.m_38853_(slotId)).clickSlot(dragType, clickTypeIn, player, this);
                return;
            }
            catch (Exception exception) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)exception, (String)"Container click");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Click info");
                crashreportcategory.m_128165_("Menu Type", () -> this.containerType != null ? ForgeRegistries.MENU_TYPES.getKey(this.containerType).toString() : "<no type>");
                crashreportcategory.m_128165_("Menu Class", () -> this.getClass().getCanonicalName());
                crashreportcategory.m_128159_("Slot Count", (Object)this.f_38839_.size());
                crashreportcategory.m_128159_("Slot", (Object)slotId);
                crashreportcategory.m_128159_("Button", (Object)dragType);
                crashreportcategory.m_128159_("Type", (Object)clickTypeIn);
                throw new ReportedException(crashreport);
            }
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index < this.invSize ? !this.m_38903_(slotStack, this.invSize, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.invSize, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean continueLoop;
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && !(reverseDirection ? i < startIndex : i >= endIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                continueLoop = false;
                if (slot instanceof SlotFake || !slot.m_5857_(stack)) {
                    continueLoop = true;
                }
                ItemStack itemstack = slot.m_7993_();
                if (!continueLoop && !itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + stack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_6641_(), stack.m_41741_()))) {
                        AbstractSlot abstractSlot;
                        IItemHandler handle;
                        stack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        if (slot instanceof AbstractSlot && (handle = (abstractSlot = (AbstractSlot)slot).getContainer()) instanceof TrackedItemHandler) {
                            TrackedItemHandler trackedItemHandler = (TrackedItemHandler)handle;
                            trackedItemHandler.onContentsChanged(slot.f_40219_);
                        }
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        stack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(reverseDirection ? i < startIndex : i >= endIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                continueLoop = false;
                if (slot1 instanceof SlotFake) {
                    continueLoop = true;
                }
                ItemStack itemstack1 = slot1.m_7993_();
                if (!continueLoop && itemstack1.m_41619_() && slot1.m_5857_(stack)) {
                    if (stack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_5852_(stack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_5852_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    @Override
    public GuiInstance source() {
        return this.handler;
    }

    @Generated
    public Inventory getPlayerInv() {
        return this.playerInv;
    }
}

