/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.fluid;

import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.fluid.GTClientFluidTypeExtension;
import org.gtreimagined.gtlib.registration.IRegistryEntryProvider;
import org.gtreimagined.gtlib.registration.ISharedGTObject;

public class GTFluid
implements ISharedGTObject,
IRegistryEntryProvider {
    public static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("block/water_overlay");
    public static final ResourceLocation LIQUID_STILL_TEXTURE = new ResourceLocation("gtlib", "block/liquid/still");
    public static final ResourceLocation LIQUID_FLOW_TEXTURE = new ResourceLocation("gtlib", "block/liquid/flow");
    public static final ResourceLocation LIQUID_HOT_STILL_TEXTURE = new ResourceLocation("gtlib", "block/liquid/hot_still");
    public static final ResourceLocation LIQUID_HOT_FLOW_TEXTURE = new ResourceLocation("gtlib", "block/liquid/hot_flow");
    public static final ResourceLocation GAS_TEXTURE = new ResourceLocation("gtlib", "block/liquid/gas");
    public static final ResourceLocation GAS_FLOW_TEXTURE = new ResourceLocation("gtlib", "block/liquid/gas");
    public static final ResourceLocation PLASMA_TEXTURE = new ResourceLocation("gtlib", "block/liquid/plasma");
    public static final ResourceLocation PLASMA_FLOW_TEXTURE = new ResourceLocation("gtlib", "block/liquid/plasma");
    private final String domain;
    private final String id;
    protected ForgeFlowingFluid.Properties fluidProperties;
    protected ForgeFlowingFluid.Source source;
    protected ForgeFlowingFluid.Flowing flowing;
    protected BlockBehaviour.Properties blockProperties;
    protected FluidType fluidType;
    protected IClientFluidTypeExtensions extension;
    protected LiquidBlock fluidBlock;
    protected Item containerItem = Items.f_41852_;

    public GTFluid(String domain, String id, FluidType.Properties builder, BlockBehaviour.Properties blockProperties, IClientFluidTypeExtensions typeExtensions) {
        this.domain = domain;
        this.id = id;
        this.fluidProperties = new ForgeFlowingFluid.Properties(this::getFluidType, this::getFluid, this::getFlowingFluid).bucket(this::getContainerItem).block(this::getFluidBlock);
        this.blockProperties = blockProperties;
        this.extension = typeExtensions;
        this.fluidType = new FluidType(builder){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(GTFluid.this.extension);
            }
        };
    }

    public GTFluid(String domain, String id) {
        this(domain, id, GTFluid.getDefaultFluidTypeProperties(false), GTFluid.getDefaultBlockProperties(), GTFluid.getDefaultFluidTypeClientExtension(false));
    }

    public GTFluid(String domain, String id, FluidType.Properties builder) {
        this(domain, id, builder, GTFluid.getDefaultBlockProperties(), GTFluid.getDefaultFluidTypeClientExtension(false));
    }

    public GTFluid(String domain, String id, ResourceLocation stillLoc, ResourceLocation flowLoc) {
        this(domain, id, GTFluid.getDefaultFluidTypeProperties(false), GTFluid.getDefaultBlockProperties(), GTClientFluidTypeExtension.builder().stillTexture(stillLoc).flowingTexture(flowLoc).build());
    }

    public GTFluid(String domain, String id, BlockBehaviour.Properties properties) {
        this(domain, id, GTFluid.getDefaultFluidTypeProperties(false), properties, GTFluid.getDefaultFluidTypeClientExtension(false));
    }

    @Override
    public void onRegistryBuild(ResourceKey<? extends Registry<?>> registry) {
        if (registry == ForgeRegistries.Keys.ITEMS) {
            this.containerItem = new BucketItem(this::getFluid, new Item.Properties().m_41487_(1).m_41495_(Items.f_42446_));
            GTAPI.register(Item.class, this.getId() + "_bucket", this.getDomain(), this.containerItem);
        } else if (registry == ForgeRegistries.Keys.BLOCKS) {
            this.fluidBlock = new LiquidBlock(this::getFluid, this.blockProperties);
            GTAPI.register(Block.class, "block_fluid_".concat(this.getId()), this.getDomain(), this.fluidBlock);
        } else if (registry == ForgeRegistries.Keys.FLUIDS) {
            this.source = new ForgeFlowingFluid.Source(this.fluidProperties);
            this.flowing = new ForgeFlowingFluid.Flowing(this.fluidProperties);
            GTAPI.register(Fluid.class, this.getId(), this.getDomain(), this.source);
            GTAPI.register(Fluid.class, "flowing_" + this.getId(), this.getDomain(), this.flowing);
            GTAPI.register(FlowingFluid.class, "flowing_".concat(this.getId()), this.getDomain(), this.flowing);
        } else if (registry == ForgeRegistries.Keys.FLUID_TYPES) {
            GTAPI.register(FluidType.class, this.getId(), this.getDomain(), this.fluidType);
        }
    }

    public GTFluid source(ForgeFlowingFluid.Source source) {
        this.source = source;
        return this;
    }

    public GTFluid flowing(ForgeFlowingFluid.Flowing flowing) {
        this.flowing = flowing;
        return this;
    }

    public GTFluid flowingBlock(LiquidBlock fluidBlock) {
        this.fluidBlock = fluidBlock;
        return this;
    }

    public GTFluid containerItem(Item item) {
        this.containerItem = item;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ForgeFlowingFluid.Source getFluid() {
        return this.source;
    }

    public ForgeFlowingFluid.Flowing getFlowingFluid() {
        return this.flowing;
    }

    protected static BlockBehaviour.Properties getDefaultBlockProperties() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_280170_().m_278166_(PushReaction.DESTROY).m_278788_().m_60978_(100.0f).m_222994_();
    }

    protected static FluidType.Properties getDefaultFluidTypeProperties(boolean hot) {
        if (hot) {
            return FluidType.Properties.create().sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11783_);
        }
        return FluidType.Properties.create().sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_);
    }

    protected static GTClientFluidTypeExtension getDefaultFluidTypeClientExtension(boolean hot) {
        if (hot) {
            return GTClientFluidTypeExtension.builder().stillTexture(LIQUID_HOT_STILL_TEXTURE).flowingTexture(LIQUID_HOT_FLOW_TEXTURE).overlayTexture(OVERLAY_TEXTURE).build();
        }
        return GTClientFluidTypeExtension.builder().stillTexture(LIQUID_STILL_TEXTURE).flowingTexture(LIQUID_FLOW_TEXTURE).overlayTexture(OVERLAY_TEXTURE).build();
    }

    @Generated
    public BlockBehaviour.Properties getBlockProperties() {
        return this.blockProperties;
    }

    @Generated
    public FluidType getFluidType() {
        return this.fluidType;
    }

    @Generated
    public IClientFluidTypeExtensions getExtension() {
        return this.extension;
    }

    @Generated
    public LiquidBlock getFluidBlock() {
        return this.fluidBlock;
    }

    @Generated
    public Item getContainerItem() {
        return this.containerItem;
    }
}

