/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.providers;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.block.BlockFrame;
import org.gtreimagined.gtlib.block.BlockStone;
import org.gtreimagined.gtlib.block.BlockStorage;
import org.gtreimagined.gtlib.data.ForgeTags;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTLibTags;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.IGTLibProvider;
import org.gtreimagined.gtlib.datagen.builder.GTTagBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTBlockTagProvider;
import org.gtreimagined.gtlib.datagen.providers.GTTagProvider;
import org.gtreimagined.gtlib.item.ItemFluidCell;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialItem;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.material.SubTag;
import org.gtreimagined.gtlib.ore.BlockOre;
import org.gtreimagined.gtlib.ore.BlockOreStone;
import org.gtreimagined.gtlib.ore.CobbleStoneType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.Cable;
import org.gtreimagined.gtlib.pipe.types.Wire;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.util.Utils;

public class GTItemTagProvider
extends GTTagProvider<Item>
implements IGTLibProvider {
    private final boolean replace;
    private final Function<TagKey<Block>, GTTagBuilder<Block>> blockTags;

    public GTItemTagProvider(String providerDomain, String providerName, boolean replace, GTBlockTagProvider p) {
        super(Registries.f_256913_, providerDomain, providerName, "items", i -> (ResourceKey)BuiltInRegistries.f_257033_.m_7854_(i).get());
        Objects.requireNonNull(p);
        this.blockTags = p::getOrCreateRawBuilder;
        this.replace = replace;
    }

    private void gtLibTags() {
        this.tag(TagUtils.getForgelikeItemTag("pistons")).add((Item[])new Item[]{Items.f_41869_, Items.f_41862_});
        this.tag(ForgeTags.GEMS_QUARTZ_ALL).addTag(GTMaterialTypes.GEM.getMaterialTag(GTLibMaterials.Quartz));
        this.tag(TagUtils.getForgelikeItemTag("stone")).add(Items.f_42051_);
    }

    @Override
    protected void processTags(String domain) {
        if (domain.equals("gtlib")) {
            this.gtLibTags();
        }
        TagKey blockTag = GTMaterialTypes.BLOCK.getTag();
        TagKey frameTag = GTMaterialTypes.FRAME.getTag();
        this.copy(TagUtils.getForgelikeBlockTag("ores"), TagUtils.getForgelikeItemTag("ores"));
        this.copy(TagUtils.getForgelikeBlockTag("stone"), TagUtils.getForgelikeItemTag("stone"));
        this.copy(TagUtils.getForgelikeBlockTag("storage_blocks"), TagUtils.getForgelikeItemTag("storage_blocks"));
        this.copy(blockTag, TagUtils.blockToItemTag(blockTag));
        this.copy(frameTag, TagUtils.blockToItemTag(frameTag));
        if (domain.equals("gtlib")) {
            GTAPI.all(BlockOre.class, o -> {
                this.tag(TagUtils.getForgelikeItemTag(String.join((CharSequence)"", Utils.getConventionalStoneType(o.getStoneType()), "_", Utils.getConventionalMaterialType(o.getOreType()), "/", o.getMaterial().getId()))).add(o.m_5456_());
                this.tag(TagUtils.getForgelikeItemTag(String.join((CharSequence)"", Utils.getConventionalMaterialType(o.getOreType()), "/", o.getMaterial().getId()))).add(o.m_5456_());
                this.tag(TagUtils.getForgelikeItemTag(Utils.getConventionalMaterialType(o.getOreType()))).add(o.m_5456_());
                this.tag(TagUtils.getForgelikeItemTag(Utils.getConventionalStoneType(o.getStoneType()) + "_" + Utils.getConventionalMaterialType(o.getOreType()))).add(o.m_5456_());
            });
            GTAPI.all(BlockStone.class, s -> {
                String id = "blocks/".concat(s.getId());
                if (s.getSuffix().isEmpty()) {
                    this.tag(TagUtils.getForgelikeItemTag("stone")).add(s.m_5456_());
                } else if (s.getSuffix().equals("cobble")) {
                    this.tag(TagUtils.getForgelikeItemTag("cobblestone")).add(s.m_5456_());
                } else if (s.getSuffix().contains("bricks")) {
                    this.tag(ItemTags.f_13169_).add(s.m_5456_());
                }
                this.copy(TagUtils.getBlockTag(new ResourceLocation("gtlib", id)), TagUtils.getItemTag(new ResourceLocation("gtlib", id)));
            });
            GTAPI.all(StoneType.class, s -> {
                if (s instanceof CobbleStoneType) {
                    CobbleStoneType c = (CobbleStoneType)s;
                    this.tag(ItemTags.f_13165_).add(c.getBlock("cobble").m_5456_());
                    this.tag(ItemTags.f_13166_).add(c.getBlock("cobble").m_5456_());
                }
            });
            GTAPI.all(BlockOreStone.class, domain, s -> {
                String id = "ore_stones/" + s.getMaterial().getId();
                this.copy(TagUtils.getBlockTag(new ResourceLocation(domain, id)), TagUtils.getItemTag(new ResourceLocation(domain, id)));
            });
            GTAPI.all(BlockStorage.class, storage -> {
                MaterialType<?> type = storage.getType();
                String name = String.join((CharSequence)"", type.getTagPrefix(), "/", type == GTMaterialTypes.RAW_ORE_BLOCK ? "raw_" : "", storage.getMaterial().getId());
                this.copy(TagUtils.getForgelikeBlockTag(name), TagUtils.getForgelikeItemTag(name));
            });
            GTAPI.all(BlockFrame.class, storage -> {
                MaterialType<?> type = storage.getType();
                String name = String.join((CharSequence)"", type.getTagPrefix(), "/", storage.getMaterial().getId());
                this.copy(TagUtils.getForgelikeBlockTag(name), TagUtils.getForgelikeItemTag(name));
            });
            GTAPI.all(MaterialItem.class, item -> {
                TagKey<?> type = item.getType().getTag();
                GTTagBuilder<?> provider = this.tag(type);
                provider.add(item).replace(this.replace);
                this.tag(item.getTag()).add((Item)item).replace(this.replace);
                if (item.getType() == GTMaterialTypes.PLATE && item.getMaterial().has(MaterialTags.RUBBERTOOLS) && item.getMaterial().has(MaterialTags.TOOLS)) {
                    this.tag(GTLibTags.PLATE_PLUNGER).add((Item)item);
                }
            });
            GTAPI.all(MaterialType.class, t -> {
                t.getReplacements().forEach((m, i) -> {
                    this.tag(t.getMaterialTag((Material)m)).add((Item)((Supplier)i).get()).replace(this.replace);
                    this.tag(t.getTag()).add(((Supplier)i).get()).replace(this.replace);
                });
                if (t instanceof MaterialTypeBlock) {
                    MaterialTypeBlock block = (MaterialTypeBlock)t;
                    block.getOreReplacements().forEach((m, map) -> map.forEach((s, i) -> {
                        this.tag(block.getMaterialTag((Material)m, (StoneType)s)).add((Item)i.get());
                        this.tag(TagUtils.getForgelikeItemTag(String.join((CharSequence)"", Utils.getConventionalStoneType(s), "_", Utils.getConventionalMaterialType(t)))).add((Item)i.get());
                    }));
                }
            });
            this.tag(Tags.Items.SHEARS).addTag(GTTools.SCISSORS.getTag());
            this.processSubtags();
            GTAPI.all(IGTTool.class, tool -> {
                this.tag(tool.getGTToolType().getTag()).add(tool.getItem()).replace(this.replace);
                this.tag(tool.getGTToolType().getForgeTag()).add(tool.getItem()).replace(this.replace);
            });
        }
        this.copy(TagUtils.getBlockTag(new ResourceLocation("gtlib", "item_pipe")), TagUtils.getItemTag(new ResourceLocation("gtlib", "item_pipe")));
        this.tag(ItemFluidCell.getTag()).add((Item[])GTAPI.all(ItemFluidCell.class, domain).toArray(new Item[0]));
    }

    protected void processSubtags() {
        for (PipeSize value : PipeSize.VALUES) {
            Set<Material> mats = MaterialTags.WIRE.allSub(SubTag.COPPER_WIRE);
            if (mats.size() > 0) {
                this.tag(TagUtils.getItemTag(new ResourceLocation("gtlib", SubTag.COPPER_WIRE.getId() + "_" + value.getId()))).add((Item[])((Item[])mats.stream().map(t -> GTAPI.get(Wire.class, "wire_" + t.getId())).filter(Objects::nonNull).map(t -> t.getBlockItem(value)).toArray(Item[]::new)));
            }
            if ((mats = MaterialTags.CABLE.allSub(SubTag.COPPER_CABLE)).size() <= 0) continue;
            this.tag(TagUtils.getItemTag(new ResourceLocation("gtlib", SubTag.COPPER_CABLE.getId() + "_" + value.getId()))).add((Item[])((Item[])mats.stream().map(t -> GTAPI.get(Cable.class, "cable_" + t.getId())).filter(Objects::nonNull).map(t -> t.getBlockItem(value)).toArray(Item[]::new)));
        }
    }

    protected void copy(TagKey<Block> blockTag, TagKey<Item> itemTag) {
        GTTagBuilder<Item> builder = this.getOrCreateRawBuilder(itemTag);
        GTTagBuilder<Block> builder2 = this.blockTags.apply(blockTag);
        Stream stream = builder2.builder.m_215904_().stream();
        Objects.requireNonNull(builder);
        stream.forEach(builder::add);
    }
}

