/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.builder;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.jetbrains.annotations.Nullable;

public class GTShapelessRecipeBuilder {
    private final ItemStack result;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    private String group;

    public GTShapelessRecipeBuilder(ItemStack result) {
        this.result = result;
    }

    public static GTShapelessRecipeBuilder shapeless(ItemLike result) {
        return new GTShapelessRecipeBuilder(new ItemStack(result, 1));
    }

    public static GTShapelessRecipeBuilder shapeless(ItemLike result, int count) {
        return new GTShapelessRecipeBuilder(new ItemStack(result, count));
    }

    public static GTShapelessRecipeBuilder shapeless(ItemStack stack) {
        return new GTShapelessRecipeBuilder(stack);
    }

    public GTShapelessRecipeBuilder requires(TagKey<Item> tagIn) {
        return this.requires(Ingredient.m_204132_(tagIn));
    }

    public GTShapelessRecipeBuilder requires(ItemLike itemIn) {
        return this.requires(itemIn, 1);
    }

    public GTShapelessRecipeBuilder requires(ItemLike itemIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemIn}));
        }
        return this;
    }

    public GTShapelessRecipeBuilder requires(Ingredient ingredientIn) {
        return this.requires(ingredientIn, 1);
    }

    public GTShapelessRecipeBuilder requires(Ingredient ingredientIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredientIn);
        }
        return this;
    }

    public GTShapelessRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterionIn) {
        this.advancementBuilder.m_138386_(name, criterionIn);
        return this;
    }

    public GTShapelessRecipeBuilder group(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumerIn) {
        this.save(consumerIn, RegistryUtils.getIdFromItem(this.result.m_41720_()));
    }

    public void save(Consumer<FinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = RegistryUtils.getIdFromItem(this.result.m_41720_());
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shapeless Recipe " + save + " should remove its 'save' argument");
        }
        this.save(consumerIn, new ResourceLocation(save));
    }

    public void save(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)new RecipeUnlockedTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumerIn.accept(new Result(id, this.result, this.group == null ? "" : this.group, this.ingredients, this.advancementBuilder, new ResourceLocation(id.m_135827_(), "recipes/" + RecipeCategory.BUILDING_BLOCKS.m_247710_() + "/" + id.m_135815_())));
    }

    private void validate(ResourceLocation id) {
        if (this.advancementBuilder.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack result;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advBuilder;
        private final ResourceLocation advId;

        public Result(ResourceLocation id, ItemStack result, String group, List<Ingredient> ingredients, Advancement.Builder advBuilder, ResourceLocation advId) {
            this.id = id;
            this.result = result;
            this.group = group;
            this.ingredients = ingredients;
            this.advBuilder = advBuilder;
            this.advId = advId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)jsonarray);
            JsonObject resultObj = new JsonObject();
            resultObj.addProperty("item", RegistryUtils.getIdFromItem(this.result.m_41720_()).toString());
            if (this.result.m_41613_() > 1) {
                resultObj.addProperty("count", (Number)this.result.m_41613_());
            }
            json.add("result", (JsonElement)resultObj);
            if (this.result.m_41782_()) {
                resultObj.addProperty("nbt", this.result.m_41783_().toString());
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44077_;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advBuilder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advId;
        }
    }
}

