/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gtlib.recipe.container.MirroredShapedRecipe;
import org.gtreimagined.gtlib.recipe.material.MaterialSerializer;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.jetbrains.annotations.Nullable;

public class GTShapedRecipeBuilder {
    private final List<ItemStack> result;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advBuilder = Advancement.Builder.m_138353_();
    private final Int2ObjectOpenHashMap<IntList> materialSlots = new Int2ObjectOpenHashMap();
    private String group;
    private boolean mirrored = false;

    public GTShapedRecipeBuilder(ItemStack result) {
        this.result = Collections.singletonList(result);
    }

    public GTShapedRecipeBuilder(List<ItemStack> result) {
        this.result = result;
    }

    public static GTShapedRecipeBuilder shapedRecipe(ItemLike result) {
        return new GTShapedRecipeBuilder(new ItemStack(result, 1));
    }

    public static GTShapedRecipeBuilder shapedRecipe(List<ItemStack> result) {
        return new GTShapedRecipeBuilder(result);
    }

    public static GTShapedRecipeBuilder shapedRecipe(ItemLike result, int count) {
        return new GTShapedRecipeBuilder(new ItemStack(result, count));
    }

    public static GTShapedRecipeBuilder shapedRecipe(ItemStack result) {
        return new GTShapedRecipeBuilder(result);
    }

    public GTShapedRecipeBuilder key(Character symbol, TagKey<Item> tag) {
        return this.key(symbol, Ingredient.m_204132_(tag));
    }

    public GTShapedRecipeBuilder key(Character symbol, ItemLike item) {
        return this.key(symbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public GTShapedRecipeBuilder key(Character symbol, Ingredient ingredient) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredient);
        return this;
    }

    public GTShapedRecipeBuilder patternLine(String pattern) {
        if (!this.pattern.isEmpty() && pattern.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(pattern);
        return this;
    }

    public GTShapedRecipeBuilder addCriterion(String name, CriterionTriggerInstance criterion) {
        this.advBuilder.m_138386_(name, criterion);
        return this;
    }

    public GTShapedRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public GTShapedRecipeBuilder setMirrored(boolean mirrored) {
        this.mirrored = mirrored;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, RegistryUtils.getIdFromItem(this.result.get(0).m_41720_()));
    }

    public void build(Consumer<FinishedRecipe> consumer, String save) {
        this.build(consumer, new ResourceLocation(save));
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.validate(id);
        this.advBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)new RecipeUnlockedTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(id, this.result.get(0), this.group == null ? "" : this.group, this.pattern, this.key, this.advBuilder, new ResourceLocation(id.m_135827_(), "recipes/" + RecipeCategory.BUILDING_BLOCKS.m_247710_().replace(":", "/") + "/" + id.m_135815_()), this.mirrored));
    }

    public void buildTool(Consumer<FinishedRecipe> consumer, String builder) {
        this.buildTool(consumer, builder, RegistryUtils.getIdFromItem(this.result.get(0).m_41720_()));
    }

    public void buildTool(Consumer<FinishedRecipe> consumer, String builder, String id) {
        this.buildTool(consumer, builder, new ResourceLocation(id));
    }

    public void buildTool(Consumer<FinishedRecipe> consumer, String builder, ResourceLocation id) {
        this.validate(id);
        this.advBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)new RecipeUnlockedTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        String groupId = RecipeCategory.TOOLS.m_247710_();
        consumer.accept(new ToolResult(builder, id, this.result, this.group == null ? "" : this.group, this.pattern, this.key, this.advBuilder, new ResourceLocation(id.m_135827_(), "recipes/" + groupId + "/" + id.m_135815_())));
    }

    private void validate(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        if (this.result.get(0).m_41619_()) {
            throw new IllegalStateException("Resulting ItemStack cannot be empty!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        if (this.pattern.size() == 1 && this.pattern.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + id + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advBuilder.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack result;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Advancement.Builder advBuilder;
        private final ResourceLocation advId;
        private final boolean mirrored;

        public Result(ResourceLocation id, ItemStack result, String group, List<String> pattern, Map<Character, Ingredient> key, Advancement.Builder advBuilder, ResourceLocation advId, boolean mirrored) {
            this.id = id;
            this.result = result;
            this.group = group;
            this.pattern = pattern;
            this.key = key;
            this.advBuilder = advBuilder;
            this.advId = advId;
            this.mirrored = mirrored;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            json.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            json.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", RegistryUtils.getIdFromItem(this.result.m_41720_()).toString());
            if (this.result.m_41613_() > 1) {
                jsonObject.addProperty("count", (Number)this.result.m_41613_());
            }
            json.add("result", (JsonElement)jsonObject);
            if (this.result.m_41782_()) {
                jsonObject.addProperty("nbt", this.result.m_41783_().toString());
            }
            json.addProperty("mirrored", Boolean.valueOf(this.mirrored));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return MirroredShapedRecipe.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advBuilder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advId;
        }
    }

    public static class ToolResult
    extends Result {
        private final String builderId;
        private final List<ItemStack> result;

        public ToolResult(String builderId, ResourceLocation id, List<ItemStack> result, String group, List<String> pattern, Map<Character, Ingredient> key, Advancement.Builder advBuilder, ResourceLocation advId) {
            super(id, result.get(0), group, pattern, key, advBuilder, advId, false);
            this.builderId = builderId;
            this.result = result;
        }

        @Override
        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            json.addProperty("builder", this.builderId);
            JsonArray arr = new JsonArray();
            this.result.forEach(el -> {
                JsonObject resultObj = new JsonObject();
                resultObj.addProperty("item", RegistryUtils.getIdFromItem(el.m_41720_()).toString());
                if (el.m_41613_() > 1) {
                    resultObj.addProperty("count", (Number)el.m_41613_());
                }
                arr.add((JsonElement)resultObj);
            });
            json.add("output", (JsonElement)arr);
        }

        @Override
        public RecipeSerializer<?> m_6637_() {
            return MaterialSerializer.INSTANCE;
        }
    }
}

