/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.builder;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.models.JOverride;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import org.gtreimagined.gtlib.datagen.builder.GTModelBuilder;
import org.gtreimagined.gtlib.datagen.builder.IModelLocation;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.RegistryUtils;

public class GTItemModelBuilder
extends GTModelBuilder<GTItemModelBuilder> {
    protected ResourceLocation loader;

    public GTItemModelBuilder(ResourceLocation outputLocation) {
        super(outputLocation);
    }

    public GTItemModelBuilder property(String property, Object element) {
        this.model.property(property, element);
        return this;
    }

    public GTItemModelBuilder property(String property, String value) {
        this.model.property(property, value);
        return this;
    }

    public GTItemModelBuilder property(String property, boolean value) {
        this.model.property(property, value);
        return this;
    }

    public GTItemModelBuilder bucketLoader() {
        super.loader(new ResourceLocation("forge", "fluid_container"));
        return this;
    }

    public GTItemModelBuilder cell() {
        super.loader(new ResourceLocation("gtlib", "cell"));
        return this;
    }

    public GTItemModelBuilder bucketProperties(Fluid fluid) {
        return this.bucketProperties(fluid, true, FluidUtils.isFluidGaseous(fluid));
    }

    public GTItemModelBuilder bucketProperties(Fluid fluid, boolean tint, boolean islighter) {
        this.property("fluid", RegistryUtils.getIdFromFluid(fluid).toString());
        this.property("flip_gas", islighter);
        this.property("applyTint", tint);
        return this.bucketLoader();
    }

    public GTItemModelBuilder tex(Consumer<Map<String, String>> texer) {
        Object2ObjectArrayMap textureMap = new Object2ObjectArrayMap();
        texer.accept((Map<String, String>)textureMap);
        textureMap.forEach(this::texture);
        return this;
    }

    public GTItemModelBuilder tex(Map<String, Texture> textureMap) {
        textureMap.forEach(this::texture);
        return this;
    }

    public OverrideBuilder override() {
        return new OverrideBuilder();
    }

    public class OverrideBuilder {
        private ResourceLocation model = null;
        private final Map<ResourceLocation, Float> predicates = new LinkedHashMap<ResourceLocation, Float>();

        public OverrideBuilder model(IModelLocation model) {
            this.model = model.getLocation();
            return this;
        }

        public OverrideBuilder model(ResourceLocation model) {
            this.model = model;
            return this;
        }

        public OverrideBuilder predicate(ResourceLocation key, float value) {
            this.predicates.put(key, Float.valueOf(value));
            return this;
        }

        public GTItemModelBuilder end() {
            JCondition condition = new JCondition();
            this.predicates.forEach((k, v) -> condition.parameter(k.toString(), (Number)v));
            GTItemModelBuilder.this.model.addOverride(new JOverride(condition, this.model.toString()));
            return GTItemModelBuilder.this;
        }
    }
}

