/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.cover;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.BlockEntityFakeBlock;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.cover.BaseCover;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.event.MachineEvent;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class CoverOutput
extends BaseCover {
    private boolean ejectItems = false;
    private boolean ejectFluids = false;
    private boolean allowInput = false;
    int processing = 0;

    public CoverOutput(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
        if (source.getTile() instanceof BlockEntityFakeBlock) {
            this.setEjects(true, true);
        }
    }

    @Override
    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverOutput.getBasicDepthModel();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.handler.getTile().m_58904_().f_46443_) {
            return;
        }
        this.manualOutput();
    }

    @Override
    public void onRemove() {
        super.onRemove();
    }

    public void manualOutput() {
        if (this.shouldOutputFluids()) {
            this.processFluidOutput();
        }
        if (this.shouldOutputItems()) {
            this.processItemOutput();
        }
    }

    public boolean shouldOutputItems() {
        return this.ejectItems;
    }

    public boolean shouldOutputFluids() {
        return this.ejectFluids;
    }

    public void setEjects(boolean fluid, boolean item) {
        this.ejectItems = item;
        this.ejectFluids = fluid;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.ejectItems = nbt.m_128471_("ei");
        this.ejectFluids = nbt.m_128471_("ef");
        this.allowInput = nbt.m_128471_("ai");
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128379_("ei", this.ejectItems);
        nbt.m_128379_("ef", this.ejectFluids);
        nbt.m_128379_("ai", this.allowInput);
        return nbt;
    }

    @Override
    public InteractionResult onInteract(Player player, InteractionHand hand, Direction side, @Nullable GTToolType type) {
        if (type != null && type.getTag() == GTTools.SCREWDRIVER.getTag()) {
            this.allowInput = !this.allowInput;
            String suffix = this.allowInput ? "allow" : "no";
            player.m_5661_((Component)Utils.translatable("gtlib.tooltip.cover.output." + suffix + "_input", new Object[0]), false);
            return InteractionResult.SUCCESS;
        }
        return super.onInteract(player, hand, side, type);
    }

    public boolean doesAllowInput() {
        return this.allowInput;
    }

    protected void processItemOutput() {
        BlockEntity adjTile;
        Object t = this.handler.getTile();
        if (t instanceof BlockEntityBase) {
            BlockEntityBase base = (BlockEntityBase)((Object)t);
            adjTile = base.getCachedBlockEntity(this.side);
        } else {
            adjTile = this.handler.getTile().m_58904_().m_7702_(this.handler.getTile().m_58899_().m_121945_(this.side));
        }
        if (adjTile == null) {
            return;
        }
        if (this.processing > 0) {
            return;
        }
        ++this.processing;
        adjTile.getCapability(ForgeCapabilities.ITEM_HANDLER, this.side.m_122424_()).ifPresent(adjHandler -> this.handler.getTile().getCapability(ForgeCapabilities.ITEM_HANDLER, this.side).ifPresent(h -> Utils.transferItems(h, adjHandler, false, i -> {
            Object patt4637$temp = this.handler.getTile();
            if (!(patt4637$temp instanceof BlockEntityMachine)) return true;
            BlockEntityMachine machine = (BlockEntityMachine)patt4637$temp;
            if (machine.itemHandler.map(f -> f.canItemBeAutoOutput((ItemStack)i)).orElse(true) == false) return false;
            return true;
        })));
        --this.processing;
    }

    protected void processFluidOutput() {
        BlockEntity adjTile;
        Object t = this.handler.getTile();
        if (t instanceof BlockEntityBase) {
            BlockEntityBase base = (BlockEntityBase)((Object)t);
            adjTile = base.getCachedBlockEntity(this.side);
        } else {
            adjTile = this.handler.getTile().m_58904_().m_7702_(this.handler.getTile().m_58899_().m_121945_(this.side));
        }
        if (adjTile == null) {
            return;
        }
        if (this.processing > 0) {
            return;
        }
        ++this.processing;
        adjTile.getCapability(ForgeCapabilities.FLUID_HANDLER, this.side.m_122424_()).ifPresent(adjHandler -> this.handler.getTile().getCapability(ForgeCapabilities.FLUID_HANDLER, this.side).ifPresent(h -> this.tryFluidTransfer((IFluidHandler)adjHandler, (IFluidHandler)h, Integer.MAX_VALUE, true)));
        --this.processing;
    }

    public void tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer) {
        for (int i = 0; i < fluidSource.getTanks(); ++i) {
            FluidStack fluid = fluidSource.getFluidInTank(i);
            if (fluid.isEmpty()) continue;
            Object t = this.handler.getTile();
            if (t instanceof BlockEntityMachine) {
                BlockEntityMachine machine = (BlockEntityMachine)t;
                if (machine.fluidHandler.map(f -> !f.canFluidBeAutoOutput(fluid)).orElse(false).booleanValue()) continue;
            }
            FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)fluidSource, (FluidStack)Utils.ca(Math.min(fluid.getAmount(), maxAmount), fluid), (boolean)doTransfer);
        }
    }

    @Override
    public void onGuiEvent(IGuiEvent event, Player player) {
        if (event.getFactory() == GuiEvents.ITEM_EJECT) {
            boolean bl = this.ejectItems = !this.ejectItems;
            if (this.ejectItems) {
                this.processItemOutput();
            }
            Utils.markTileForNBTSync(this.handler.getTile());
        }
        if (event.getFactory() == GuiEvents.FLUID_EJECT) {
            boolean bl = this.ejectFluids = !this.ejectFluids;
            if (this.ejectFluids) {
                this.processFluidOutput();
            }
            Utils.markTileForNBTSync(this.handler.getTile());
        }
    }

    @Override
    public void onMachineEvent(IGuiHandler tile, IMachineEvent event, int ... data) {
        if (event == MachineEvent.ITEMS_OUTPUTTED && this.ejectItems) {
            this.processItemOutput();
        } else if (event == MachineEvent.FLUIDS_OUTPUTTED && this.ejectFluids) {
            this.processFluidOutput();
        }
    }

    @Override
    public <T> boolean blocksInput(Class<T> cap, @Nullable Direction side) {
        return !this.allowInput;
    }
}

