/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client.model.loader;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.client.ModelUtils;
import org.gtreimagined.gtlib.client.model.GTModel;
import org.gtreimagined.gtlib.client.model.loader.GTModelLoader;
import org.jetbrains.annotations.NotNull;

public class DefaultModelLoader
extends GTModelLoader {
    public DefaultModelLoader(ResourceLocation loc) {
        super(loc);
    }

    @NotNull
    public GTModel read(JsonObject json, JsonDeserializationContext context) {
        try {
            UnbakedModel baseModel = json.has("model") && json.get("model").isJsonObject() ? (UnbakedModel)context.deserialize(json.get("model"), BlockModel.class) : ModelUtils.getMissingModel();
            return new GTModel(baseModel, this.buildRotations(json));
        }
        catch (Exception e) {
            return this.onModelLoadingException(e);
        }
    }

    public GTModel onModelLoadingException(Exception e) {
        GTLib.LOGGER.error("ModelLoader Exception for " + this.getLoc().toString());
        e.printStackTrace();
        return new GTModel(ModelUtils.getMissingModel(), new int[0]);
    }
}

