/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client;

import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.TransformationHelper;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.client.baked.CoverBakedModel;
import org.gtreimagined.gtlib.client.baked.IGTBakedModel;
import org.gtreimagined.gtlib.mixin.client.SimpleBakedModel$BuilderAccessor;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ModelUtils {
    private static ModelBakery MODEL_BAKERY;

    public static UnbakedModel getMissingModel() {
        return ModelUtils.getModelBakery().m_119341_((ResourceLocation)new ModelResourceLocation(new ResourceLocation("builtin/missing"), "missing"));
    }

    public static UnbakedModel getModel(ResourceLocation resourceLocation) {
        return ModelUtils.getModelBakery().m_119341_(resourceLocation);
    }

    public static SimpleBakedModel.Builder createSimpleModelBuilder(boolean smoothLighting, boolean sideLit, boolean isShadedInGui, ItemTransforms transforms, ItemOverrides overrides) {
        return SimpleBakedModel$BuilderAccessor.gtlib$create(smoothLighting, sideLit, isShadedInGui, transforms, overrides);
    }

    public static Function<ResourceLocation, UnbakedModel> getDefaultModelGetter() {
        return ModelUtils::getModelOrMissing;
    }

    private static UnbakedModel getModelOrMissing(ResourceLocation location) {
        try {
            return ModelUtils.getModel(location);
        }
        catch (Exception e) {
            return ModelUtils.getMissingModel();
        }
    }

    public static Function<Material, TextureAtlasSprite> getDefaultTextureGetter() {
        return Material::m_119204_;
    }

    public static ModelBakery getModelBakery() {
        return MODEL_BAKERY;
    }

    public static void setModelBakery(ModelBakery modelBakery) {
        MODEL_BAKERY = modelBakery;
    }

    public static List<BakedQuad> getQuadsFromBaked(BakedModel model, BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull BlockAndTintGetter level, @NotNull BlockPos pos) {
        if (model instanceof IGTBakedModel) {
            IGTBakedModel gtBaked = (IGTBakedModel)model;
            return gtBaked.getQuads(state, side, rand, level, pos);
        }
        ModelData data = model.getModelData(level, pos, state, ModelData.EMPTY);
        return model.getQuads(state, side, rand, data, null);
    }

    public static List<BakedQuad> getQuadsFromBakedCover(BakedModel model, BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull BlockAndTintGetter level, @NotNull BlockPos pos, Predicate<Map.Entry<String, BakedModel>> coverPredicate) {
        if (model instanceof CoverBakedModel) {
            CoverBakedModel coverBakedModel = (CoverBakedModel)model;
            return coverBakedModel.getBlockQuads(state, side, rand, level, pos, coverPredicate);
        }
        return ModelUtils.getQuadsFromBaked(model, state, side, rand, level, pos);
    }

    public static BakedModel getBakedFromQuads(BlockModel model, List<BakedQuad> quads, Function<Material, TextureAtlasSprite> getter) {
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(model, ItemOverrides.f_111734_, true).m_119528_(getter.apply(model.m_111480_("particle")));
        quads.forEach(arg_0 -> ((SimpleBakedModel.Builder)builder).m_119526_(arg_0));
        return builder.m_119533_();
    }

    public static BakedModel getBakedFromModel(BlockModel model, ModelBaker bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ResourceLocation loc) {
        List generalQuads = model.m_111449_(bakery, model, getter, transform, loc, true).getQuads(null, null, (RandomSource)Ref.RNG, ModelData.EMPTY, null);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(model, ItemOverrides.f_111734_, true).m_119528_(getter.apply(model.m_111480_("particle")));
        generalQuads.forEach(arg_0 -> ((SimpleBakedModel.Builder)builder).m_119526_(arg_0));
        return builder.m_119533_();
    }

    public static BakedModel getSimpleBakedModel(BakedModel baked) {
        Object2ObjectOpenHashMap faceQuads = new Object2ObjectOpenHashMap();
        Arrays.stream(Ref.DIRS).forEach(arg_0 -> ModelUtils.lambda$getSimpleBakedModel$0((Map)faceQuads, baked, arg_0));
        return new SimpleBakedModel(baked.getQuads(null, null, (RandomSource)Ref.RNG, ModelData.EMPTY, null), (Map)faceQuads, baked.m_7541_(), baked.m_7547_(), baked.m_7539_(), baked.m_6160_(), baked.m_7442_(), baked.m_7343_());
    }

    public static BakedModel getBaked(ResourceLocation loc) {
        return (BakedModel)ModelUtils.getModelBakery().m_119251_().get(loc);
    }

    public static BakedModel getBakedFromState(BlockState state) {
        return Minecraft.m_91087_().m_91304_().m_119422_(BlockModelShaper.m_110895_((BlockState)state));
    }

    public static BakedModel getBakedFromItem(Item item) {
        return Minecraft.m_91087_().m_91291_().m_115103_().m_109393_().m_119422_(new ModelResourceLocation(RegistryUtils.getIdFromItem(item), "inventory"));
    }

    public static TextureAtlasSprite getSprite(ResourceLocation loc) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(loc);
    }

    public static Material getBlockMaterial(ResourceLocation loc) {
        return new Material(InventoryMenu.f_39692_, loc);
    }

    public static List<BakedQuad> trans(List<BakedQuad> quads, Vector3f rotationL, Vector3f rotationR) {
        Quaternionf rotL = rotationL == null ? null : ModelUtils.quatFromXYZ(rotationL, true);
        Quaternionf rotR = rotationR == null ? null : ModelUtils.quatFromXYZ(rotationR, true);
        return ModelUtils.trans(quads, new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), rotL, null, rotR));
    }

    public static Quaternionf quatFromXYZ(Vector3f xyz, boolean degrees) {
        return TransformationHelper.quatFromXYZ((Vector3f)xyz, (boolean)degrees);
    }

    public static List<BakedQuad> trans(List<BakedQuad> quads, Transformation transform) {
        return QuadTransformers.applying((Transformation)transform.blockCenterToCorner()).process(quads);
    }

    public static void setRenderLayer(Block block, RenderType renderType) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderType);
    }

    public static void setRenderLayer(Fluid fluid, RenderType renderType) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)renderType);
    }

    public static void registerProperty(Item item, ResourceLocation location, ClampedItemPropertyFunction function) {
        ItemProperties.register((Item)item, (ResourceLocation)location, (ItemPropertyFunction)function);
    }

    private static /* synthetic */ void lambda$getSimpleBakedModel$0(Map faceQuads, BakedModel baked, Direction d) {
        faceQuads.put(d, baked.getQuads(null, d, (RandomSource)Ref.RNG, ModelData.EMPTY, null));
    }
}

