/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity.single;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.blockentity.single.BlockEntityTransformer;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.widget.InfoRenderWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.renderer.IInfoRenderer;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;

public class BlockEntityDigitalTransformer<T extends BlockEntityDigitalTransformer<T>>
extends BlockEntityTransformer<T>
implements IInfoRenderer<DigitalTransformerWidget> {
    public BlockEntityDigitalTransformer(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 0, v -> 8192L + v * 64L);
    }

    @Override
    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            this.energyHandler.ifPresent(h -> {
                GuiEvents.GuiEvent ev = (GuiEvents.GuiEvent)event;
                int[] data = ev.data;
                boolean shiftHold = data[0] != 0;
                switch (data[1]) {
                    case 0: {
                        this.voltage /= shiftHold ? 512L : 64L;
                        break;
                    }
                    case 1: {
                        this.voltage -= shiftHold ? 512L : 64L;
                        break;
                    }
                    case 2: {
                        this.amperage /= shiftHold ? 512 : 64;
                        break;
                    }
                    case 3: {
                        this.amperage -= shiftHold ? 512 : 64;
                        break;
                    }
                    case 4: {
                        this.voltage /= shiftHold ? 16L : 2L;
                        break;
                    }
                    case 5: {
                        this.voltage -= shiftHold ? 16L : 1L;
                        break;
                    }
                    case 6: {
                        this.amperage /= shiftHold ? 16 : 2;
                        break;
                    }
                    case 7: {
                        this.amperage -= shiftHold ? 16 : 1;
                        break;
                    }
                    case 8: {
                        this.voltage += shiftHold ? 512L : 64L;
                        break;
                    }
                    case 9: {
                        this.voltage *= shiftHold ? 512L : 64L;
                        break;
                    }
                    case 10: {
                        this.amperage += shiftHold ? 512 : 64;
                        break;
                    }
                    case 11: {
                        this.amperage *= shiftHold ? 512 : 64;
                        break;
                    }
                    case 12: {
                        this.voltage += shiftHold ? 16L : 1L;
                        break;
                    }
                    case 13: {
                        this.voltage *= shiftHold ? 16L : 2L;
                        break;
                    }
                    case 14: {
                        this.amperage += shiftHold ? 16 : 1;
                        break;
                    }
                    case 15: {
                        this.amperage *= shiftHold ? 16 : 2;
                    }
                }
                this.amperage = Math.max(this.amperage, 0);
                this.voltage = Math.max(this.voltage, 0L);
                this.setMachineState((long)this.amperage * this.voltage >= 0L ? this.getDefaultMachineState() : MachineState.DISABLED);
                if (this.isDefaultMachineState()) {
                    h.setInputVoltage(this.getMachineTier().getVoltage());
                    h.setOutputVoltage(this.voltage);
                    h.setOutputAmperage(this.amperage);
                    h.setInputAmperage(1L);
                } else {
                    h.setInputVoltage(this.voltage);
                    h.setOutputVoltage(this.getMachineTier().getVoltage());
                    h.setOutputAmperage(1L);
                    h.setInputAmperage(this.amperage);
                }
            });
        }
    }

    @Override
    public int drawInfo(DigitalTransformerWidget widget, GuiGraphics graphics, Font font, int left, int top) {
        graphics.m_280488_(font, "Control Panel", left + 43, top + 21, 0xFAFAFF);
        graphics.m_280488_(font, "VOLT: " + widget.voltage, left + 43, top + 40, 0xFAFAFF);
        graphics.m_280488_(font, "TIER: " + Tier.getTier(widget.voltage < 0L ? -widget.voltage : widget.voltage).getId().toUpperCase(), left + 43, top + 48, 0xFAFAFF);
        graphics.m_280488_(font, "AMP: " + widget.amperage, left + 43, top + 56, 0xFAFAFF);
        graphics.m_280488_(font, "SUM: " + (long)widget.amperage * widget.voltage, left + 43, top + 64, 0xFAFAFF);
        return 72;
    }

    @Override
    public void addWidgets(GuiInstance instance, IGuiElement parent) {
        super.addWidgets(instance, parent);
        instance.addWidget(DigitalTransformerWidget.build());
    }

    public static class DigitalTransformerWidget
    extends InfoRenderWidget<DigitalTransformerWidget> {
        public int amperage = 0;
        public long voltage = 0L;

        protected DigitalTransformerWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<DigitalTransformerWidget> renderer) {
            super(gui, parent, renderer);
        }

        @Override
        public void init() {
            super.init();
            BlockEntityDigitalTransformer m = (BlockEntityDigitalTransformer)this.gui.handler;
            this.gui.syncInt(() -> m.amperage, i -> {
                this.amperage = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncLong(() -> m.voltage, i -> {
                this.voltage = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return DigitalTransformerWidget.builder((a, b) -> new DigitalTransformerWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer)((Object)a.handler)));
        }
    }
}

