/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity.multi;

import com.google.common.collect.Lists;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.block.BlockBasic;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.IFakeTileCap;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityHatch;
import org.gtreimagined.gtlib.capability.IComponentHandler;
import org.gtreimagined.gtlib.client.scene.TrackedDummyWorld;
import org.gtreimagined.gtlib.cover.CoverDynamo;
import org.gtreimagined.gtlib.cover.CoverEnergy;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.event.MachineEvent;
import org.gtreimagined.gtlib.machine.types.BasicMultiMachine;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.structure.Structure;
import org.gtreimagined.gtlib.structure.StructureCache;
import org.gtreimagined.gtlib.structure.StructureHandle;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.tesseract.api.forge.TesseractCaps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityBasicMultiMachine<T extends BlockEntityBasicMultiMachine<T>>
extends BlockEntityMachine<T>
implements IAlignment,
IFakeTileCap {
    private final Set<StructureHandle<?>> allHandlers = new ObjectOpenHashSet();
    protected boolean validStructure = false;
    public Long2ObjectOpenHashMap<IStructureElement<T>> structurePositions = new Long2ObjectOpenHashMap();
    private ExtendedFacing extendedFacing;
    private IAlignmentLimits limits = this.getInitialAlignmentLimits();
    protected boolean shouldCheckFirstTick = true;
    protected int checkingStructure = 0;
    public BlockState oldState;
    private Direction facingOverride;
    public Object2ObjectMap<String, List<IComponentHandler>> components = new Object2ObjectOpenHashMap();

    public BlockEntityBasicMultiMachine(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.extendedFacing = ExtendedFacing.of((Direction)this.getFacing(state), (Rotation)Rotation.NORMAL, (Flip)Flip.NONE);
    }

    @Override
    public void onRemove() {
        super.onRemove();
        if (this.m_58904_() != null && !this.m_58904_().m_5776_()) {
            this.allHandlers.forEach(StructureHandle::deregister);
            this.invalidateStructure();
        }
    }

    public IAlignmentLimits getAlignmentLimits() {
        return this.limits;
    }

    public ExtendedFacing getExtendedFacing() {
        return this.extendedFacing;
    }

    public void setExtendedFacing(ExtendedFacing extendedFacing) {
        if (this.extendedFacing != extendedFacing && extendedFacing.getDirection() == this.getFacing()) {
            this.extendedFacing = extendedFacing;
            this.invalidateCaps();
            if (this.isServerSide()) {
                this.invalidateStructure();
                this.checkStructure();
                StructureLibAPI.sendAlignment((IAlignmentProvider)this, (BlockPos)this.m_58899_(), (double)1.0, (ServerLevel)((ServerLevel)this.f_58857_));
            }
        }
    }

    @Override
    public boolean setFacing(Direction side) {
        boolean facingSet = super.setFacing(side);
        if (facingSet) {
            this.extendedFacing = ExtendedFacing.of((Direction)side, (Rotation)this.extendedFacing.getRotation(), (Flip)this.extendedFacing.getFlip());
            if (this.isServerSide()) {
                this.invalidateStructure();
                this.checkStructure();
                StructureLibAPI.sendAlignment((IAlignmentProvider)this, (BlockPos)this.m_58899_(), (double)1.0, (ServerLevel)((ServerLevel)this.f_58857_));
            }
        }
        return facingSet;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> !f.isVerticallyFliped();
    }

    public int maxShares() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onFirstTickClient(Level level, BlockPos pos, BlockState state) {
        StructureLibAPI.queryAlignment((IAlignmentProvider)this);
        super.onFirstTickClient(level, pos, state);
    }

    @Override
    public void onFirstTickServer(Level level, BlockPos pos, BlockState state) {
        this.allHandlers.forEach(StructureHandle::register);
        if (!this.validStructure && this.shouldCheckFirstTick) {
            this.checkStructure();
        }
        super.onFirstTickServer(level, pos, state);
    }

    @Override
    public InteractionResult onInteractServer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable GTToolType type) {
        if (!this.validStructure && this.checkingStructure == 0 && this.checkStructure()) {
            return InteractionResult.SUCCESS;
        }
        return super.onInteractServer(state, world, pos, player, hand, hit, type);
    }

    @Override
    public Direction getFacing() {
        return this.facingOverride != null ? this.facingOverride : super.getFacing();
    }

    public boolean checkStructure() {
        if (this.f_58857_ != null && this.isClientSide()) {
            GTLib.LOGGER.warn("Checking structure on client side");
            Thread.dumpStack();
            return false;
        }
        Structure structure = this.getMachineType().getStructure(this.getMachineTier());
        if (structure == null) {
            return false;
        }
        ++this.checkingStructure;
        List<Pair> oldPositions = this.structurePositions.long2ObjectEntrySet().stream().map(e -> Pair.of((Object)BlockPos.m_122022_((long)e.getLongKey()), (Object)((IStructureElement)e.getValue()))).toList();
        this.structurePositions.clear();
        this.components.clear();
        boolean oldValidStructure = this.validStructure;
        this.validStructure = structure.check(this);
        boolean[] fail = new boolean[]{false};
        structure.getMinMaxMap().forEach((s, p) -> {
            int min = (Integer)p.left();
            int max = (Integer)p.right();
            int size = 0;
            if (this.components.containsKey(s)) {
                size = ((List)this.components.get(s)).size();
            }
            if (size < min || size > max) {
                fail[0] = true;
            }
        });
        if (fail[0]) {
            this.validStructure = false;
        }
        if (this.validStructure) {
            LongList positions = LongList.of((long[])this.structurePositions.keySet().toLongArray());
            if (this.f_58857_ instanceof TrackedDummyWorld) {
                StructureCache.add(this.f_58857_, this.f_58858_, positions);
                StructureCache.validate(this.f_58857_, this.f_58858_, positions, this.maxShares());
                --this.checkingStructure;
                return true;
            }
            if (this.onStructureFormed() && StructureCache.validate(this.m_58904_(), this.m_58899_(), positions, this.maxShares())) {
                this.afterStructureFormed();
                if (this.isServerSide()) {
                    if (this.machineState != MachineState.ACTIVE && this.machineState != MachineState.DISABLED) {
                        this.setMachineState(MachineState.IDLE);
                    }
                    this.recipeHandler.ifPresent(t -> t.onMultiBlockStateChange(true, GTLibConfig.INPUT_RESET_MULTIBLOCK.get()));
                } else {
                    this.components.forEach((k, v) -> v.forEach(c -> Utils.markTileForRenderUpdate(c.getTile())));
                }
                StructureCache.add(this.f_58857_, this.m_58899_(), positions);
            } else {
                this.validStructure = false;
                this.structurePositions.forEach((l, e) -> {
                    BlockPos pos = BlockPos.m_122022_((long)l);
                    e.onStructureFail((Object)this, this.m_58904_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                });
            }
        }
        if (!this.validStructure && !oldPositions.isEmpty()) {
            oldPositions.forEach(p -> ((IStructureElement)p.right()).onStructureFail((Object)this, this.m_58904_(), ((BlockPos)p.left()).m_123341_(), ((BlockPos)p.left()).m_123342_(), ((BlockPos)p.left()).m_123343_()));
        }
        --this.checkingStructure;
        if (this.validStructure != oldValidStructure) {
            this.sidedSync(true);
        }
        return this.validStructure;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (level.m_46467_() % 100L != 0L || this.validStructure || this.checkingStructure != 0 || !FMLEnvironment.production) {
            // empty if block
        }
    }

    public boolean allowsFakeTiles() {
        return false;
    }

    @Override
    public void onBlockUpdate(BlockPos pos) {
        super.onBlockUpdate(pos);
        if (!this.isServerSide()) {
            return;
        }
        if (this.checkingStructure > 0) {
            return;
        }
        if (this.validStructure) {
            long longPos = pos.m_121878_();
            if (this.structurePositions.containsKey(longPos) && !((IStructureElement)this.structurePositions.get(longPos)).check((Object)this, this.m_58904_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) {
                this.invalidateStructure();
            }
        } else {
            this.checkStructure();
        }
    }

    @Override
    public void setMachineState(MachineState newState) {
        if (this.f_58859_) {
            return;
        }
        super.setMachineState(newState);
    }

    public void m_155250_(BlockState p_155251_) {
        BlockState old = this.m_58900_();
        super.m_155250_(p_155251_);
        BlockState newState = this.m_58900_();
        if (!this.getFacing(old).equals((Object)this.getFacing(newState))) {
            if (this.checkingStructure > 0) {
                return;
            }
            this.invalidateStructure();
            this.oldState = old;
            this.facingOverride = Utils.dirFromState(this.oldState);
            this.checkStructure();
            this.oldState = null;
            this.facingOverride = null;
        }
    }

    @Override
    public void onMachineStop() {
        super.onMachineStop();
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
        super.onMachineEvent(event, data);
        if (event == MachineEvent.FLUIDS_OUTPUTTED || event == MachineEvent.ITEMS_OUTPUTTED) {
            this.components.values().forEach(l -> l.forEach(i -> {
                BlockEntity patt12788$temp = i.getTile();
                if (patt12788$temp instanceof BlockEntityHatch) {
                    BlockEntityHatch hatch = (BlockEntityHatch)patt12788$temp;
                    hatch.onMachineEvent(event, data);
                }
            }));
        }
    }

    public void invalidateStructure() {
        if (this.f_58857_ != null && this.isClientSide()) {
            GTLib.LOGGER.warn("Invalidating structure on client side");
            Thread.dumpStack();
            return;
        }
        if (this.m_58904_() instanceof TrackedDummyWorld) {
            return;
        }
        if (!this.validStructure) {
            return;
        }
        ++this.checkingStructure;
        this.validStructure = false;
        if (this.isServerSide() && this.getMachineState() != this.getDefaultMachineState()) {
            this.resetMachine();
        }
        this.structurePositions.forEach((l, e) -> {
            BlockPos pos = BlockPos.m_122022_((long)l);
            e.onStructureFail((Object)this, this.m_58904_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        });
        this.structurePositions.clear();
        this.onStructureInvalidated();
        if (this.isServerSide()) {
            this.recipeHandler.ifPresent(t -> t.onMultiBlockStateChange(false, GTLibConfig.INPUT_RESET_MULTIBLOCK.get()));
            this.components.clear();
        } else {
            this.components.forEach((k, v) -> v.forEach(c -> Utils.markTileForRenderUpdate(c.getTile())));
            this.components.clear();
        }
        StructureCache.remove(this.f_58857_, this.f_58858_);
        this.sidedSync(true);
        --this.checkingStructure;
    }

    public List<IComponentHandler> getComponents(IGTObject object) {
        return this.getComponents(object.getId());
    }

    public List<IComponentHandler> getComponents(String id) {
        List<IComponentHandler> list = (List<IComponentHandler>)this.components.get((Object)id);
        return list != null ? list : Collections.emptyList();
    }

    public List<IComponentHandler> getComponentsByHandlerId(String id) {
        List<IComponentHandler> list = (List<IComponentHandler>)this.components.get((Object)id);
        return list != null ? list : Collections.emptyList();
    }

    public void addComponent(String elementId, IComponentHandler component) {
        List existing = (List)this.components.get((Object)component.getIdForHandlers());
        if (existing == null) {
            this.components.put((Object)component.getIdForHandlers(), (Object)Lists.newArrayList((Object[])new IComponentHandler[]{component}));
        } else {
            existing.add(component);
        }
        if (!elementId.isEmpty() && !elementId.equals(component.getIdForHandlers())) {
            existing = (List)this.components.get((Object)elementId);
            if (existing == null) {
                this.components.put((Object)elementId, (Object)Lists.newArrayList((Object[])new IComponentHandler[]{component}));
            } else {
                existing.add(component);
            }
        }
    }

    public boolean isStructureValid() {
        return this.validStructure;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Structure struc = this.getMachineType().getStructure(this.getMachineTier());
        if (struc != null) {
            // empty if block
        }
    }

    public boolean onStructureFormed() {
        return true;
    }

    public void afterStructureFormed() {
    }

    public void onStructureInvalidated() {
    }

    public Texture getTextureForHatches(Direction dir, BlockPos hatchPos) {
        Texture[] tex = this.getMachineType().getBaseTexture(this.getMachineTier(), this.getMachineState().getTextureState());
        if (tex.length == 1) {
            return tex[0];
        }
        return tex[dir.m_122411_()];
    }

    public BlockBasic getHatchBlock(BlockPos pos) {
        BasicMultiMachine multiMachine;
        Machine<?> machine = this.getMachineType();
        if (machine instanceof BasicMultiMachine && (multiMachine = (BasicMultiMachine)machine).getTextureBlock() != null) {
            return multiMachine.getTextureBlock().apply(this.tier);
        }
        return null;
    }

    @Override
    public MachineState getDefaultMachineState() {
        if (!this.validStructure) {
            return MachineState.INVALID_STRUCTURE;
        }
        return MachineState.IDLE;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128344_("rotation", (byte)this.extendedFacing.getRotation().getIndex());
        tag.m_128344_("flip", (byte)this.extendedFacing.getFlip().getIndex());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (this.getMachineState() == MachineState.INVALID_STRUCTURE) {
            this.shouldCheckFirstTick = false;
        }
        this.extendedFacing = ExtendedFacing.of((Direction)this.extendedFacing.getDirection(), (Rotation)Rotation.byIndex((int)tag.m_128445_("rotation")), (Flip)Flip.byIndex((int)tag.m_128445_("flip")));
    }

    public void addStructureHandle(StructureHandle<?> handle) {
        this.allHandlers.add(handle);
    }

    public <U> LazyOptional<U> getCapabilityFromFake(@NotNull Capability<U> cap, @Nullable Direction side, ICover cover) {
        if (!this.allowsFakeTiles()) {
            return LazyOptional.empty();
        }
        if (cap == TesseractCaps.ENERGY_HANDLER_CAPABILITY && !(cover instanceof CoverDynamo) && !(cover instanceof CoverEnergy)) {
            return LazyOptional.empty();
        }
        return this.getCap(cap, side);
    }
}

