/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.block;

import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.gtreimagined.gtlib.block.BlockBasicSlab;
import org.gtreimagined.gtlib.block.BlockStone;
import org.gtreimagined.gtlib.datagen.builder.GTBlockModelBuilder;
import org.gtreimagined.gtlib.datagen.builder.VariantBlockStateBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTBlockStateProvider;
import org.gtreimagined.gtlib.ore.CobbleStoneType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.registration.ISharedGTObject;
import org.gtreimagined.gtlib.texture.Texture;

public class BlockStoneSlab
extends BlockBasicSlab
implements ISharedGTObject {
    protected String suffix;
    CobbleStoneType type;

    public BlockStoneSlab(CobbleStoneType type, String suffix) {
        super(type.getDomain(), type.getId() + (suffix.isEmpty() ? "" : "_") + suffix + "_slab", BlockStoneSlab.getProps(type));
        this.suffix = suffix;
        this.type = type;
    }

    private static BlockBehaviour.Properties getProps(StoneType type) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_284310_().m_284180_(type.getMapColor()).m_280658_(type.getInstrument()).m_60918_(type.getSoundType()).m_60913_(type.getHardness(), type.getResistence()).m_60922_(BlockStone::notValidSpawn);
        if (type.doesRequireTool()) {
            props.m_60999_();
        }
        return props;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Texture[] getTextures() {
        return new Texture[]{new Texture(this.type.getDomain(), this.type.getBeginningPath() + this.type.getId() + "/" + (this.suffix.isEmpty() ? "stone" : this.suffix))};
    }

    @Override
    public void onBlockModelBuild(Block block, GTBlockStateProvider prov) {
        Texture sideTexture;
        Texture bottomTexture = sideTexture = this.getTextures()[0];
        Texture topTexture = sideTexture;
        ResourceLocation both = prov.existing(this.getDomain(), "block/" + this.getId().replace("_slab", ""));
        GTBlockModelBuilder top = (GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)prov.models().getBuilder(this.getId() + "_top")).parent(prov.existing("minecraft", "block/slab_top"))).texture("bottom", bottomTexture)).texture("top", topTexture)).texture("side", sideTexture);
        GTBlockModelBuilder bottom = (GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)prov.models().getBuilder(this.getId())).parent(prov.existing("minecraft", "block/slab"))).texture("bottom", bottomTexture)).texture("top", topTexture)).texture("side", sideTexture);
        ResourceLocation finalBoth = both;
        prov.getVariantBuilder(block).forAllStates(s -> {
            if (s.m_61143_((Property)f_56353_) == SlabType.DOUBLE) {
                return new VariantBlockStateBuilder.VariantBuilder().modelFile(finalBoth);
            }
            return new VariantBlockStateBuilder.VariantBuilder().modelFile(s.m_61143_((Property)f_56353_) == SlabType.TOP ? top : bottom);
        });
    }

    @Generated
    public String getSuffix() {
        return this.suffix;
    }
}

