package org.gtreimagined.gtlib.datagen.providers;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.block.BlockFrame;
import org.gtreimagined.gtlib.block.BlockStone;
import org.gtreimagined.gtlib.block.BlockStoneSlab;
import org.gtreimagined.gtlib.block.BlockStoneStair;
import org.gtreimagined.gtlib.block.BlockStoneWall;
import org.gtreimagined.gtlib.block.BlockStorage;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.data.GTLibTags;
import org.gtreimagined.gtlib.fluid.GTFluid;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.machine.BlockMultiMachine;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.ore.BlockOre;
import org.gtreimagined.gtlib.ore.BlockOreStone;
import org.gtreimagined.gtlib.pipe.BlockItemPipe;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.util.TagUtils;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

import static org.gtreimagined.gtlib.data.GTMaterialTypes.RAW_ORE_BLOCK;
import static org.gtreimagined.gtlib.util.TagUtils.getBlockTag;
import static org.gtreimagined.gtlib.util.TagUtils.getForgelikeBlockTag;
import static org.gtreimagined.gtlib.util.Utils.getConventionalMaterialType;
import static org.gtreimagined.gtlib.util.Utils.getConventionalStoneType;

public class GTBlockTagProvider extends GTTagProvider<Block> {
    private final boolean replace;

    public GTBlockTagProvider(String providerDomain, String providerName, boolean replace) {
        super(Registries.BLOCK, providerDomain, providerName, "blocks", b -> BuiltInRegistries.BLOCK.getResourceKey(b).get());
        this.replace = replace;
    }

    protected void processTags(String domain) {
        if (domain.equals(Ref.ID)) {
            GTAPI.all(BlockOre.class, o -> {
                this.tag(getForgelikeBlockTag(String.join("", getConventionalStoneType(o.getStoneType()), "_", getConventionalMaterialType(o.getOreType()), "/", o.getMaterial().getId()))).add(o).replace(replace);
                this.tag(getForgelikeBlockTag(String.join("", getConventionalMaterialType(o.getOreType()), "/", o.getMaterial().getId()))).add(o).replace(replace);
                this.tag(getForgelikeBlockTag(getConventionalMaterialType(o.getOreType()))).add(o).replace(replace);
                this.tag(getForgelikeBlockTag(getConventionalStoneType(o.getStoneType()) + "_" + getConventionalMaterialType(o.getOreType()))).add(o).replace(replace);

                if (o.getStoneType() == VanillaStoneTypes.SAND || o.getStoneType() == VanillaStoneTypes.SAND_RED || o.getStoneType() == VanillaStoneTypes.GRAVEL)
                    this.tag(BlockTags.MINEABLE_WITH_SHOVEL).add(o).replace(replace);
                else
                    this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add(o).replace(replace);
                int oreMiningLevel = o.getMaterial().has(MaterialTags.MINING_LEVEL) ? MaterialTags.MINING_LEVEL.getInt(o.getMaterial()) : 0;
                if (o.getOreType() == GTMaterialTypes.SMALL_ORE && oreMiningLevel > 0){
                    oreMiningLevel--;
                }
                int stoneMiningLevel = o.getStoneType().getHarvestLevel();
                int maxLevel = Math.max(oreMiningLevel, stoneMiningLevel);
                if (maxLevel > 0){
                    TagKey<Block> tagKey = fromMiningLevel(maxLevel);
                    if (tagKey != null) {
                        this.tag(tagKey).add(o);
                    }
                }
                if (o.getOreType() == GTMaterialTypes.ORE) this.tag(TagUtils.getForgelikeBlockTag("ores")).add(o);
            });
            GTAPI.all(BlockStone.class, s -> {
                if (s.getSuffix().isEmpty()) {
                    this.tag(TagUtils.getForgelikeBlockTag("stone")).add(s);
                } else if (s.getSuffix().equals("cobble")) {
                    this.tag(TagUtils.getForgelikeBlockTag("cobblestone")).add(s);
                } else if (s.getSuffix().contains("bricks")) {
                    this.tag(BlockTags.STONE_BRICKS).add(s);
                }
                this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add(s).replace(replace);
                int stoneMiningLevel = s.getType().getHarvestLevel();
                if (stoneMiningLevel > 0){
                    TagKey<Block> tagKey = fromMiningLevel(stoneMiningLevel);
                    if (tagKey != null) {
                        this.tag(tagKey).add(s);
                    }
                }
                this.tag(getBlockTag(new ResourceLocation(Ref.ID, "blocks/".concat(s.getId())))).add(s).replace(replace);
            });
            GTAPI.all(BlockStoneWall.class, b -> {
                this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add(b).replace(replace);
                this.tag(BlockTags.WALLS).add(b);
            });
            GTAPI.all(BlockStoneSlab.class, b -> {
                this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add(b).replace(replace);
                this.tag(BlockTags.SLABS).add(b);
            });
            GTAPI.all(BlockStoneStair.class, b -> {
                this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add(b).replace(replace);
                this.tag(BlockTags.STAIRS).add(b);
            });
            GTAPI.all(BlockOreStone.class, s -> {
                String id = "ore_stones/" + s.getMaterial().getId();
                this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add(s).replace(replace);
                this.tag(TagUtils.getForgelikeBlockTag("ores")).add(s);
                this.tag(getForgelikeBlockTag(id)).add(s);
            });
            GTAPI.all(BlockStorage.class, block -> {
                this.tag(block.getType().getTag()).add(block).replace(replace);
                String name = String.join("", block.getType().getTagPrefix(), "/", (block.getType() == RAW_ORE_BLOCK ? "raw_" : ""), block.getMaterial().getId());
                if (block.getMaterial().has(MaterialTags.MINED_WITH_AXE)){
                    this.tag(GTTools.AXE.getToolType()).add(block);
                } else {
                    this.tag(GTTools.PICKAXE.getToolType()).add(block);
                }
                this.tag(getForgelikeBlockTag(name)).add(block);
            });
            GTAPI.all(BlockFrame.class, block -> {
                this.tag(block.getType().getTag()).add(block).replace(replace);
                String name = String.join("", block.getType().getTagPrefix(), "/", block.getMaterial().getId());
                if (block.getMaterial().has(MaterialTags.MINED_WITH_AXE)){
                    this.tag(GTTools.AXE.getToolType()).add(block);
                } else {
                    this.tag(GTTools.WRENCH.getToolType()).add(block).replace(replace);
                }
                this.tag(getForgelikeBlockTag(name)).add(block);
                // if (block.getType() == FRAME) add climbable tag in 1.16
            });
            GTAPI.all(BlockItemPipe.class, pipe -> {
                this.tag(TagUtils.getBlockTag(new ResourceLocation(Ref.ID, "item_pipe"))).add(pipe);
            });
            GTAPI.all(BlockPipe.class, pipe -> {
                this.tag(pipe.getToolType().getToolType()).add(pipe);
                if (pipe.getType().getMaterial().has(MaterialTags.MINED_WITH_AXE)){
                    this.tag(GTTools.AXE.getToolType()).add(pipe);
                }
            });
            GTAPI.all(BlockMachine.class, pipe -> {
                this.tag(pipe.getType().getToolTag()).add(pipe);
            });
            GTAPI.all(BlockMultiMachine.class, pipe -> {
                this.tag(pipe.getType().getToolTag()).add(pipe);
            });
            GTAPI.all(GTFluid.class, f -> {
                this.tag(TagUtils.getBlockTag(new ResourceLocation("replaceable"))).add(f.getFluidBlock());
            });
        }
    }

    public TagKey<Block> fromMiningLevel(int miningLevels){
        return switch (miningLevels){
            case 1 -> BlockTags.NEEDS_STONE_TOOL;
            case 2 -> BlockTags.NEEDS_IRON_TOOL;
            case 3 -> BlockTags.NEEDS_DIAMOND_TOOL;
            case 4 -> GTLibTags.NEEDS_NETHERITE_TOOL;
            case 5 -> GTLibTags.NEEDS_ADAMANTIUM_TOOL;
            default -> null;
        };
    }
}
