package org.gtreimagined.gtlib.client.event;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.behaviour.IBehaviour;
import org.gtreimagined.gtlib.block.IInfoProvider;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.client.RenderHelper;
import org.gtreimagined.gtlib.cover.CoverReplacements;
import org.gtreimagined.gtlib.cover.IHaveCover;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.item.ICustomDurability;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.mixin.client.LevelRendererAccessor;
import org.gtreimagined.gtlib.mixin.client.MultiPlayerGameModeAccessor;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.gtlib.tool.IBasicGTTool;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourAOEBreak;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourExtendedHighlight;
import org.gtreimagined.gtlib.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
@OnlyIn(Dist.CLIENT)
public class ClientEvents {

    private static final Minecraft MC = Minecraft.getInstance();



    public static boolean onBlockHighlight(LevelRenderer levelRenderer, Camera camera, BlockHitResult target, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource) {
        Player player = MC.player;
        Level world = player.getCommandSenderWorld();
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty() || (!(stack.getItem() instanceof IBasicGTTool) && !(stack.getItem() instanceof IHaveCover) && !CoverReplacements.hasReplacement(stack.getItem())))
            return false;
        if (stack.getItem() instanceof IHaveCover || CoverReplacements.hasReplacement(stack.getItem())) {
            if (player.isCrouching()) return false;
            RenderHelper.onDrawHighlight(player, levelRenderer, camera, target, partialTick, poseStack, bufferSource, b -> b instanceof BlockMachine || b instanceof BlockPipe, BehaviourExtendedHighlight.COVER_FUNCTION);
            return true;
        }
        IBasicGTTool item = (IBasicGTTool) stack.getItem();
        GTToolType type = Utils.getToolType(player);
        if (type == null) return false;
        if (player.isCrouching() && type != GTTools.WRENCH && type != GTTools.CROWBAR && type != GTTools.WIRE_CUTTER)
            return false;
        //Perform highlight of wrench
        InteractionResult res = item.onGenericHighlight(player, levelRenderer, camera, target, partialTick, poseStack, bufferSource);
        if (res == InteractionResult.FAIL) {
            return true;
        }
        if (res.shouldSwing()) {
            return false;
        }
        IBehaviour<IBasicGTTool> behaviour = type.getBehaviour("aoe_break");
        if (!(behaviour instanceof BehaviourAOEBreak aoeBreak)) return false;

        BlockPos currentPos = target.getBlockPos();
        BlockState state = world.getBlockState(currentPos);
        if (state.isAir() || !item.genericIsCorrectToolForDrops(stack, state) || item.getDataTag(stack) == null || !item.getDataTag(stack).getBoolean(Ref.KEY_TOOL_BEHAVIOUR_AOE_BREAK)) return false;
        Vec3 viewPosition = camera.getPosition();
        Entity entity = camera.getEntity();
        VertexConsumer builderLines = bufferSource.getBuffer(RenderType.LINES);
        double viewX = viewPosition.x, viewY = viewPosition.y, viewZ = viewPosition.z;
        ImmutableSet<BlockPos> positions = Utils.getHarvestableBlocksToBreak(world, player, item, stack, aoeBreak.getColumn(), aoeBreak.getRow(), aoeBreak.getDepth());
        for (BlockPos nextPos : positions) {
            double modX = nextPos.getX() - viewX, modY = nextPos.getY() - viewY, modZ = nextPos.getZ() - viewZ;
            VoxelShape shape = world.getBlockState(nextPos).getShape(world, nextPos, CollisionContext.of(entity));
            poseStack.pushPose();
            LevelRendererAccessor.renderShape(poseStack, builderLines, shape, modX, modY, modZ, 0,0,0,0.4f);
            poseStack.popPose();
        }
        if (MC.gameMode.isDestroying()) {
            for (BlockPos nextPos : positions) {
                double modX = nextPos.getX() - viewX, modY = nextPos.getY() - viewY, modZ = nextPos.getZ() - viewZ;
                //TODO 1.18
                //int partialDamage = 1;
                int partialDamage = (int) (((MultiPlayerGameModeAccessor)MC.gameMode).getDestroyProgress() * 10) - 1; // destroyProgress = curBlockDamageMP
                poseStack.pushPose();
                poseStack.translate(modX, modY, modZ);
                if (partialDamage == -1)
                    return false; // Not sure why this happens, but it certainly is an edge-case, if we made it so it returns 0 every time it hit -1, the animation will have a delay
                VertexConsumer builderBreak = new SheetedDecalTextureGenerator(bufferSource.getBuffer(ModelBakery.DESTROY_TYPES.get(partialDamage)), poseStack.last().pose(), poseStack.last().normal(), 1.0f);
                MC.getBlockRenderer().renderBreakingTexture(world.getBlockState(nextPos), nextPos, world, poseStack, builderBreak);
                // MC.getBlockRendererDispatcher().renderModel(world.getBlockState(nextPos), nextPos, world, matrix, builderBreak, ModelDataManager.getModelData(world, nextPos));
                poseStack.popPose();
            }
        }
        return false;
    }

    // Needs some work, won't work in 3rd person also, needs special ItemModel properties
    public static void onPlayerTickEnd(Player player) {
        if (player == null || player.getMainHandItem().isEmpty()) return;
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof IGTTool)) return;
        IGTTool item = (IGTTool) stack.getItem();
        if (item.getGTToolType().getUseAction() != UseAnim.NONE && player.swinging) {
            //todo abstract this
            //item.getItem().onUsingTick(stack, player, stack.getCount());
            //player.swingProgress = player.prevSwingProgress;
        }
    }

    public static void onRenderDebugInfo(ArrayList<String> left) {
        if (!MC.options.renderDebug || MC.hitResult == null || MC.hitResult.getType() != HitResult.Type.BLOCK)
            return;
        Level world = Minecraft.getInstance().level;
        if (world == null) return;
        BlockPos pos = BlockPos.containing( MC.hitResult.getLocation());
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof IInfoProvider info) {
            left.add("");
            left.add(ChatFormatting.AQUA + "[GTLib Debug Server]");
            left.addAll(info.getInfo(new ObjectArrayList<>(), world, state, pos, false));
        }
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof BlockEntityBase<?> b) {
            left.addAll(b.getInfo(false));
        }
        if (MC.player.isCrouching()) {
            left.add("");
            left.add(ChatFormatting.AQUA + "[GTLib Debug Client]");
        }
    }

    //TODO still needed?
    public static void onItemTooltip(ItemStack stack, List<Component> tooltips, Player player, TooltipFlag flag) {
        if (stack.getItem() instanceof ICustomDurability tool){
            int j = -1;
            for (int i = 0; i < tooltips.size(); i++) {
                Component component = tooltips.get(i);
                if (component.getContents() instanceof TranslatableContents translatable){
                    if (translatable.getKey().equals("item.durability")){
                        j = i;
                        break;
                    }
                }
            }
            if (j != -1){
                tooltips.remove(j);
            }
        }
        if (flag.isAdvanced() && Ref.SHOW_ITEM_TAGS) {
            Collection<ResourceLocation> tags = Collections.emptyList(); //ItemTags.getAllTags().getMatchingTags(e.getItemStack().getItem());
            if (!tags.isEmpty()) {
                tooltips.add(Utils.literal("Tags:").withStyle(ChatFormatting.DARK_GRAY));
                for (ResourceLocation loc : tags) {
                    tooltips.add(Utils.literal(loc.toString()).withStyle(ChatFormatting.DARK_GRAY));
                }
            }
        }
    }

    public static double lastDelta;
    public static void onGuiMouseScrollPre(double lastScrollDelta) {
        lastDelta = lastScrollDelta;
    }

    public static boolean leftDown;
    public static boolean rightDown;
    public static boolean middleDown;
    public static void onGuiMouseClickPre(int button) {
        switch (button){
            case 0 -> leftDown = true;
            case 1 -> rightDown = true;
            case 2 -> middleDown = true;
        }
    }

    public static void onGuiMouseReleasedPre(int button) {
        switch (button){
            case 0 -> leftDown = false;
            case 1 -> rightDown = false;
            case 2 -> middleDown = false;
        }
    }
}
