/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.worldgen.feature;

import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.worldgen.GTLibConfiguredFeatures;
import org.gtreimagined.gtlib.worldgen.WorldGenHelper;
import org.gtreimagined.gtlib.worldgen.bedrockore.BedrockVein;
import org.gtreimagined.gtlib.worldgen.bedrockore.BedrockVeinData;
import org.gtreimagined.gtlib.worldgen.feature.GTFeature;

public class FeatureBedrockVeins
extends GTFeature<NoneFeatureConfiguration> {
    public FeatureBedrockVeins() {
        super(NoneFeatureConfiguration.f_67815_, BedrockVein.class);
    }

    @Override
    public String getId() {
        return "bedrock_veins";
    }

    @Override
    public boolean enabled() {
        return GTLibConfig.BEDROCK_VEINS.get() && !BedrockVeinData.INSTANCE.getVeins().isEmpty();
    }

    @Override
    public void init() {
    }

    @Override
    public void build(ResourceLocation name, Biome.ClimateSettings climate, BiomeSpecialEffects effects, BiomeGenerationSettingsBuilder gen, MobSpawnSettings.Builder spawns, Registry<PlacedFeature> placedFeatureRegistry) {
        gen.m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.getPlacedFeatureFromKey(placedFeatureRegistry, GTLibConfiguredFeatures.BEDROCK_VEINS));
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctxt) {
        WorldGenLevel world = ctxt.m_159774_();
        BlockPos pos = ctxt.m_159777_();
        RandomSource rand = ctxt.m_225041_();
        Collection veins = BedrockVeinData.INSTANCE.getVeins((Level)world.m_6018_()).values();
        if (veins.isEmpty()) {
            return false;
        }
        for (BedrockVein vein : veins) {
            if (!FeatureBedrockVeins.generateBedrockVein(vein, (LevelAccessor)world, pos.m_123341_(), pos.m_123343_(), pos.m_123341_() + 16, pos.m_123343_() + 16, rand)) continue;
            return true;
        }
        return false;
    }

    public static boolean generateBedrockVein(BedrockVein vein, LevelAccessor level, int minX, int minZ, int maxX, int maxZ, RandomSource random) {
        if (random.m_188503_(vein.probability()) != 0) {
            return false;
        }
        if (!FeatureBedrockVeins.generateVein(vein.material(), level, minX, minZ, random)) {
            return false;
        }
        if (vein.indicatorRocks() || vein.indicatorFlowers()) {
            boolean tFlowers = vein.indicatorFlowers() && vein.flower() != Blocks.f_50016_;
            boolean tRocks = vein.indicatorRocks() && vein.material().has(GTMaterialTypes.BEARING_ROCK);
            for (int tD = 4; tD <= 16; tD *= 2) {
                try {
                    for (int i = 0; i < tD; ++i) {
                        int tX = minX + random.m_188503_(tD * 2) + 8 - tD;
                        int tZ = minZ + random.m_188503_(tD * 2) + 8 - tD;
                        int y = Math.min(level.m_6924_(Heightmap.Types.OCEAN_FLOOR, tX, tZ), level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, tX, tZ));
                        BlockPos offset = new BlockPos(tX, y, tZ);
                        BlockState below = level.m_8055_(new BlockPos(tX, y - 1, tZ));
                        if (tFlowers && (!tRocks || random.m_188503_(4) > 0) && vein.flower().m_7898_(vein.flower().m_49966_(), (LevelReader)level, offset)) {
                            level.m_7731_(offset, vein.flower().m_49966_(), 0);
                            continue;
                        }
                        if (!tRocks || below.m_60795_() || below == WorldGenHelper.WATER_STATE || !GTLibConfig.STONE_LAYER_ROCKS.get() || !GTLibConfig.SURFACE_ROCKS.get()) continue;
                        WorldGenHelper.setRock(level, offset, vein.material(), Blocks.f_50752_.m_49966_(), 1);
                    }
                    continue;
                }
                catch (Throwable e) {
                    GTLib.LOGGER.error((Object)e);
                }
            }
        }
        return true;
    }

    public static boolean generateVein(Material material, LevelAccessor level, int minX, int minZ, RandomSource random) {
        try {
            int tZ;
            int tX;
            Block tStone = level.m_8055_(new BlockPos(minX + 8, level.m_141937_(), minZ + 8)).m_60734_();
            if (tStone != Blocks.f_50752_) {
                return false;
            }
            for (int tX2 = 5; tX2 < 11; ++tX2) {
                block17: for (int tZ2 = 5; tZ2 < 11; ++tZ2) {
                    switch (random.m_188503_(6)) {
                        case 0: {
                            WorldGenHelper.setState(level, new BlockPos(minX + tX2, level.m_141937_(), minZ + tZ2), ((MaterialTypeBlock.IOreGetter)GTMaterialTypes.ORE.get()).get(material, VanillaStoneTypes.BEDROCK).asState());
                            continue block17;
                        }
                        case 1: 
                        case 2: {
                            WorldGenHelper.setState(level, new BlockPos(minX + tX2, level.m_141937_(), minZ + tZ2), ((MaterialTypeBlock.IOreGetter)GTMaterialTypes.SMALL_ORE.get()).get(material, VanillaStoneTypes.BEDROCK).asState());
                        }
                    }
                }
            }
            WorldGenHelper.setState(level, new BlockPos(minX + 6 + random.m_188503_(4), level.m_141937_(), minZ + 6 + random.m_188503_(4)), ((MaterialTypeBlock.IOreGetter)GTMaterialTypes.ORE.get()).get(material, VanillaStoneTypes.BEDROCK).asState());
            tStone = Blocks.f_152550_;
            int yOffset = level.m_141937_() < 0 ? Math.abs(level.m_141937_()) : -level.m_141937_();
            int[] tD1 = new int[]{5, 4, 2, 1, 0, 2, 5};
            int[] tD2 = new int[]{11, 12, 14, 15, 16, 14, 11};
            for (int tY = 1; tY < tD1.length; ++tY) {
                for (tX = tD1[tY]; tX < tD2[tY]; ++tX) {
                    block20: for (tZ = tD1[tY]; tZ < tD2[tY]; ++tZ) {
                        level.m_7731_(new BlockPos(minX + tX, tY - yOffset, minZ + tZ), tStone.m_49966_(), 0);
                        switch (random.m_188503_(6)) {
                            case 0: {
                                WorldGenHelper.setOre(level, new BlockPos(minX + tX, tY - yOffset, minZ + tZ), material, GTMaterialTypes.ORE);
                                continue block20;
                            }
                            case 1: 
                            case 2: {
                                WorldGenHelper.setOre(level, new BlockPos(minX + tX, tY - yOffset, minZ + tZ), material, GTMaterialTypes.SMALL_ORE);
                            }
                        }
                    }
                }
            }
            int i = 5 + random.m_188503_(3);
            block21: while (i-- > 0) {
                tX = 5 + random.m_188503_(6);
                tZ = 5 + random.m_188503_(6);
                int tW = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, minX + tX, minZ + tZ);
                for (int tY = tD1.length - yOffset; tY < tW; ++tY) {
                    switch (random.m_188503_(7)) {
                        case 0: {
                            tW = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, minX + ++tX, minZ + tZ);
                            break;
                        }
                        case 1: {
                            tW = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, minX + --tX, minZ + tZ);
                            break;
                        }
                        case 2: {
                            tW = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, minX + tX, minZ + ++tZ);
                            break;
                        }
                        case 3: {
                            tW = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, minX + tX, minZ + --tZ);
                        }
                    }
                    if (tY >= tW) continue block21;
                    if (tX <= 0 || tX >= 15 || tZ <= 0 || tZ >= 15) {
                        WorldGenHelper.setOre(level, new BlockPos(minX + tX, tY, minZ + tZ), material, GTMaterialTypes.SMALL_ORE);
                        continue block21;
                    }
                    if (random.m_188503_(3) == 0) continue;
                    WorldGenHelper.setOre(level, new BlockPos(minX + tX, tY, minZ + tZ), material, GTMaterialTypes.SMALL_ORE);
                }
            }
            return true;
        }
        catch (Throwable e) {
            GTLib.LOGGER.error((Object)e);
            return false;
        }
    }
}

