/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.worldgen;

import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.registration.RegistrationEvent;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.gtlib.worldgen.IGTWorldgenFunction;
import org.gtreimagined.gtlib.worldgen.WorldGenHelper;
import org.gtreimagined.gtlib.worldgen.feature.FeatureBedrockVeins;
import org.gtreimagined.gtlib.worldgen.feature.FeatureOre;
import org.gtreimagined.gtlib.worldgen.feature.FeatureSmallOres;
import org.gtreimagined.gtlib.worldgen.feature.FeatureStoneLayer;
import org.gtreimagined.gtlib.worldgen.feature.FeatureVanillaVeins;
import org.gtreimagined.gtlib.worldgen.feature.FeatureVein;
import org.gtreimagined.gtlib.worldgen.feature.GTFeature;
import org.gtreimagined.gtlib.worldgen.feature.IGTFeature;
import org.jetbrains.annotations.NotNull;

public class GTLibWorldGenerator {
    static final GTFeature<NoneFeatureConfiguration> SMALL_ORE = new FeatureSmallOres();
    static final GTFeature<NoneFeatureConfiguration> VANILLA_ORE = new FeatureVanillaVeins();
    static final GTFeature<NoneFeatureConfiguration> VEIN_LAYER = new FeatureVein();
    static final GTFeature<NoneFeatureConfiguration> ORE = new FeatureOre();
    static final GTFeature<NoneFeatureConfiguration> STONE_LAYER = new FeatureStoneLayer();
    static final GTFeature<NoneFeatureConfiguration> BEDROCK_VEINS = new FeatureBedrockVeins();

    public static void preinit() {
    }

    public static void init() {
        GTAPI.runLaterCommon(() -> {
            WorldGenHelper.init();
            try {
                GTAPI.all(GTFeature.class).stream().filter(GTFeature::enabled).forEach(f -> f.init());
            }
            catch (Exception ex) {
                GTLib.LOGGER.warn("Caught exception during World generator later init: " + ex.toString());
            }
        });
    }

    public static void setup() {
        GTLib.LOGGER.info("GTLib WorldGen Initialization Stage...");
        GTAPI.onRegistration(RegistrationEvent.WORLDGEN_INIT);
    }

    private static void removeStoneFeatures(BiomeGenerationSettingsBuilder builder) {
        GTLibWorldGenerator.removeDecoratedFeatureFromAllBiomes(builder, GenerationStep.Decoration.UNDERGROUND_ORES, Feature.f_65731_, Blocks.f_50334_.m_49966_(), Blocks.f_50122_.m_49966_(), Blocks.f_50228_.m_49966_(), Blocks.f_152496_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_49994_.m_49966_());
    }

    private static void removeOreFeatures(BiomeGenerationSettingsBuilder builder) {
        GTLibWorldGenerator.removeDecoratedFeatureFromAllBiomes(builder, GenerationStep.Decoration.UNDERGROUND_ORES, Feature.f_65731_, Blocks.f_49997_.m_49966_(), Blocks.f_49996_.m_49966_(), Blocks.f_49995_.m_49966_(), Blocks.f_152505_.m_49966_(), Blocks.f_50264_.m_49966_(), Blocks.f_50173_.m_49966_(), Blocks.f_50059_.m_49966_(), Blocks.f_50089_.m_49966_());
        GTLibWorldGenerator.removeDecoratedFeatureFromAllBiomes(builder, GenerationStep.Decoration.UNDERGROUND_ORES, Feature.f_65731_, Blocks.f_152469_.m_49966_(), Blocks.f_152468_.m_49966_(), Blocks.f_152467_.m_49966_(), Blocks.f_152506_.m_49966_(), Blocks.f_152479_.m_49966_(), Blocks.f_152473_.m_49966_(), Blocks.f_152472_.m_49966_(), Blocks.f_152474_.m_49966_());
        GTLibWorldGenerator.removeDecoratedFeatureFromAllBiomes(builder, GenerationStep.Decoration.UNDERGROUND_ORES, Feature.f_159727_, Blocks.f_49996_.m_49966_(), Blocks.f_152505_.m_49966_(), Blocks.f_152468_.m_49966_(), Blocks.f_152506_.m_49966_());
    }

    public static void removeDecoratedFeatureFromAllBiomes(BiomeGenerationSettingsBuilder builder, @NotNull GenerationStep.Decoration stage, @NotNull Feature<?> featureToRemove, BlockState ... states) {
        if (states.length == 0) {
            Utils.onInvalidData("No BlockStates specified to be removed!");
        }
        Set<BlockState> set = Set.of(states);
        builder.getFeatures(stage).removeIf(f -> GTLibWorldGenerator.isDecoratedFeatureDisabled((ConfiguredFeature)((PlacedFeature)f.m_203334_()).f_191775_().m_203334_(), featureToRemove, set));
    }

    public static void removeDecoratedFeaturesFromBiome(@NotNull Biome biome, @NotNull GenerationStep.Decoration stage, @NotNull Feature<?> featureToRemove, BlockState ... states) {
        if (states.length == 0) {
            Utils.onInvalidData("No BlockStates specified to be removed!");
        }
        GTAPI.runLaterCommon(() -> {
            for (BlockState blockState : states) {
            }
        });
    }

    public static boolean isDecoratedFeatureDisabled(@NotNull ConfiguredFeature<?, ?> configuredFeature, @NotNull Feature<?> featureToRemove, @NotNull Set<BlockState> state) {
        FeatureConfiguration featureConfiguration = configuredFeature.f_65378_();
        if (featureConfiguration instanceof OreConfiguration) {
            OreConfiguration config = (OreConfiguration)featureConfiguration;
            return config.f_161005_.stream().anyMatch(t -> state.contains(t.f_161033_));
        }
        return false;
    }

    public static void reloadEvent(ResourceLocation name, Biome.ClimateSettings climate, BiomeSpecialEffects effects, BiomeGenerationSettingsBuilder gen, MobSpawnSettings.Builder spawns, Registry<PlacedFeature> placedFeatureRegistry) {
        GTAPI.all(IGTFeature.class, t -> t.build(name, climate, effects, gen, spawns, placedFeatureRegistry));
        GTLibWorldGenerator.handleFeatureRemoval(gen);
        GTAPI.all(IGTWorldgenFunction.class, t -> t.build(name, climate, effects, gen, spawns, placedFeatureRegistry));
    }

    private static void handleFeatureRemoval(BiomeGenerationSettingsBuilder gen) {
        if (GTLibConfig.VANILLA_ORE_GEN.get()) {
            GTLibWorldGenerator.removeOreFeatures(gen);
        }
        if (GTLibConfig.VANILLA_STONE_GEN.get()) {
            GTLibWorldGenerator.removeStoneFeatures(gen);
        }
    }
}

