/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool.behaviour;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.event.ForgeEventFactory;
import org.gtreimagined.gtlib.behaviour.IItemUse;
import org.gtreimagined.gtlib.tool.IBasicGTTool;
import org.gtreimagined.gtlib.util.Utils;

public class BehaviourLogStripping
implements IItemUse<IBasicGTTool> {
    public static final BehaviourLogStripping INSTANCE = new BehaviourLogStripping();
    private static final Object2ObjectOpenHashMap<Block, Block> STRIPPING_MAP = new Object2ObjectOpenHashMap();

    @Override
    public String getId() {
        return "log_stripping";
    }

    @Override
    public InteractionResult onItemUse(IBasicGTTool instance, UseOnContext c) {
        BlockState state = c.m_43725_().m_8055_(c.m_8083_());
        BlockState stripped = this.getToolModifiedState(state, c, "axe_strip");
        if (stripped != null) {
            if (state.m_61138_((Property)RotatedPillarBlock.f_55923_) && stripped.m_61138_((Property)RotatedPillarBlock.f_55923_)) {
                stripped = (BlockState)stripped.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)));
            }
            c.m_43725_().m_5594_(c.m_43723_(), c.m_8083_(), SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            c.m_43725_().m_46597_(c.m_8083_(), stripped);
            Utils.damageStack(c.m_43722_(), (LivingEntity)c.m_43723_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private BlockState getToolModifiedState(BlockState originalState, UseOnContext context, String action) {
        BlockState eventState = ForgeEventFactory.onToolUse((BlockState)originalState, (UseOnContext)context, (ToolAction)ToolAction.get((String)action), (boolean)false);
        if (eventState != originalState) {
            return eventState;
        }
        Block stripped = (Block)STRIPPING_MAP.get((Object)originalState.m_60734_());
        if (stripped == null) {
            return null;
        }
        BlockState state = stripped.m_49966_();
        for (Property property : originalState.m_61147_()) {
            if (!state.m_61138_(property)) continue;
            state = (BlockState)state.m_61124_(property, originalState.m_61143_(property));
        }
        return state;
    }

    public static void addStrippedBlock(Block from, Block to) {
        STRIPPING_MAP.put((Object)from, (Object)to);
    }

    static {
        new ImmutableMap.Builder().put((Object)Blocks.f_50011_, (Object)Blocks.f_50044_).put((Object)Blocks.f_49999_, (Object)Blocks.f_50010_).put((Object)Blocks.f_50043_, (Object)Blocks.f_50049_).put((Object)Blocks.f_50004_, (Object)Blocks.f_50009_).put((Object)Blocks.f_50015_, (Object)Blocks.f_50048_).put((Object)Blocks.f_50003_, (Object)Blocks.f_50008_).put((Object)Blocks.f_50013_, (Object)Blocks.f_50046_).put((Object)Blocks.f_50001_, (Object)Blocks.f_50006_).put((Object)Blocks.f_50014_, (Object)Blocks.f_50047_).put((Object)Blocks.f_50002_, (Object)Blocks.f_50007_).put((Object)Blocks.f_50012_, (Object)Blocks.f_50045_).put((Object)Blocks.f_50000_, (Object)Blocks.f_50005_).build().forEach(BehaviourLogStripping::addStrippedBlock);
    }
}

