/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.structure;

import com.google.common.collect.ImmutableMap;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.machine.types.HatchMachine;
import org.gtreimagined.gtlib.structure.GTLibStructureUtility;
import org.gtreimagined.gtlib.structure.Structure;
import org.gtreimagined.gtlib.util.int2;
import org.gtreimagined.gtlib.util.int3;

public class StructureBuilder<T extends BlockEntityBasicMultiMachine<T>> {
    public StructureDefinition.Builder<T> STRUCTURE_BUILDER = StructureDefinition.builder();
    private Map<String, StructurePartBuilder> parts = new Object2ObjectLinkedOpenHashMap();
    private final Object2ObjectMap<Character, IStructureElement<T>> elementLookup = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, Pair<Integer, Integer>> minMaxMap = new Object2ObjectOpenHashMap();
    private Structure.StructurePartCheckCallback<T> callback = (structureDefinition, tile, part, i, newOffset) -> structureDefinition.check((Object)tile, part, tile.m_58904_(), tile.getExtendedFacing(), tile.m_58899_().m_123341_(), tile.m_58899_().m_123342_(), tile.m_58899_().m_123343_(), newOffset.m_123341_(), newOffset.m_123342_(), newOffset.m_123343_(), !tile.isStructureValid());
    private int3 offset = new int3(0, 0, 0);
    private Set<Direction> allowedFacings = Set.of(Ref.DIRS);

    public StructurePartBuilder part(String name) {
        return new StructurePartBuilder(name);
    }

    public StructureBuilder<T> atElement(char key, IStructureElement<T> element) {
        this.elementLookup.put((Object)Character.valueOf(key), element);
        return this;
    }

    public StructureBuilder<T> at(char key, Object ... objects) {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Object object : objects) {
            TagKey tag;
            if (object instanceof HatchMachine) {
                HatchMachine machine = (HatchMachine)object;
                elements.add(GTLibStructureUtility.ofHatch(machine));
                continue;
            }
            if (object instanceof Block) {
                Block block = (Block)object;
                elements.add(StructureUtility.ofBlock((Block)block));
                continue;
            }
            if (object instanceof TagKey && (tag = (TagKey)object).m_207645_(Registries.f_256747_)) {
                elements.add(StructureUtility.ofBlock((TagKey)((TagKey)tag.m_207647_(Registries.f_256747_).get())));
                continue;
            }
            if (!(object instanceof IStructureElement)) continue;
            IStructureElement element = (IStructureElement)object;
            elements.add(element);
        }
        this.elementLookup.put((Object)Character.valueOf(key), (Object)StructureUtility.ofChain(elements));
        return this;
    }

    public StructureBuilder<T> at(char key, Collection<?> objects) {
        return this.at(key, objects.toArray(new Object[0]));
    }

    public StructureBuilder<T> facings(Direction ... faces) {
        this.allowedFacings = Set.of(faces);
        return this;
    }

    public StructureBuilder<T> min(int min, HatchMachine ... machines) {
        for (HatchMachine machine : machines) {
            this.minMaxMap.put((Object)machine.getIdForHandlers(), (Object)Pair.of((Object)min, (Object)Integer.MAX_VALUE));
        }
        return this;
    }

    public StructureBuilder<T> exact(int exact, HatchMachine ... machines) {
        for (HatchMachine machine : machines) {
            this.minMaxMap.put((Object)machine.getIdForHandlers(), (Object)Pair.of((Object)exact, (Object)exact));
        }
        return this;
    }

    public StructureBuilder<T> minMax(int min, int max, HatchMachine ... machines) {
        for (HatchMachine machine : machines) {
            this.minMaxMap.put((Object)machine.getIdForHandlers(), (Object)Pair.of((Object)min, (Object)max));
        }
        return this;
    }

    public StructureBuilder<T> max(int max, HatchMachine ... machines) {
        for (HatchMachine machine : machines) {
            this.minMaxMap.put((Object)machine.getIdForHandlers(), (Object)Pair.of((Object)0, (Object)max));
        }
        return this;
    }

    public StructureBuilder<T> offset(int x, int y, int z) {
        this.offset = new int3(x, y, z);
        return this;
    }

    public StructureBuilder<T> setStructurePartCheckCallback(Structure.StructurePartCheckCallback<T> callback) {
        this.callback = callback;
        return this;
    }

    public Structure<T> build() {
        ImmutableMap.Builder minMaxMap = ImmutableMap.builder();
        minMaxMap.putAll(this.minMaxMap);
        ImmutableMap.Builder structureParts = ImmutableMap.builder();
        this.parts.forEach((k, v) -> structureParts.put(k, (Object)Pair.of((Object)new int2(v.min, v.max), v.offset)));
        this.elementLookup.forEach((c, e) -> this.STRUCTURE_BUILDER.addElement(c.charValue(), StructureUtility.onElementPass((el, t, w, x, y, z) -> t.structurePositions.put(new BlockPos(x, y, z).m_121878_(), e), (IStructureElement)e)));
        return new Structure<T>(this.STRUCTURE_BUILDER.build(), (ImmutableMap<String, Pair<int2, BiFunction<Integer, int3, int3>>>)structureParts.build(), (ImmutableMap<String, Pair<Integer, Integer>>)minMaxMap.build(), this.offset, this.callback);
    }

    public class StructurePartBuilder {
        private final String name;
        private final List<String[]> slices = new ObjectArrayList();
        private int min = 1;
        private int max = 1;
        private String partToCheckOnFail;
        BiFunction<Integer, int3, int3> offset = (i, p) -> p;

        public StructurePartBuilder(String name) {
            this.name = name;
        }

        public StructurePartBuilder of(String ... slices) {
            this.slices.add(slices);
            return this;
        }

        public StructurePartBuilder of(int i) {
            this.slices.add(this.slices.get(i));
            return this;
        }

        public StructurePartBuilder min(int i) {
            if (i < 0) {
                throw new IllegalArgumentException("i must be >= 0!");
            }
            this.min = i;
            return this;
        }

        public StructurePartBuilder max(int i) {
            if (i <= 0) {
                throw new IllegalArgumentException("i must be > 0!");
            }
            this.max = i;
            return this;
        }

        public StructurePartBuilder offsetFunction(BiFunction<Integer, int3, int3> function) {
            this.offset = function;
            return this;
        }

        public StructurePartBuilder checkOnFail(String partName) {
            this.partToCheckOnFail = partName;
            return this;
        }

        public StructureBuilder<T> build() {
            StructureBuilder.this.STRUCTURE_BUILDER.addShape(this.name, StructureUtility.transpose((String[][])((String[][])this.slices.toArray(x$0 -> new String[x$0][]))));
            StructureBuilder.this.parts.put(this.name, this);
            return StructureBuilder.this;
        }
    }
}

